/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import com.android.aapt.Resources;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.android.AndroidResourcesMap;
import jadx.core.xmlgen.CommonProtoParser;
import jadx.core.xmlgen.XMLChar;
import jadx.core.xmlgen.XmlDeobf;
import jadx.core.xmlgen.XmlGenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ProtoXMLParser
extends CommonProtoParser {
    private Map<String, String> nsMap;
    private final Map<String, String> tagAttrDeobfNames = new HashMap<String, String>();
    private ICodeWriter writer;
    private final RootNode rootNode;
    private String currentTag;
    private String appPackageName;

    public ProtoXMLParser(RootNode rootNode) {
        this.rootNode = rootNode;
    }

    public synchronized ICodeInfo parse(InputStream inputStream) throws IOException {
        this.nsMap = new HashMap<String, String>();
        this.writer = this.rootNode.makeCodeWriter();
        this.writer.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.decode(this.decodeProto(inputStream));
        this.nsMap = null;
        return this.writer.finish();
    }

    private void decode(Resources.XmlNode n) throws IOException {
        if (n.hasSource()) {
            this.writer.attachSourceLine(n.getSource().getLineNumber());
        }
        this.writer.add(StringUtils.escapeXML(n.getText().trim()));
        if (n.hasElement()) {
            this.decode(n.getElement());
        }
    }

    private void decode(Resources.XmlElement e) throws IOException {
        int i;
        String tag = this.deobfClassName(e.getName());
        this.currentTag = tag = this.getValidTagAttributeName(tag);
        this.writer.startLine('<').add(tag);
        for (int i2 = 0; i2 < e.getNamespaceDeclarationCount(); ++i2) {
            this.decode(e.getNamespaceDeclaration(i2));
        }
        HashSet<String> attrCache = new HashSet<String>();
        for (i = 0; i < e.getAttributeCount(); ++i) {
            this.decode(e.getAttribute(i), attrCache);
        }
        if (e.getChildCount() > 0) {
            this.writer.add('>');
            this.writer.incIndent();
            for (i = 0; i < e.getChildCount(); ++i) {
                HashMap<String, String> oldNsMap = new HashMap<String, String>(this.nsMap);
                this.decode(e.getChild(i));
                this.nsMap = oldNsMap;
            }
            this.writer.decIndent();
            this.writer.startLine("</").add(tag).add('>');
        } else {
            this.writer.add("/>");
        }
    }

    private void decode(Resources.XmlAttribute a, Set<String> attrCache) {
        String name = this.getAttributeFullName(a);
        if (XmlDeobf.isDuplicatedAttr(name, attrCache)) {
            return;
        }
        String value = this.deobfClassName(this.getAttributeValue(a));
        this.writer.add(' ').add(name).add("=\"").add(StringUtils.escapeXML(value)).add('\"');
        this.memorizePackageName(name, value);
    }

    private String getAttributeFullName(Resources.XmlAttribute a) {
        String attrName;
        String namespaceUri = a.getNamespaceUri();
        String namespace = null;
        if (!namespaceUri.isEmpty()) {
            namespace = this.nsMap.get(namespaceUri);
        }
        if ((attrName = a.getName()).isEmpty()) {
            int resId = a.getResourceId();
            String str = AndroidResourcesMap.getResName(resId);
            if (str != null) {
                namespace = this.nsMap.get("http://schemas.android.com/apk/res/android");
                int typeEnd = str.indexOf(47);
                attrName = typeEnd != -1 ? str.substring(typeEnd + 1) : str;
            } else {
                attrName = "_unknown_";
            }
        }
        return namespace != null ? namespace + ":" + attrName : attrName;
    }

    private String getAttributeValue(Resources.XmlAttribute a) {
        if (!a.getValue().isEmpty()) {
            return a.getValue();
        }
        return this.parse(a.getCompiledItem());
    }

    private void decode(Resources.XmlNamespace n) {
        String prefix = n.getPrefix();
        String uri = n.getUri();
        this.nsMap.put(uri, prefix);
        this.writer.add(" xmlns:").add(prefix).add("=\"").add(uri).add('\"');
    }

    private void memorizePackageName(String attrName, String attrValue) {
        if ("manifest".equals(this.currentTag) && "package".equals(attrName)) {
            this.appPackageName = attrValue;
        }
    }

    private String deobfClassName(String className) {
        String newName = XmlDeobf.deobfClassName(this.rootNode, className, this.appPackageName);
        if (newName != null) {
            return newName;
        }
        return className;
    }

    private String getValidTagAttributeName(String originalName) {
        String generated;
        if (XMLChar.isValidName(originalName)) {
            return originalName;
        }
        if (this.tagAttrDeobfNames.containsKey(originalName)) {
            return this.tagAttrDeobfNames.get(originalName);
        }
        while (this.tagAttrDeobfNames.containsValue(generated = ProtoXMLParser.generateTagAttrName())) {
        }
        this.tagAttrDeobfNames.put(originalName, generated);
        return generated;
    }

    private static String generateTagAttrName() {
        int length = 6;
        Random r = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 6; ++i) {
            sb.append((char)(r.nextInt(26) + 97));
        }
        return sb.toString();
    }

    private Resources.XmlNode decodeProto(InputStream inputStream) throws IOException {
        return Resources.XmlNode.parseFrom((byte[])XmlGenUtils.readData(inputStream));
    }
}

