/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.xmlgen.ParserStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class BinaryXMLStrings {
    private final int stringCount;
    private final long stringsStart;
    private final ByteBuffer buffer;
    private final boolean isUtf8;
    private final Map<Integer, String> cache = new HashMap<Integer, String>();

    public BinaryXMLStrings() {
        this.stringCount = 0;
        this.stringsStart = 0L;
        this.buffer = ByteBuffer.allocate(0);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.isUtf8 = false;
    }

    public BinaryXMLStrings(int stringCount, long stringsStart, byte[] buffer, boolean isUtf8) {
        this.stringCount = stringCount;
        this.stringsStart = stringsStart;
        this.buffer = ByteBuffer.wrap(buffer);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.isUtf8 = isUtf8;
    }

    public String get(int id) {
        String cached = this.cache.get(id);
        if (cached != null) {
            return cached;
        }
        long offset = this.stringsStart + (long)this.buffer.getInt(id * 4);
        String extracted = this.isUtf8 ? BinaryXMLStrings.extractString8(this.buffer.array(), (int)offset) : BinaryXMLStrings.extractString16(this.buffer.array(), (int)offset);
        this.cache.put(id, extracted);
        return extracted;
    }

    public void put(int id, String content) {
        this.cache.put(id, content);
    }

    public int size() {
        return this.stringCount;
    }

    private static String extractString8(byte[] strArray, int offset) {
        int len;
        if (offset >= strArray.length) {
            return "STRING_DECODE_ERROR";
        }
        int start = offset + BinaryXMLStrings.skipStrLen8(strArray, offset);
        if ((len = strArray[start++]) == 0) {
            return "";
        }
        if ((len & 0x80) != 0) {
            len = (len & 0x7F) << 8 | strArray[start++] & 0xFF;
        }
        byte[] arr = Arrays.copyOfRange(strArray, start, start + len);
        return new String(arr, ParserStream.STRING_CHARSET_UTF8);
    }

    private static String extractString16(byte[] strArray, int offset) {
        int start;
        int len = strArray.length;
        int end = start = offset + BinaryXMLStrings.skipStrLen16(strArray, offset);
        while (end + 1 < len && (strArray[end] != 0 || strArray[end + 1] != 0)) {
            end += 2;
        }
        byte[] arr = Arrays.copyOfRange(strArray, start, end);
        return new String(arr, ParserStream.STRING_CHARSET_UTF16);
    }

    private static int skipStrLen8(byte[] strArray, int offset) {
        return (strArray[offset] & 0x80) == 0 ? 1 : 2;
    }

    private static int skipStrLen16(byte[] strArray, int offset) {
        return (strArray[offset + 1] & 0x80) == 0 ? 2 : 4;
    }
}

