/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.plugins;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginContext;
import jadx.api.plugins.JadxPluginInfo;
import jadx.api.plugins.data.IJadxPlugins;
import jadx.api.plugins.data.JadxPluginRuntimeData;
import jadx.api.plugins.events.IJadxEvents;
import jadx.api.plugins.gui.JadxGuiContext;
import jadx.api.plugins.input.ICodeLoader;
import jadx.api.plugins.input.JadxCodeInput;
import jadx.api.plugins.input.data.impl.MergeCodeLoader;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.api.plugins.options.OptionDescription;
import jadx.api.plugins.options.OptionFlag;
import jadx.api.plugins.pass.JadxPass;
import jadx.core.plugins.JadxPluginsData;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class PluginContext
implements JadxPluginContext,
JadxPluginRuntimeData,
Comparable<PluginContext> {
    private final JadxDecompiler decompiler;
    private final JadxPluginsData pluginsData;
    private final JadxPlugin plugin;
    private final JadxPluginInfo pluginInfo;
    @Nullable
    private JadxGuiContext guiContext;
    private final List<JadxCodeInput> codeInputs = new ArrayList<JadxCodeInput>();
    @Nullable
    private JadxPluginOptions options;
    @Nullable
    private Supplier<String> inputsHashSupplier;
    private boolean initialized;

    PluginContext(JadxDecompiler decompiler, JadxPluginsData pluginsData, JadxPlugin plugin) {
        this.decompiler = decompiler;
        this.pluginsData = pluginsData;
        this.plugin = plugin;
        this.pluginInfo = plugin.getPluginInfo();
    }

    void init() {
        this.plugin.init(this);
        this.initialized = true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public JadxArgs getArgs() {
        return this.decompiler.getArgs();
    }

    @Override
    public JadxDecompiler getDecompiler() {
        return this.decompiler;
    }

    @Override
    public void addPass(JadxPass pass) {
        this.decompiler.addCustomPass(pass);
    }

    @Override
    public void addCodeInput(JadxCodeInput codeInput) {
        this.codeInputs.add(codeInput);
    }

    @Override
    public List<JadxCodeInput> getCodeInputs() {
        return this.codeInputs;
    }

    @Override
    public void registerOptions(JadxPluginOptions options) {
        try {
            this.options = Objects.requireNonNull(options);
            options.setOptions(this.getArgs().getPluginOptions());
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to apply options for plugin: " + this.getPluginId(), e);
        }
    }

    @Override
    public void registerInputsHashSupplier(Supplier<String> supplier) {
        this.inputsHashSupplier = supplier;
    }

    @Override
    public String getInputsHash() {
        if (this.inputsHashSupplier == null) {
            return this.defaultOptionsHash();
        }
        try {
            return this.inputsHashSupplier.get();
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to get inputs hash for plugin: " + this.getPluginId(), e);
        }
    }

    private String defaultOptionsHash() {
        if (this.options == null) {
            return "";
        }
        Map<String, String> allOptions = this.getArgs().getPluginOptions();
        StringBuilder sb = new StringBuilder();
        for (OptionDescription optDesc : this.options.getOptionsDescriptions()) {
            if (optDesc.getFlags().contains((Object)OptionFlag.NOT_CHANGING_CODE)) continue;
            sb.append(':').append(allOptions.get(optDesc.name()));
        }
        return FileUtils.md5Sum(sb.toString());
    }

    @Override
    public IJadxEvents events() {
        return this.decompiler.events();
    }

    @Override
    @Nullable
    public JadxGuiContext getGuiContext() {
        return this.guiContext;
    }

    public void setGuiContext(JadxGuiContext guiContext) {
        this.guiContext = guiContext;
    }

    @Override
    public JadxPlugin getPluginInstance() {
        return this.plugin;
    }

    @Override
    public JadxPluginInfo getPluginInfo() {
        return this.pluginInfo;
    }

    @Override
    public String getPluginId() {
        return this.pluginInfo.getPluginId();
    }

    @Override
    @Nullable
    public JadxPluginOptions getOptions() {
        return this.options;
    }

    @Override
    public IJadxPlugins plugins() {
        return this.pluginsData;
    }

    @Override
    public ICodeLoader loadCodeFiles(List<Path> files, @Nullable Closeable closeable) {
        return new MergeCodeLoader(Utils.collectionMap(this.codeInputs, codeInput -> codeInput.loadFiles(files)), closeable);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginContext)) {
            return false;
        }
        return this.getPluginId().equals(((PluginContext)other).getPluginId());
    }

    public int hashCode() {
        return this.getPluginId().hashCode();
    }

    @Override
    public int compareTo(PluginContext other) {
        return this.getPluginId().compareTo(other.getPluginId());
    }

    public String toString() {
        return this.getPluginId();
    }
}

