/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.EdgeInsnAttr;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.attributes.nodes.RegionRefAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnContainer;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.regions.IfMakerHelper;
import jadx.core.dex.visitors.regions.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxOverflowException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RegionMaker {
    private final MethodNode mth;
    private final int regionsLimit;
    private final BitSet processedBlocks;
    private int regionsCount;

    public RegionMaker(MethodNode mth) {
        this.mth = mth;
        int blocksCount = mth.getBasicBlocks().size();
        this.processedBlocks = new BitSet(blocksCount);
        this.regionsLimit = blocksCount * 100;
    }

    public Region makeRegion(BlockNode startBlock, RegionStack stack) {
        Region r = new Region(stack.peekRegion());
        if (startBlock == null) {
            return r;
        }
        if (stack.containsExit(startBlock)) {
            this.insertEdgeInsns(r, startBlock);
            return r;
        }
        int startBlockId = startBlock.getId();
        if (this.processedBlocks.get(startBlockId)) {
            this.mth.addWarn("Removed duplicated region for block: " + startBlock + " " + startBlock.getAttributesString());
            return r;
        }
        this.processedBlocks.set(startBlockId);
        BlockNode next = startBlock;
        while (next != null) {
            next = this.traverse(r, next, stack);
            ++this.regionsCount;
            if (this.regionsCount <= this.regionsLimit) continue;
            throw new JadxOverflowException("Regions count limit reached");
        }
        return r;
    }

    private void insertEdgeInsns(Region region, BlockNode exitBlock) {
        List<EdgeInsnAttr> edgeInsns = exitBlock.getAll(AType.EDGE_INSN);
        if (edgeInsns.isEmpty()) {
            return;
        }
        ArrayList<InsnNode> insns = new ArrayList<InsnNode>(edgeInsns.size());
        this.addOneInsnOfType(insns, edgeInsns, InsnType.BREAK);
        this.addOneInsnOfType(insns, edgeInsns, InsnType.CONTINUE);
        region.add(new InsnContainer(insns));
    }

    private void addOneInsnOfType(List<InsnNode> insns, List<EdgeInsnAttr> edgeInsns, InsnType insnType) {
        for (EdgeInsnAttr edgeInsn : edgeInsns) {
            InsnNode insn = edgeInsn.getInsn();
            if (insn.getType() != insnType) continue;
            insns.add(insn);
            return;
        }
    }

    private BlockNode traverse(IRegion r, BlockNode block, RegionStack stack) {
        if (block.contains(AFlag.MTH_EXIT_BLOCK)) {
            return null;
        }
        BlockNode next = null;
        boolean processed = false;
        List loops = block.getAll(AType.LOOP);
        int loopCount = loops.size();
        if (loopCount != 0 && block.contains(AFlag.LOOP_START)) {
            if (loopCount == 1) {
                next = this.processLoop(r, (LoopInfo)loops.get(0), stack);
                processed = true;
            } else {
                for (LoopInfo loop : loops) {
                    if (loop.getStart() != block) continue;
                    next = this.processLoop(r, loop, stack);
                    processed = true;
                    break;
                }
            }
        }
        InsnNode insn = BlockUtils.getLastInsn(block);
        if (!processed && insn != null) {
            switch (insn.getType()) {
                case IF: {
                    next = this.processIf(r, block, (IfNode)insn, stack);
                    processed = true;
                    break;
                }
                case SWITCH: {
                    next = this.processSwitch(r, block, (SwitchInsn)insn, stack);
                    processed = true;
                    break;
                }
                case MONITOR_ENTER: {
                    next = this.processMonitorEnter(r, block, insn, stack);
                    processed = true;
                    break;
                }
            }
        }
        if (!processed) {
            r.getSubBlocks().add(block);
            next = BlockUtils.getNextBlock(block);
        }
        if (next != null && !stack.containsExit(block) && !stack.containsExit(next)) {
            return next;
        }
        return null;
    }

    private BlockNode processLoop(IRegion curRegion, LoopInfo loop, RegionStack stack) {
        Region body;
        BlockNode out;
        BlockNode loopExit;
        BlockNode loopStart = loop.getStart();
        Set<BlockNode> exitBlocksSet = loop.getExitNodes();
        ArrayList<BlockNode> exitBlocks = new ArrayList<BlockNode>(exitBlocksSet.size());
        BlockNode nextStart = BlockUtils.getNextBlock(loopStart);
        if (nextStart != null && exitBlocksSet.remove(nextStart)) {
            exitBlocks.add(nextStart);
        }
        if (exitBlocksSet.remove(loopStart)) {
            exitBlocks.add(loopStart);
        }
        if (exitBlocksSet.remove(loop.getEnd())) {
            exitBlocks.add(loop.getEnd());
        }
        exitBlocks.addAll(exitBlocksSet);
        LoopRegion loopRegion = this.makeLoopRegion(curRegion, loop, exitBlocks);
        if (loopRegion == null) {
            BlockNode exit = this.makeEndlessLoop(curRegion, stack, loop, loopStart);
            RegionMaker.insertContinue(loop);
            return exit;
        }
        curRegion.getSubBlocks().add(loopRegion);
        IRegion outerRegion = stack.peekRegion();
        stack.push(loopRegion);
        IfInfo condInfo = IfMakerHelper.makeIfInfo(this.mth, loopRegion.getHeader());
        condInfo = IfMakerHelper.searchNestedIf(condInfo);
        IfMakerHelper.confirmMerge(condInfo);
        if (!loop.getLoopBlocks().contains(condInfo.getThenBlock())) {
            condInfo = IfInfo.invert(condInfo);
        }
        loopRegion.updateCondition(condInfo);
        condInfo.getMergedBlocks().forEach(b -> b.add(AFlag.ADDED_TO_REGION));
        exitBlocks.removeAll(condInfo.getMergedBlocks());
        if (!exitBlocks.isEmpty() && (loopExit = condInfo.getElseBlock()) != null) {
            for (Edge exitEdge : loop.getExitEdges()) {
                if (!exitBlocks.contains(exitEdge.getSource())) continue;
                this.insertLoopBreak(stack, loop, loopExit, exitEdge);
            }
        }
        if (loopRegion.isConditionAtEnd()) {
            BlockNode thenBlock = condInfo.getThenBlock();
            out = thenBlock == loop.getEnd() || thenBlock == loopStart ? condInfo.getElseBlock() : thenBlock;
            out = BlockUtils.followEmptyPath(out);
            loopStart.remove(AType.LOOP);
            loop.getEnd().add(AFlag.ADDED_TO_REGION);
            stack.addExit(loop.getEnd());
            this.processedBlocks.clear(loopStart.getId());
            body = this.makeRegion(loopStart, stack);
            loopRegion.setBody(body);
            loopStart.addAttr(AType.LOOP, loop);
            loop.getEnd().remove(AFlag.ADDED_TO_REGION);
        } else {
            out = condInfo.getElseBlock();
            if (outerRegion != null && out != null && out.contains(AFlag.LOOP_START) && !out.getAll(AType.LOOP).contains(loop) && RegionUtils.isRegionContainsBlock(outerRegion, out)) {
                out = null;
            }
            stack.addExit(out);
            BlockNode loopBody = condInfo.getThenBlock();
            body = Objects.equals(loopBody, loopStart) ? new Region(loopRegion) : this.makeRegion(loopBody, stack);
            BlockNode conditionBlock = condInfo.getFirstIfBlock();
            if (loopStart != conditionBlock) {
                Set<BlockNode> blocks = BlockUtils.getAllPathsBlocks(loopStart, conditionBlock);
                blocks.remove(conditionBlock);
                for (BlockNode block : blocks) {
                    if (!block.getInstructions().isEmpty() || block.contains(AFlag.ADDED_TO_REGION) || RegionUtils.isRegionContainsBlock(body, block)) continue;
                    body.add(block);
                }
            }
            loopRegion.setBody(body);
        }
        stack.pop();
        RegionMaker.insertContinue(loop);
        return out;
    }

    private LoopRegion makeLoopRegion(IRegion curRegion, LoopInfo loop, List<BlockNode> exitBlocks) {
        for (BlockNode block : exitBlocks) {
            List<LoopInfo> list;
            boolean found;
            List loops;
            InsnNode lastInsn;
            if (block.contains(AType.EXC_HANDLER) || (lastInsn = BlockUtils.getLastInsn(block)) == null || lastInsn.getType() != InsnType.IF || !(loops = block.getAll(AType.LOOP)).isEmpty() && loops.get(0) != loop) continue;
            BlockNode loopEnd = loop.getEnd();
            boolean exitAtLoopEnd = block == loopEnd || loopEnd.getInstructions().isEmpty() && ListUtils.isSingleElement(loopEnd.getPredecessors(), block);
            LoopRegion loopRegion = new LoopRegion(curRegion, loop, block, exitAtLoopEnd);
            if (block == loop.getStart() || exitAtLoopEnd || BlockUtils.isEmptySimplePath(loop.getStart(), block)) {
                found = true;
            } else if (block.getPredecessors().contains(loop.getStart())) {
                loopRegion.setPreCondition(loop.getStart());
                found = loopRegion.checkPreCondition();
            } else {
                found = false;
            }
            if (found && (list = this.mth.getAllLoopsForBlock(block)).size() >= 2) {
                boolean allOuter = true;
                for (BlockNode outerBlock : block.getCleanSuccessors()) {
                    List<LoopInfo> outLoopList = this.mth.getAllLoopsForBlock(outerBlock);
                    outLoopList.remove(loop);
                    if (outLoopList.isEmpty()) continue;
                    allOuter = false;
                    break;
                }
                if (allOuter) {
                    found = false;
                }
            }
            if (found && !this.checkLoopExits(loop, block)) {
                found = false;
            }
            if (!found) continue;
            return loopRegion;
        }
        return null;
    }

    private boolean checkLoopExits(LoopInfo loop, BlockNode mainExitBlock) {
        List<Edge> exitEdges = loop.getExitEdges();
        if (exitEdges.size() < 2) {
            return true;
        }
        Optional<Edge> mainEdgeOpt = exitEdges.stream().filter(edge -> edge.getSource() == mainExitBlock).findFirst();
        if (!mainEdgeOpt.isPresent()) {
            throw new JadxRuntimeException("Not found exit edge by exit block: " + mainExitBlock);
        }
        Edge mainExitEdge = mainEdgeOpt.get();
        BlockNode mainOutBlock = mainExitEdge.getTarget();
        for (Edge exitEdge : exitEdges) {
            BlockNode crossBlock;
            BlockNode exitBlock;
            if (exitEdge == mainExitEdge || RegionMaker.isEqualPaths(mainOutBlock, exitBlock = exitEdge.getTarget()) || (crossBlock = BlockUtils.getPathCross(this.mth, mainOutBlock, exitBlock)) == null) continue;
            return false;
        }
        return true;
    }

    private BlockNode makeEndlessLoop(IRegion curRegion, RegionStack stack, LoopInfo loop, BlockNode loopStart) {
        LoopRegion loopRegion = new LoopRegion(curRegion, loop, null, false);
        curRegion.getSubBlocks().add(loopRegion);
        loopStart.remove(AType.LOOP);
        this.processedBlocks.clear(loopStart.getId());
        stack.push(loopRegion);
        BlockNode out = null;
        List<Edge> exitEdges = loop.getExitEdges();
        if (exitEdges.size() == 1) {
            BlockNode nextBlock;
            Edge exitEdge = exitEdges.get(0);
            BlockNode exit = exitEdge.getTarget();
            if (this.insertLoopBreak(stack, loop, exit, exitEdge) && (nextBlock = BlockUtils.getNextBlock(exit)) != null) {
                stack.addExit(nextBlock);
                out = nextBlock;
            }
        } else {
            for (Edge exitEdge : exitEdges) {
                BlockNode exit = exitEdge.getTarget();
                List<BlockNode> blocks = BlockUtils.bitSetToBlocks(this.mth, exit.getDomFrontier());
                for (BlockNode block : blocks) {
                    if (BlockUtils.isPathExists(exit, block)) {
                        stack.addExit(block);
                        this.insertLoopBreak(stack, loop, block, exitEdge);
                        out = block;
                        continue;
                    }
                    this.insertLoopBreak(stack, loop, exit, exitEdge);
                }
            }
        }
        Region body = this.makeRegion(loopStart, stack);
        BlockNode loopEnd = loop.getEnd();
        if (!(RegionUtils.isRegionContainsBlock(body, loopEnd) || loopEnd.contains(AType.EXC_HANDLER) || this.inExceptionHandlerBlocks(loopEnd))) {
            body.getSubBlocks().add(loopEnd);
        }
        loopRegion.setBody(body);
        if (out == null) {
            BlockNode next = BlockUtils.getNextBlock(loopEnd);
            out = RegionUtils.isRegionContainsBlock(body, next) ? null : next;
        }
        stack.pop();
        loopStart.addAttr(AType.LOOP, loop);
        return out;
    }

    private boolean inExceptionHandlerBlocks(BlockNode loopEnd) {
        if (this.mth.getExceptionHandlersCount() == 0) {
            return false;
        }
        for (ExceptionHandler eh : this.mth.getExceptionHandlers()) {
            if (!eh.getBlocks().contains(loopEnd)) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertBreak(BlockNode exit) {
        BlockNode lastBlock;
        if (BlockUtils.containsExitInsn(exit)) {
            return false;
        }
        List<BlockNode> simplePath = BlockUtils.buildSimplePath(exit);
        if (!simplePath.isEmpty() && ((lastBlock = simplePath.get(simplePath.size() - 1)).contains(AFlag.RETURN) || lastBlock.getSuccessors().isEmpty())) {
            return false;
        }
        Set<BlockNode> paths = BlockUtils.getAllPathsBlocks(this.mth.getEnterBlock(), exit);
        for (BlockNode block : paths) {
            if (!BlockUtils.checkLastInsnType(block, InsnType.SWITCH)) continue;
            return false;
        }
        return true;
    }

    private boolean insertLoopBreak(RegionStack stack, LoopInfo loop, BlockNode loopExit, Edge exitEdge) {
        BlockNode exit = exitEdge.getTarget();
        Edge insertEdge = null;
        boolean confirm = false;
        BlockNode exitEnd = BlockUtils.followEmptyPath(exit);
        List loops = exitEnd.getAll(AType.LOOP);
        for (LoopInfo loopAtEnd : loops) {
            if (loopAtEnd == loop || !loop.hasParent(loopAtEnd)) continue;
            insertEdge = exitEdge;
            confirm = true;
            break;
        }
        if (!confirm) {
            BlockNode insertBlock = null;
            while (exit != null) {
                if (insertBlock != null && BlockUtils.isPathExists(loopExit, exit)) {
                    if (this.canInsertBreak(insertBlock)) {
                        insertEdge = new Edge(insertBlock, insertBlock.getSuccessors().get(0));
                        confirm = true;
                        break;
                    }
                    return false;
                }
                insertBlock = exit;
                List<BlockNode> cs = exit.getCleanSuccessors();
                exit = cs.size() == 1 ? cs.get(0) : null;
            }
        }
        if (!confirm) {
            return false;
        }
        InsnNode breakInsn = new InsnNode(InsnType.BREAK, 0);
        breakInsn.addAttr(AType.LOOP, loop);
        EdgeInsnAttr.addEdgeInsn(insertEdge, breakInsn);
        stack.addExit(exit);
        this.addBreakLabel(exitEdge, exit, breakInsn);
        return true;
    }

    private void addBreakLabel(Edge exitEdge, BlockNode exit, InsnNode breakInsn) {
        BlockNode outBlock = BlockUtils.getNextBlock(exitEdge.getTarget());
        if (outBlock == null) {
            return;
        }
        List<LoopInfo> exitLoop = this.mth.getAllLoopsForBlock(outBlock);
        if (!exitLoop.isEmpty()) {
            return;
        }
        List<LoopInfo> inLoops = this.mth.getAllLoopsForBlock(exitEdge.getSource());
        if (inLoops.size() < 2) {
            return;
        }
        LoopInfo parentLoop = null;
        for (LoopInfo loop : inLoops) {
            if (loop.getParentLoop() != null) continue;
            parentLoop = loop;
            break;
        }
        if (parentLoop == null) {
            return;
        }
        if (parentLoop.getEnd() != exit && !parentLoop.getExitNodes().contains(exit)) {
            LoopLabelAttr labelAttr = new LoopLabelAttr(parentLoop);
            breakInsn.addAttr(labelAttr);
            parentLoop.getStart().addAttr(labelAttr);
        }
    }

    private static void insertContinue(LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        List<BlockNode> predecessors = loopEnd.getPredecessors();
        if (predecessors.size() <= 1) {
            return;
        }
        Set<BlockNode> loopExitNodes = loop.getExitNodes();
        for (BlockNode pred : predecessors) {
            if (!RegionMaker.canInsertContinue(pred, predecessors, loopEnd, loopExitNodes)) continue;
            InsnNode cont = new InsnNode(InsnType.CONTINUE, 0);
            pred.getInstructions().add(cont);
        }
    }

    private static boolean canInsertContinue(BlockNode pred, List<BlockNode> predecessors, BlockNode loopEnd, Set<BlockNode> loopExitNodes) {
        if (!pred.contains(AFlag.SYNTHETIC) || BlockUtils.checkLastInsnType(pred, InsnType.CONTINUE)) {
            return false;
        }
        List<BlockNode> preds = pred.getPredecessors();
        if (preds.isEmpty()) {
            return false;
        }
        BlockNode codePred = preds.get(0);
        if (codePred.contains(AFlag.ADDED_TO_REGION)) {
            return false;
        }
        if (loopEnd.isDominator(codePred) || loopExitNodes.contains(codePred)) {
            return false;
        }
        if (RegionMaker.isDominatedOnBlocks(codePred, predecessors)) {
            return false;
        }
        boolean gotoExit = false;
        for (BlockNode exit : loopExitNodes) {
            if (!BlockUtils.isPathExists(codePred, exit)) continue;
            gotoExit = true;
            break;
        }
        return gotoExit;
    }

    private static boolean isDominatedOnBlocks(BlockNode dom, List<BlockNode> blocks) {
        for (BlockNode node : blocks) {
            if (node.isDominator(dom)) continue;
            return false;
        }
        return true;
    }

    private BlockNode processMonitorEnter(IRegion curRegion, BlockNode block, InsnNode insn, RegionStack stack) {
        SynchronizedRegion synchRegion = new SynchronizedRegion(curRegion, insn);
        synchRegion.getSubBlocks().add(block);
        curRegion.getSubBlocks().add(synchRegion);
        LinkedHashSet<BlockNode> exits = new LinkedHashSet<BlockNode>();
        HashSet<BlockNode> cacheSet = new HashSet<BlockNode>();
        RegionMaker.traverseMonitorExits(synchRegion, insn.getArg(0), block, exits, cacheSet);
        for (InsnNode exitInsn : synchRegion.getExitInsns()) {
            BlockNode insnBlock = BlockUtils.getBlockByInsn(this.mth, exitInsn);
            if (insnBlock != null) {
                insnBlock.add(AFlag.DONT_GENERATE);
            }
            exitInsn.removeArg(0);
            exitInsn.add(AFlag.DONT_GENERATE);
        }
        BlockNode body = BlockUtils.getNextBlock(block);
        if (body == null) {
            this.mth.addWarn("Unexpected end of synchronized block");
            return null;
        }
        BlockNode exit = null;
        if (exits.size() == 1) {
            exit = BlockUtils.getNextBlock((BlockNode)exits.iterator().next());
        } else if (exits.size() > 1) {
            cacheSet.clear();
            exit = RegionMaker.traverseMonitorExitsCross(body, exits, cacheSet);
        }
        stack.push(synchRegion);
        if (exit != null) {
            stack.addExit(exit);
        } else {
            for (BlockNode exitBlock : exits) {
                List<BlockNode> list = BlockUtils.buildSimplePath(exitBlock);
                if (!list.isEmpty() && BlockUtils.isExitBlock(this.mth, Utils.last(list))) continue;
                stack.addExit(exitBlock);
                exit = exitBlock;
            }
        }
        synchRegion.getSubBlocks().add(this.makeRegion(body, stack));
        stack.pop();
        return exit;
    }

    private static void traverseMonitorExits(SynchronizedRegion region, InsnArg arg, BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (InsnNode insn : block.getInstructions()) {
            if (insn.getType() != InsnType.MONITOR_EXIT || insn.getArgsCount() <= 0 || !insn.getArg(0).equals(arg)) continue;
            exits.add(block);
            region.getExitInsns().add(insn);
            return;
        }
        for (BlockNode node : block.getSuccessors()) {
            if (visited.contains(node)) continue;
            RegionMaker.traverseMonitorExits(region, arg, node, exits, visited);
        }
    }

    private static BlockNode traverseMonitorExitsCross(BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (BlockNode node : block.getCleanSuccessors()) {
            BlockNode res;
            boolean cross = true;
            for (BlockNode exitBlock : exits) {
                boolean p = BlockUtils.isPathExists(exitBlock, node);
                if (p) continue;
                cross = false;
                break;
            }
            if (cross) {
                return node;
            }
            if (visited.contains(node) || (res = RegionMaker.traverseMonitorExitsCross(node, exits, visited)) == null) continue;
            return res;
        }
        return null;
    }

    private BlockNode processIf(IRegion currentRegion, BlockNode block, IfNode ifnode, RegionStack stack) {
        List edgeInsnAttrs;
        if (block.contains(AFlag.ADDED_TO_REGION)) {
            return ifnode.getThenBlock();
        }
        IfInfo currentIf = IfMakerHelper.makeIfInfo(this.mth, block);
        if (currentIf == null) {
            return null;
        }
        IfInfo mergedIf = IfMakerHelper.mergeNestedIfNodes(currentIf);
        IfInfo modifiedIf = IfMakerHelper.restructureIf(this.mth, block, currentIf = mergedIf != null ? mergedIf : IfInfo.invert(currentIf));
        if (modifiedIf != null) {
            currentIf = modifiedIf;
        } else {
            if (currentIf.getMergedBlocks().size() <= 1) {
                return null;
            }
            currentIf = IfMakerHelper.makeIfInfo(this.mth, block);
            if ((currentIf = IfMakerHelper.restructureIf(this.mth, block, currentIf)) == null) {
                return null;
            }
        }
        IfMakerHelper.confirmMerge(currentIf);
        IfRegion ifRegion = new IfRegion(currentRegion);
        ifRegion.updateCondition(currentIf);
        currentRegion.getSubBlocks().add(ifRegion);
        BlockNode outBlock = currentIf.getOutBlock();
        stack.push(ifRegion);
        stack.addExit(outBlock);
        ifRegion.setThenRegion(this.makeRegion(currentIf.getThenBlock(), stack));
        BlockNode elseBlock = currentIf.getElseBlock();
        if (elseBlock == null || stack.containsExit(elseBlock)) {
            ifRegion.setElseRegion(null);
        } else {
            ifRegion.setElseRegion(this.makeRegion(elseBlock, stack));
        }
        if (ifRegion.getElseRegion() == null && outBlock != null && !(edgeInsnAttrs = outBlock.getAll(AType.EDGE_INSN)).isEmpty()) {
            Region elseRegion = new Region(ifRegion);
            for (EdgeInsnAttr edgeInsnAttr : edgeInsnAttrs) {
                if (!edgeInsnAttr.getEnd().equals(outBlock)) continue;
                this.addEdgeInsn(currentIf, elseRegion, edgeInsnAttr);
            }
            ifRegion.setElseRegion(elseRegion);
        }
        stack.pop();
        return outBlock;
    }

    private void addEdgeInsn(IfInfo ifInfo, Region region, EdgeInsnAttr edgeInsnAttr) {
        BlockNode start = edgeInsnAttr.getStart();
        boolean fromThisIf = false;
        for (BlockNode ifBlock : ifInfo.getMergedBlocks()) {
            if (!ifBlock.getSuccessors().contains(start)) continue;
            fromThisIf = true;
            break;
        }
        if (!fromThisIf) {
            return;
        }
        region.add(start);
    }

    private BlockNode processSwitch(IRegion currentRegion, BlockNode block, SwitchInsn insn, RegionStack stack) {
        List keys;
        int len = insn.getTargets().length;
        LinkedHashMap<BlockNode, List<Object>> blocksMap = new LinkedHashMap<BlockNode, List<Object>>(len);
        BlockNode[] targetBlocksArr = insn.getTargetBlocks();
        for (int i = 0; i < len; ++i) {
            keys = blocksMap.computeIfAbsent(targetBlocksArr[i], k -> new ArrayList(2));
            keys.add(insn.getKey(i));
        }
        BlockNode defCase = insn.getDefTargetBlock();
        if (defCase != null) {
            keys = blocksMap.computeIfAbsent(defCase, k -> new ArrayList(1));
            keys.add(SwitchRegion.DEFAULT_CASE_KEY);
        }
        SwitchRegion sw = new SwitchRegion(currentRegion, block);
        insn.addAttr(new RegionRefAttr(sw));
        currentRegion.getSubBlocks().add(sw);
        stack.push(sw);
        BlockNode out = this.calcSwitchOut(block, stack);
        stack.addExit(out);
        this.processFallThroughCases(sw, out, stack, blocksMap);
        this.removeEmptyCases(insn, sw, defCase);
        stack.pop();
        return out;
    }

    private void processFallThroughCases(SwitchRegion sw, @Nullable BlockNode out, RegionStack stack, Map<BlockNode, List<Object>> blocksMap) {
        LinkedHashMap<BlockNode, BlockNode> fallThroughCases = new LinkedHashMap<BlockNode, BlockNode>();
        if (out != null) {
            BitSet caseBlocks = BlockUtils.blocksToBitSet(this.mth, blocksMap.keySet());
            caseBlocks.clear(out.getId());
            for (BlockNode successor : sw.getHeader().getCleanSuccessors()) {
                BitSet df = successor.getDomFrontier();
                if (!df.intersects(caseBlocks)) continue;
                BlockNode fallThroughBlock = this.getOneIntersectionBlock(out, caseBlocks, df);
                fallThroughCases.put(successor, fallThroughBlock);
            }
            if (!fallThroughCases.isEmpty() && this.isBadCasesOrder(blocksMap, fallThroughCases)) {
                Map<BlockNode, List<Object>> newBlocksMap = this.reOrderSwitchCases(blocksMap, fallThroughCases);
                if (this.isBadCasesOrder(newBlocksMap, fallThroughCases)) {
                    this.mth.addWarnComment("Can't fix incorrect switch cases order, some code will duplicate");
                    fallThroughCases.clear();
                } else {
                    blocksMap = newBlocksMap;
                }
            }
        }
        for (Map.Entry<BlockNode, List<Object>> entry : blocksMap.entrySet()) {
            List<Object> keysList = entry.getValue();
            BlockNode caseBlock = entry.getKey();
            if (stack.containsExit(caseBlock)) {
                sw.addCase(keysList, new Region(stack.peekRegion()));
                continue;
            }
            BlockNode next = (BlockNode)fallThroughCases.get(caseBlock);
            stack.addExit(next);
            Region caseRegion = this.makeRegion(caseBlock, stack);
            stack.removeExit(next);
            if (next != null) {
                next.add(AFlag.FALL_THROUGH);
                caseRegion.add(AFlag.FALL_THROUGH);
            }
            sw.addCase(keysList, caseRegion);
        }
    }

    @Nullable
    private BlockNode getOneIntersectionBlock(BlockNode out, BitSet caseBlocks, BitSet fallThroughSet) {
        BitSet caseExits = BlockUtils.copyBlocksBitSet(this.mth, fallThroughSet);
        caseExits.clear(out.getId());
        caseExits.and(caseBlocks);
        return BlockUtils.bitSetToOneBlock(this.mth, caseExits);
    }

    @Nullable
    private BlockNode calcSwitchOut(BlockNode block, RegionStack stack) {
        BlockNode imPostDom;
        BlockNode out;
        BitSet outs = BlockUtils.newBlocksBitSet(this.mth);
        for (BlockNode s : block.getCleanSuccessors()) {
            outs.or(s.getDomFrontier());
        }
        outs.clear(block.getId());
        if (outs.isEmpty()) {
            return this.mth.getExitBlock();
        }
        if (outs.cardinality() == 1) {
            out = BlockUtils.bitSetToOneBlock(this.mth, outs);
        } else {
            LoopInfo loop = this.mth.getLoopForBlock(block);
            if (loop != null) {
                outs.andNot(block.getPostDoms());
                out = BlockUtils.bitSetToOneBlock(this.mth, outs);
                if (out != null) {
                    this.insertContinueInSwitch(block, out, loop.getEnd());
                    if (out == loop.getStart()) {
                        return null;
                    }
                }
            } else {
                outs.clear(this.mth.getExitBlock().getId());
                BlockNode imPostDom2 = block.getIPostDom();
                if (outs.get(imPostDom2.getId())) {
                    return imPostDom2;
                }
                outs.andNot(block.getPostDoms());
                out = BlockUtils.bitSetToOneBlock(this.mth, outs);
            }
        }
        if (out != null && this.mth.isPreExitBlock(out)) {
            out = this.mth.getExitBlock();
        }
        if (out != (imPostDom = block.getIPostDom()) && !this.mth.isPreExitBlock(imPostDom)) {
            stack.addExit(imPostDom);
        }
        if (block.getCleanSuccessors().contains(imPostDom)) {
            stack.addExit(imPostDom);
        }
        if (out == null) {
            this.mth.addWarnComment("Failed to find 'out' block for switch in " + block + ". Please report as an issue.");
            out = block.getIPostDom();
        }
        if (out != null && this.processedBlocks.get(out.getId())) {
            throw new JadxRuntimeException("Failed to find switch 'out' block (already processed)");
        }
        return out;
    }

    private void removeEmptyCases(SwitchInsn insn, SwitchRegion sw, BlockNode defCase) {
        boolean defaultCaseIsEmpty = defCase == null ? true : sw.getCases().stream().anyMatch(c -> c.getKeys().contains(SwitchRegion.DEFAULT_CASE_KEY) && RegionUtils.isEmpty(c.getContainer()));
        if (defaultCaseIsEmpty) {
            sw.getCases().removeIf(caseInfo -> {
                if (RegionUtils.isEmpty(caseInfo.getContainer())) {
                    List<Object> keys = caseInfo.getKeys();
                    if (keys.contains(SwitchRegion.DEFAULT_CASE_KEY)) {
                        return true;
                    }
                    if (insn.isPacked()) {
                        return true;
                    }
                }
                return false;
            });
        }
    }

    private boolean isBadCasesOrder(Map<BlockNode, List<Object>> blocksMap, Map<BlockNode, BlockNode> fallThroughCases) {
        BlockNode nextCaseBlock = null;
        for (BlockNode caseBlock : blocksMap.keySet()) {
            if (nextCaseBlock != null && !caseBlock.equals(nextCaseBlock)) {
                return true;
            }
            nextCaseBlock = fallThroughCases.get(caseBlock);
        }
        return nextCaseBlock != null;
    }

    private Map<BlockNode, List<Object>> reOrderSwitchCases(Map<BlockNode, List<Object>> blocksMap, Map<BlockNode, BlockNode> fallThroughCases) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(blocksMap.size());
        list.addAll(blocksMap.keySet());
        list.sort((a, b) -> {
            BlockNode nextA = (BlockNode)fallThroughCases.get(a);
            if (nextA != null) {
                if (b.equals(nextA)) {
                    return -1;
                }
            } else if (a.equals(fallThroughCases.get(b))) {
                return 1;
            }
            return 0;
        });
        LinkedHashMap<BlockNode, List<Object>> newBlocksMap = new LinkedHashMap<BlockNode, List<Object>>(blocksMap.size());
        for (BlockNode key : list) {
            newBlocksMap.put(key, blocksMap.get(key));
        }
        return newBlocksMap;
    }

    private void insertContinueInSwitch(BlockNode switchBlock, BlockNode switchOut, BlockNode loopEnd) {
        block0: for (BlockNode caseBlock : switchBlock.getCleanSuccessors()) {
            HashSet<BlockNode> list;
            if (!caseBlock.getDomFrontier().get(loopEnd.getId()) || caseBlock == switchOut || (list = new HashSet<BlockNode>(BlockUtils.collectBlocksDominatedBy(this.mth, caseBlock, caseBlock))).contains(switchOut)) continue;
            if (switchOut.getPredecessors().stream().anyMatch(list::contains)) continue;
            for (BlockNode p : loopEnd.getPredecessors()) {
                if (!list.contains(p)) continue;
                if (!p.isSynthetic()) continue block0;
                p.getInstructions().add(new InsnNode(InsnType.CONTINUE, 0));
                continue block0;
            }
        }
    }

    public IRegion processTryCatchBlocks(MethodNode mth) {
        List<TryCatchBlockAttr> tcs = mth.getAll(AType.TRY_BLOCKS_LIST);
        for (TryCatchBlockAttr tc : tcs) {
            ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(tc.getHandlersCount());
            HashSet<BlockNode> splitters = new HashSet<BlockNode>();
            for (ExceptionHandler handler : tc.getHandlers()) {
                BlockNode handlerBlock = handler.getHandlerBlock();
                if (handlerBlock != null) {
                    blocks.add(handlerBlock);
                    splitters.add(BlockUtils.getTopSplitterForHandler(handlerBlock));
                    continue;
                }
                mth.addDebugComment("No exception handler block: " + handler);
            }
            HashSet<BlockNode> exits = new HashSet<BlockNode>();
            for (BlockNode splitter : splitters) {
                for (BlockNode handler : blocks) {
                    if (handler.contains(AFlag.REMOVE)) continue;
                    List<BlockNode> s = splitter.getSuccessors();
                    if (s.isEmpty()) {
                        mth.addDebugComment("No successors for splitter: " + splitter);
                        continue;
                    }
                    BlockNode ss = s.get(0);
                    BlockNode cross = BlockUtils.getPathCross(mth, ss, handler);
                    if (cross == null || cross == ss || cross == handler) continue;
                    exits.add(cross);
                }
            }
            for (ExceptionHandler handler : tc.getHandlers()) {
                this.processExcHandler(mth, handler, exits);
            }
        }
        return this.processHandlersOutBlocks(mth, tcs);
    }

    protected IRegion processHandlersOutBlocks(MethodNode mth, List<TryCatchBlockAttr> tcs) {
        HashSet<IBlock> allRegionBlocks = new HashSet<IBlock>();
        RegionUtils.getAllRegionBlocks(mth.getRegion(), allRegionBlocks);
        HashSet<BlockNode> succBlocks = new HashSet<BlockNode>();
        for (TryCatchBlockAttr tc : tcs) {
            for (ExceptionHandler handler : tc.getHandlers()) {
                IContainer region = handler.getHandlerRegion();
                if (region == null) continue;
                IBlock lastBlock = RegionUtils.getLastBlock(region);
                if (lastBlock instanceof BlockNode) {
                    succBlocks.addAll(((BlockNode)lastBlock).getSuccessors());
                }
                RegionUtils.getAllRegionBlocks(region, allRegionBlocks);
            }
        }
        succBlocks.removeAll(allRegionBlocks);
        if (succBlocks.isEmpty()) {
            return null;
        }
        Region excOutRegion = new Region(mth.getRegion());
        for (IBlock iBlock : succBlocks) {
            if (!(iBlock instanceof BlockNode)) continue;
            excOutRegion.add(this.makeRegion((BlockNode)iBlock, new RegionStack(mth)));
        }
        return excOutRegion;
    }

    private void processExcHandler(MethodNode mth, ExceptionHandler handler, Set<BlockNode> exits) {
        BlockNode dom;
        BlockNode start = handler.getHandlerBlock();
        if (start == null) {
            return;
        }
        RegionStack stack = new RegionStack(this.mth);
        if (handler.isFinally()) {
            dom = BlockUtils.getTopSplitterForHandler(start);
        } else {
            dom = start;
            stack.addExits(exits);
        }
        if (dom.contains(AFlag.REMOVE)) {
            return;
        }
        BitSet domFrontier = dom.getDomFrontier();
        List<BlockNode> handlerExits = BlockUtils.bitSetToBlocks(this.mth, domFrontier);
        boolean inLoop = this.mth.getLoopForBlock(start) != null;
        for (BlockNode exit : handlerExits) {
            if (inLoop && !BlockUtils.isPathExists(start, exit) || !RegionUtils.isRegionContainsBlock(this.mth.getRegion(), exit)) continue;
            stack.addExit(exit);
        }
        handler.setHandlerRegion(this.makeRegion(start, stack));
        ExcHandlerAttr excHandlerAttr = start.get(AType.EXC_HANDLER);
        if (excHandlerAttr == null) {
            mth.addWarn("Missing exception handler attribute for start block: " + start);
        } else {
            handler.getHandlerRegion().addAttr(excHandlerAttr);
        }
    }

    static boolean isEqualPaths(BlockNode b1, BlockNode b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return RegionMaker.isEqualReturnBlocks(b1, b2) || RegionMaker.isEmptySyntheticPath(b1, b2);
    }

    private static boolean isEmptySyntheticPath(BlockNode b1, BlockNode b2) {
        BlockNode n2;
        BlockNode n1 = BlockUtils.followEmptyPath(b1);
        return n1 == (n2 = BlockUtils.followEmptyPath(b2)) || RegionMaker.isEqualReturnBlocks(n1, n2);
    }

    public static boolean isEqualReturnBlocks(BlockNode b1, BlockNode b2) {
        InsnArg secondArg;
        if (!b1.isReturnBlock() || !b2.isReturnBlock()) {
            return false;
        }
        List<InsnNode> b1Insns = b1.getInstructions();
        List<InsnNode> b2Insns = b2.getInstructions();
        if (b1Insns.size() != 1 || b2Insns.size() != 1) {
            return false;
        }
        InsnNode i1 = b1Insns.get(0);
        InsnNode i2 = b2Insns.get(0);
        if (i1.getArgsCount() != i2.getArgsCount()) {
            return false;
        }
        if (i1.getArgsCount() == 0) {
            return true;
        }
        InsnArg firstArg = i1.getArg(0);
        if (firstArg.isSameConst(secondArg = i2.getArg(0))) {
            return true;
        }
        if (i1.getSourceLine() != i2.getSourceLine()) {
            return false;
        }
        return firstArg.equals(secondArg);
    }
}

