/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.blocks.BlockExceptionHandler;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.dex.visitors.blocks.DominatorTree;
import jadx.core.dex.visitors.blocks.FixMultiEntryLoops;
import jadx.core.dex.visitors.blocks.PostDominatorTree;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockProcessor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(BlockProcessor.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode() || mth.getBasicBlocks().isEmpty()) {
            return;
        }
        BlockProcessor.processBlocksTree(mth);
    }

    private static void processBlocksTree(MethodNode mth) {
        BlockProcessor.removeUnreachableBlocks(mth);
        BlockProcessor.computeDominators(mth);
        if (BlockProcessor.independentBlockTreeMod(mth)) {
            BlockProcessor.checkForUnreachableBlocks(mth);
            BlockProcessor.computeDominators(mth);
        }
        if (FixMultiEntryLoops.process(mth)) {
            BlockProcessor.computeDominators(mth);
        }
        BlockProcessor.updateCleanSuccessors(mth);
        int i = 0;
        while (BlockProcessor.modifyBlocksTree(mth)) {
            BlockProcessor.computeDominators(mth);
            if (i++ <= 100) continue;
            throw new JadxRuntimeException("CFG modification limit reached, blocks count: " + mth.getBasicBlocks().size());
        }
        BlockProcessor.checkForUnreachableBlocks(mth);
        DominatorTree.computeDominanceFrontier(mth);
        BlockProcessor.registerLoops(mth);
        BlockProcessor.processNestedLoops(mth);
        PostDominatorTree.compute(mth);
        BlockProcessor.updateCleanSuccessors(mth);
        if (!mth.contains(AFlag.DISABLE_BLOCKS_LOCK)) {
            mth.finishBasicBlocks();
        }
    }

    static void updateCleanSuccessors(MethodNode mth) {
        mth.getBasicBlocks().forEach(BlockNode::updateCleanSuccessors);
    }

    private static void checkForUnreachableBlocks(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!block.getPredecessors().isEmpty() || block == mth.getEnterBlock()) continue;
            throw new JadxRuntimeException("Unreachable block: " + block);
        }
    }

    private static boolean deduplicateBlockInsns(BlockNode block) {
        List<BlockNode> predecessors;
        int predsCount;
        if ((block.contains(AFlag.LOOP_START) || block.contains(AFlag.LOOP_END)) && (predsCount = (predecessors = block.getPredecessors()).size()) > 1) {
            InsnNode lastInsn = BlockUtils.getLastInsn(block);
            if (lastInsn != null && lastInsn.getType() == InsnType.IF) {
                return false;
            }
            if (BlockUtils.checkFirstInsn(block, insn -> insn.contains(AType.EXC_HANDLER))) {
                return false;
            }
            int sameInsnCount = BlockProcessor.getSameLastInsnCount(predecessors);
            if (sameInsnCount > 0) {
                List<InsnNode> insns = BlockProcessor.getLastInsns(predecessors.get(0), sameInsnCount);
                BlockProcessor.insertAtStart(block, insns);
                predecessors.forEach(pred -> BlockProcessor.getLastInsns(pred, sameInsnCount).clear());
                LOG.debug("Move duplicate insns, count: {} to block {}", (Object)sameInsnCount, (Object)block);
                return true;
            }
        }
        return false;
    }

    private static List<InsnNode> getLastInsns(BlockNode blockNode, int sameInsnCount) {
        List<InsnNode> instructions = blockNode.getInstructions();
        int size = instructions.size();
        return instructions.subList(size - sameInsnCount, size);
    }

    private static void insertAtStart(BlockNode block, List<InsnNode> insns) {
        List<InsnNode> blockInsns = block.getInstructions();
        ArrayList<InsnNode> newInsnList = new ArrayList<InsnNode>(insns.size() + blockInsns.size());
        newInsnList.addAll(insns);
        newInsnList.addAll(blockInsns);
        blockInsns.clear();
        blockInsns.addAll(newInsnList);
    }

    private static int getSameLastInsnCount(List<BlockNode> predecessors) {
        int sameInsnCount = 0;
        while (true) {
            InsnNode insn = null;
            for (BlockNode pred : predecessors) {
                InsnNode curInsn = BlockProcessor.getInsnsFromEnd(pred, sameInsnCount);
                if (curInsn == null) {
                    return sameInsnCount;
                }
                if (insn == null) {
                    insn = curInsn;
                    continue;
                }
                if (BlockProcessor.isSame(insn, curInsn)) continue;
                return sameInsnCount;
            }
            ++sameInsnCount;
        }
    }

    private static boolean isSame(InsnNode insn, InsnNode curInsn) {
        return BlockProcessor.isInsnsEquals(insn, curInsn) && insn.canReorder();
    }

    private static boolean isInsnsEquals(InsnNode insn, InsnNode otherInsn) {
        if (insn == otherInsn) {
            return true;
        }
        if (insn.isSame(otherInsn) && BlockProcessor.sameArgs(insn.getResult(), otherInsn.getResult())) {
            int argsCount = insn.getArgsCount();
            for (int i = 0; i < argsCount; ++i) {
                if (BlockProcessor.sameArgs(insn.getArg(i), otherInsn.getArg(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean sameArgs(@Nullable InsnArg arg, @Nullable InsnArg otherArg) {
        if (arg == otherArg) {
            return true;
        }
        if (arg == null || otherArg == null) {
            return false;
        }
        if (arg.getClass().equals(otherArg.getClass())) {
            if (arg.isRegister()) {
                return ((RegisterArg)arg).getRegNum() == ((RegisterArg)otherArg).getRegNum();
            }
            if (arg.isLiteral()) {
                return ((LiteralArg)arg).getLiteral() == ((LiteralArg)otherArg).getLiteral();
            }
            throw new JadxRuntimeException("Unexpected InsnArg types: " + arg + " and " + otherArg);
        }
        return false;
    }

    private static InsnNode getInsnsFromEnd(BlockNode block, int number) {
        List<InsnNode> instructions = block.getInstructions();
        int insnCount = instructions.size();
        if (insnCount <= number) {
            return null;
        }
        return instructions.get(insnCount - number - 1);
    }

    private static void computeDominators(MethodNode mth) {
        BlockProcessor.clearBlocksState(mth);
        DominatorTree.compute(mth);
        BlockProcessor.markLoops(mth);
    }

    private static void markLoops(MethodNode mth) {
        mth.getBasicBlocks().forEach(block -> block.getSuccessors().forEach(successor -> {
            if (block.getDoms().get(successor.getId()) || block == successor) {
                successor.add(AFlag.LOOP_START);
                block.add(AFlag.LOOP_END);
                Set<BlockNode> loopBlocks = BlockUtils.getAllPathsBlocks(successor, block);
                LoopInfo loop = new LoopInfo((BlockNode)successor, (BlockNode)block, loopBlocks);
                successor.addAttr(AType.LOOP, loop);
                block.addAttr(AType.LOOP, loop);
            }
        }));
    }

    private static void registerLoops(MethodNode mth) {
        mth.getBasicBlocks().forEach(block -> {
            if (block.contains(AFlag.LOOP_START)) {
                block.getAll(AType.LOOP).forEach(mth::registerLoop);
            }
        });
    }

    private static void processNestedLoops(MethodNode mth) {
        if (mth.getLoopsCount() == 0) {
            return;
        }
        for (LoopInfo outLoop : mth.getLoops()) {
            for (LoopInfo innerLoop : mth.getLoops()) {
                if (outLoop == innerLoop || !outLoop.getLoopBlocks().containsAll(innerLoop.getLoopBlocks())) continue;
                LoopInfo parentLoop = innerLoop.getParentLoop();
                if (parentLoop != null) {
                    if (parentLoop.getLoopBlocks().containsAll(outLoop.getLoopBlocks())) {
                        outLoop.setParentLoop(parentLoop);
                        innerLoop.setParentLoop(outLoop);
                        continue;
                    }
                    parentLoop.setParentLoop(outLoop);
                    continue;
                }
                innerLoop.setParentLoop(outLoop);
            }
        }
    }

    private static boolean modifyBlocksTree(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            if (!BlockProcessor.checkLoops(mth, block)) continue;
            return true;
        }
        if (BlockProcessor.mergeConstReturn(mth)) {
            return true;
        }
        return BlockProcessor.splitExitBlocks(mth);
    }

    private static boolean mergeConstReturn(MethodNode mth) {
        if (mth.isVoidReturn()) {
            return false;
        }
        boolean changed = false;
        for (BlockNode retBlock : new ArrayList<BlockNode>(mth.getPreExitBlocks())) {
            InsnArg retArg;
            InsnNode constInsn;
            BlockNode pred = Utils.getOne(retBlock.getPredecessors());
            if (pred == null || (constInsn = Utils.getOne(pred.getInstructions())) == null || !constInsn.isConstInsn()) continue;
            RegisterArg constArg = constInsn.getResult();
            InsnNode returnInsn = BlockUtils.getLastInsn(retBlock);
            if (returnInsn == null || returnInsn.getType() != InsnType.RETURN || !constArg.sameReg(retArg = returnInsn.getArg(0))) continue;
            BlockProcessor.mergeConstAndReturnBlocks(mth, retBlock, pred);
            changed = true;
        }
        if (changed) {
            BlockProcessor.removeMarkedBlocks(mth);
        }
        return changed;
    }

    private static void mergeConstAndReturnBlocks(MethodNode mth, BlockNode retBlock, BlockNode pred) {
        pred.getInstructions().addAll(retBlock.getInstructions());
        pred.copyAttributesFrom(retBlock);
        BlockSplitter.removeConnection(pred, retBlock);
        retBlock.getInstructions().clear();
        retBlock.add(AFlag.REMOVE);
        BlockNode exitBlock = mth.getExitBlock();
        BlockSplitter.removeConnection(retBlock, exitBlock);
        BlockSplitter.connect(pred, exitBlock);
        pred.updateCleanSuccessors();
    }

    private static boolean independentBlockTreeMod(MethodNode mth) {
        boolean changed = false;
        List<BlockNode> basicBlocks = mth.getBasicBlocks();
        for (BlockNode basicBlock : basicBlocks) {
            if (!BlockProcessor.deduplicateBlockInsns(basicBlock)) continue;
            changed = true;
        }
        if (BlockExceptionHandler.process(mth)) {
            changed = true;
        }
        for (BlockNode basicBlock : basicBlocks) {
            if (!BlockSplitter.removeEmptyBlock(basicBlock)) continue;
            changed = true;
        }
        if (BlockSplitter.removeEmptyDetachedBlocks(mth)) {
            changed = true;
        }
        return changed;
    }

    private static boolean simplifyLoopEnd(MethodNode mth, LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        if (loopEnd.getSuccessors().size() > 1) {
            BlockNode newLoopEnd = BlockSplitter.startNewBlock(mth, -1);
            newLoopEnd.add(AFlag.SYNTHETIC);
            newLoopEnd.add(AFlag.LOOP_END);
            BlockNode loopStart = loop.getStart();
            BlockSplitter.replaceConnection(loopEnd, loopStart, newLoopEnd);
            BlockSplitter.connect(newLoopEnd, loopStart);
            return true;
        }
        return false;
    }

    private static boolean checkLoops(MethodNode mth, BlockNode block) {
        if (!block.contains(AFlag.LOOP_START)) {
            return false;
        }
        List<LoopInfo> loops = block.getAll(AType.LOOP);
        int loopsCount = loops.size();
        if (loopsCount == 0) {
            return false;
        }
        for (LoopInfo loop : loops) {
            if (!BlockProcessor.insertBlocksForBreak(mth, loop)) continue;
            return true;
        }
        if (loopsCount > 1 && BlockProcessor.splitLoops(mth, block, loops)) {
            return true;
        }
        if (loopsCount == 1) {
            LoopInfo loop = loops.get(0);
            return BlockProcessor.insertBlocksForContinue(mth, loop) || BlockProcessor.insertBlockForPredecessors(mth, loop) || BlockProcessor.insertPreHeader(mth, loop) || BlockProcessor.simplifyLoopEnd(mth, loop);
        }
        return false;
    }

    private static boolean insertPreHeader(MethodNode mth, LoopInfo loop) {
        BlockNode start = loop.getStart();
        List<BlockNode> preds = start.getPredecessors();
        int predsCount = preds.size() - 1;
        if (predsCount == 1) {
            return false;
        }
        if (predsCount == 0) {
            if (!start.contains(AFlag.MTH_ENTER_BLOCK)) {
                mth.addWarnComment("Unexpected block without predecessors: " + start);
            }
            BlockNode newEnterBlock = BlockSplitter.startNewBlock(mth, -1);
            newEnterBlock.add(AFlag.SYNTHETIC);
            newEnterBlock.add(AFlag.MTH_ENTER_BLOCK);
            mth.setEnterBlock(newEnterBlock);
            start.remove(AFlag.MTH_ENTER_BLOCK);
            BlockSplitter.connect(newEnterBlock, start);
            return true;
        }
        BlockNode preHeader = BlockSplitter.startNewBlock(mth, -1);
        preHeader.add(AFlag.SYNTHETIC);
        for (BlockNode pred : new ArrayList<BlockNode>(preds)) {
            BlockSplitter.replaceConnection(pred, start, preHeader);
        }
        BlockSplitter.connect(preHeader, start);
        return true;
    }

    private static boolean insertBlocksForBreak(MethodNode mth, LoopInfo loop) {
        boolean change = false;
        List<Edge> edges = loop.getExitEdges();
        if (!edges.isEmpty()) {
            for (Edge edge : edges) {
                BlockNode target = edge.getTarget();
                BlockNode source = edge.getSource();
                if (target.contains(AFlag.SYNTHETIC) || source.contains(AFlag.SYNTHETIC)) continue;
                BlockSplitter.insertBlockBetween(mth, source, target);
                change = true;
            }
        }
        return change;
    }

    private static boolean insertBlocksForContinue(MethodNode mth, LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        boolean change = false;
        List<BlockNode> preds = loopEnd.getPredecessors();
        if (preds.size() > 1) {
            for (BlockNode pred : new ArrayList<BlockNode>(preds)) {
                if (pred.contains(AFlag.SYNTHETIC)) continue;
                BlockSplitter.insertBlockBetween(mth, pred, loopEnd);
                change = true;
            }
        }
        return change;
    }

    private static boolean insertBlockForPredecessors(MethodNode mth, LoopInfo loop) {
        BlockNode loopHeader = loop.getStart();
        List<BlockNode> preds = loopHeader.getPredecessors();
        if (preds.size() > 2) {
            ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(preds);
            blocks.removeIf(block -> block.contains(AFlag.LOOP_END));
            BlockNode first = (BlockNode)blocks.remove(0);
            BlockNode preHeader = BlockSplitter.insertBlockBetween(mth, first, loopHeader);
            blocks.forEach(block -> BlockSplitter.replaceConnection(block, loopHeader, preHeader));
            return true;
        }
        return false;
    }

    private static boolean splitLoops(MethodNode mth, BlockNode block, List<LoopInfo> loops) {
        boolean oneHeader = true;
        for (LoopInfo loop : loops) {
            if (loop.getStart() == block) continue;
            oneHeader = false;
            break;
        }
        if (oneHeader) {
            BlockNode newLoopEnd = BlockSplitter.startNewBlock(mth, block.getStartOffset());
            newLoopEnd.add(AFlag.SYNTHETIC);
            BlockSplitter.connect(newLoopEnd, block);
            for (LoopInfo la : loops) {
                BlockSplitter.replaceConnection(la.getEnd(), block, newLoopEnd);
            }
            return true;
        }
        return false;
    }

    private static boolean splitExitBlocks(MethodNode mth) {
        boolean changed = false;
        for (BlockNode preExitBlock : mth.getPreExitBlocks()) {
            if (BlockProcessor.splitReturn(mth, preExitBlock)) {
                changed = true;
                continue;
            }
            if (!BlockProcessor.splitThrow(mth, preExitBlock)) continue;
            changed = true;
        }
        if (changed) {
            BlockProcessor.updateExitBlockConnections(mth);
        }
        return changed;
    }

    private static void updateExitBlockConnections(MethodNode mth) {
        BlockNode exitBlock = mth.getExitBlock();
        BlockSplitter.removePredecessors(exitBlock);
        for (BlockNode block : mth.getBasicBlocks()) {
            if (block == exitBlock || !block.getSuccessors().isEmpty() || block.contains(AFlag.REMOVE)) continue;
            BlockSplitter.connect(block, exitBlock);
        }
    }

    private static boolean splitReturn(MethodNode mth, BlockNode returnBlock) {
        if (returnBlock.contains(AFlag.SYNTHETIC) || returnBlock.contains(AFlag.ORIG_RETURN) || returnBlock.contains(AType.EXC_HANDLER)) {
            return false;
        }
        List<BlockNode> preds = returnBlock.getPredecessors();
        if (preds.size() < 2) {
            return false;
        }
        InsnNode returnInsn = BlockUtils.getLastInsn(returnBlock);
        if (returnInsn == null) {
            return false;
        }
        if (returnInsn.getArgsCount() == 1 && returnBlock.getInstructions().size() == 1 && !BlockProcessor.isArgAssignInPred(preds, returnInsn.getArg(0))) {
            return false;
        }
        boolean first = true;
        for (BlockNode pred : new ArrayList<BlockNode>(preds)) {
            if (first) {
                returnBlock.add(AFlag.ORIG_RETURN);
                first = false;
                continue;
            }
            BlockNode newRetBlock = BlockSplitter.startNewBlock(mth, -1);
            newRetBlock.add(AFlag.SYNTHETIC);
            newRetBlock.add(AFlag.RETURN);
            for (InsnNode oldInsn : returnBlock.getInstructions()) {
                InsnNode copyInsn = oldInsn.copyWithoutSsa();
                copyInsn.add(AFlag.SYNTHETIC);
                newRetBlock.getInstructions().add(copyInsn);
            }
            BlockSplitter.replaceConnection(pred, returnBlock, newRetBlock);
        }
        return true;
    }

    private static boolean splitThrow(MethodNode mth, BlockNode exitBlock) {
        if (exitBlock.contains(AFlag.IGNORE_THROW_SPLIT)) {
            return false;
        }
        List<BlockNode> preds = exitBlock.getPredecessors();
        if (preds.size() < 2) {
            return false;
        }
        InsnNode throwInsn = BlockUtils.getLastInsn(exitBlock);
        if (throwInsn == null || throwInsn.getType() != InsnType.THROW) {
            return false;
        }
        HashMap handlersMap = new HashMap(preds.size());
        HashSet handlers = new HashSet(preds.size());
        for (BlockNode pred : preds) {
            BlockUtils.visitPredecessorsUntil(mth, pred, block -> {
                ExcHandlerAttr excHandlerAttr = block.get(AType.EXC_HANDLER);
                if (excHandlerAttr == null) {
                    return false;
                }
                boolean correctHandler = excHandlerAttr.getHandler().getBlocks().contains(block);
                if (correctHandler && BlockProcessor.isArgAssignInPred(Collections.singletonList(block), throwInsn.getArg(0))) {
                    handlersMap.put(pred, excHandlerAttr);
                    handlers.add(block);
                }
                return correctHandler;
            });
        }
        if (handlers.size() == 1) {
            exitBlock.add(AFlag.IGNORE_THROW_SPLIT);
            return false;
        }
        boolean first = true;
        for (BlockNode pred : new ArrayList<BlockNode>(preds)) {
            if (first) {
                first = false;
                continue;
            }
            BlockNode newThrowBlock = BlockSplitter.startNewBlock(mth, -1);
            newThrowBlock.add(AFlag.SYNTHETIC);
            for (InsnNode oldInsn : exitBlock.getInstructions()) {
                InsnNode copyInsn = oldInsn.copyWithoutSsa();
                copyInsn.add(AFlag.SYNTHETIC);
                newThrowBlock.getInstructions().add(copyInsn);
            }
            newThrowBlock.copyAttributesFrom(exitBlock);
            ExcHandlerAttr excHandlerAttr = (ExcHandlerAttr)handlersMap.get(pred);
            if (excHandlerAttr != null) {
                excHandlerAttr.getHandler().addBlock(newThrowBlock);
            }
            BlockSplitter.replaceConnection(pred, exitBlock, newThrowBlock);
        }
        return true;
    }

    private static boolean isArgAssignInPred(List<BlockNode> preds, InsnArg arg) {
        if (arg.isRegister()) {
            int regNum = ((RegisterArg)arg).getRegNum();
            for (BlockNode pred : preds) {
                for (InsnNode insnNode : pred.getInstructions()) {
                    RegisterArg result = insnNode.getResult();
                    if (result == null || result.getRegNum() != regNum) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeMarkedBlocks(MethodNode mth) {
        mth.getBasicBlocks().removeIf(block -> {
            if (block.contains(AFlag.REMOVE)) {
                if (!block.getPredecessors().isEmpty() || !block.getSuccessors().isEmpty()) {
                    LOG.warn("Block {} not deleted, method: {}", block, (Object)mth);
                } else {
                    TryCatchBlockAttr tryBlockAttr = block.get(AType.TRY_BLOCK);
                    if (tryBlockAttr != null) {
                        tryBlockAttr.removeBlock((BlockNode)block);
                    }
                    return true;
                }
            }
            return false;
        });
    }

    private static void removeUnreachableBlocks(MethodNode mth) {
        LinkedHashSet<BlockNode> toRemove = new LinkedHashSet<BlockNode>();
        for (BlockNode block : mth.getBasicBlocks()) {
            BlockProcessor.computeUnreachableFromBlock(toRemove, block, mth);
        }
        BlockProcessor.removeFromMethod(toRemove, mth);
    }

    public static void removeUnreachableBlock(BlockNode blockToRemove, MethodNode mth) {
        LinkedHashSet<BlockNode> toRemove = new LinkedHashSet<BlockNode>();
        BlockProcessor.computeUnreachableFromBlock(toRemove, blockToRemove, mth);
        BlockProcessor.removeFromMethod(toRemove, mth);
    }

    private static void computeUnreachableFromBlock(Set<BlockNode> toRemove, BlockNode block, MethodNode mth) {
        if (block.getPredecessors().isEmpty() && block != mth.getEnterBlock()) {
            BlockSplitter.collectSuccessors(block, mth.getEnterBlock(), toRemove);
        }
    }

    private static void removeFromMethod(Set<BlockNode> toRemove, MethodNode mth) {
        if (toRemove.isEmpty()) {
            return;
        }
        long notEmptyBlocks = toRemove.stream().filter(block -> !block.getInstructions().isEmpty()).count();
        if (notEmptyBlocks != 0L) {
            int insnsCount = toRemove.stream().mapToInt(block -> block.getInstructions().size()).sum();
            mth.addWarnComment("Unreachable blocks removed: " + notEmptyBlocks + ", instructions: " + insnsCount);
        }
        toRemove.forEach(BlockSplitter::detachBlock);
        mth.getBasicBlocks().removeAll(toRemove);
    }

    private static void clearBlocksState(MethodNode mth) {
        mth.getBasicBlocks().forEach(block -> {
            block.remove(AType.LOOP);
            block.remove(AFlag.LOOP_START);
            block.remove(AFlag.LOOP_END);
            block.setDoms(null);
            block.setIDom(null);
            block.setDomFrontier(null);
            block.getDominatesOn().clear();
        });
    }
}

