/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.utils.InsnRemover;
import java.util.ArrayList;

@JadxVisitor(name="MoveInlineVisitor", desc="Inline redundant move instructions", runAfter={SSATransform.class}, runBefore={CodeShrinkVisitor.class})
public class MoveInlineVisitor
extends AbstractVisitor {
    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        MoveInlineVisitor.moveInline(mth);
    }

    public static void moveInline(MethodNode mth) {
        InsnRemover remover = new InsnRemover(mth);
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            for (InsnNode insn : block.getInstructions()) {
                if (insn.getType() != InsnType.MOVE || !MoveInlineVisitor.processMove(mth, insn)) continue;
                remover.addAndUnbind(insn);
            }
            remover.perform();
        }
    }

    private static boolean processMove(MethodNode mth, InsnNode move) {
        InsnNode useInsn;
        RegisterArg moveReg;
        InsnArg moveArg;
        RegisterArg resultArg = move.getResult();
        if (resultArg.sameRegAndSVar(moveArg = move.getArg(0))) {
            return true;
        }
        if (moveArg.isRegister() && (moveReg = (RegisterArg)moveArg).getSVar().isAssignInPhi()) {
            return false;
        }
        SSAVar ssaVar = resultArg.getSVar();
        if (ssaVar.getUseList().isEmpty()) {
            return true;
        }
        if (ssaVar.isUsedInPhi()) {
            return false;
        }
        RegDebugInfoAttr debugInfo = moveArg.get(AType.REG_DEBUG_INFO);
        for (RegisterArg useArg : ssaVar.getUseList()) {
            RegDebugInfoAttr debugInfoAttr;
            useInsn = useArg.getParentInsn();
            if (useInsn == null) {
                return false;
            }
            if (debugInfo != null || (debugInfoAttr = useArg.get(AType.REG_DEBUG_INFO)) == null) continue;
            debugInfo = debugInfoAttr;
        }
        for (RegisterArg useArg : new ArrayList<RegisterArg>(ssaVar.getUseList())) {
            useInsn = useArg.getParentInsn();
            if (useInsn == null) continue;
            InsnArg replaceArg = moveArg.isRegister() ? ((RegisterArg)moveArg).duplicate(useArg.getInitType()) : moveArg.duplicate();
            useInsn.inheritMetadata(move);
            replaceArg.copyAttributesFrom(useArg);
            if (debugInfo != null) {
                replaceArg.addAttr(debugInfo);
            }
            if (useInsn.replaceArg(useArg, replaceArg)) continue;
            mth.addWarnComment("Failed to replace arg in insn: " + useInsn);
        }
        return true;
    }

    private static boolean deleteMove(MethodNode mth, InsnNode move) {
        InsnArg moveArg = move.getArg(0);
        if (!moveArg.isRegister()) {
            return false;
        }
        RegisterArg moveReg = (RegisterArg)moveArg;
        SSAVar ssaVar = moveReg.getSVar();
        if (ssaVar.getUseCount() != 1 || ssaVar.isUsedInPhi()) {
            return false;
        }
        RegisterArg assignArg = ssaVar.getAssign();
        InsnNode parentInsn = assignArg.getParentInsn();
        if (parentInsn == null) {
            return false;
        }
        if (parentInsn.getSourceLine() != move.getSourceLine() || moveArg.contains(AType.REG_DEBUG_INFO)) {
            return false;
        }
        InsnRemover.unbindAllArgs(mth, move);
        InsnRemover.unbindResult(mth, parentInsn);
        RegisterArg resArg = parentInsn.getResult();
        RegisterArg newResArg = move.getResult().duplicate(resArg.getInitType());
        newResArg.copyAttributesFrom(resArg);
        parentInsn.setResult(newResArg);
        return true;
    }
}

