/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import jadx.core.utils.exceptions.JadxRuntimeException;

public class AccessInfo {
    public static final int VISIBILITY_FLAGS = 7;
    private final int accFlags;
    private final AFType type;

    public AccessInfo(int accessFlags, AFType type) {
        this.accFlags = accessFlags;
        this.type = type;
    }

    public boolean containsFlag(int flag) {
        return (this.accFlags & flag) != 0;
    }

    public boolean containsFlags(int ... flags) {
        for (int flag : flags) {
            if ((this.accFlags & flag) != 0) continue;
            return false;
        }
        return true;
    }

    public AccessInfo remove(int flag) {
        if (this.containsFlag(flag)) {
            return new AccessInfo(this.accFlags & ~flag, this.type);
        }
        return this;
    }

    public AccessInfo add(int flag) {
        if (!this.containsFlag(flag)) {
            return new AccessInfo(this.accFlags | flag, this.type);
        }
        return this;
    }

    public AccessInfo changeVisibility(int flag) {
        int currentVisFlags = this.accFlags & 7;
        if (currentVisFlags == flag) {
            return this;
        }
        int unsetAllVisFlags = this.accFlags & 0xFFFFFFF8;
        return new AccessInfo(unsetAllVisFlags | flag, this.type);
    }

    public AccessInfo getVisibility() {
        return new AccessInfo(this.accFlags & 7, this.type);
    }

    public boolean isVisibilityWeakerThan(AccessInfo otherAccInfo) {
        int thisVis = this.accFlags & 7;
        int otherVis = otherAccInfo.accFlags & 7;
        if (thisVis == otherVis) {
            return false;
        }
        return AccessInfo.orderedVisibility(thisVis) < AccessInfo.orderedVisibility(otherVis);
    }

    private static int orderedVisibility(int flag) {
        switch (flag) {
            case 2: {
                return 1;
            }
            case 0: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 1: {
                return 4;
            }
        }
        throw new JadxRuntimeException("Unexpected visibility flag: " + flag);
    }

    public boolean isPublic() {
        return (this.accFlags & 1) != 0;
    }

    public boolean isProtected() {
        return (this.accFlags & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.accFlags & 2) != 0;
    }

    public boolean isPackagePrivate() {
        return (this.accFlags & 7) == 0;
    }

    public boolean isAbstract() {
        return (this.accFlags & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.accFlags & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.accFlags & 0x2000) != 0;
    }

    public boolean isNative() {
        return (this.accFlags & 0x100) != 0;
    }

    public boolean isStatic() {
        return (this.accFlags & 8) != 0;
    }

    public boolean isFinal() {
        return (this.accFlags & 0x10) != 0;
    }

    public boolean isConstructor() {
        return (this.accFlags & 0x10000) != 0;
    }

    public boolean isEnum() {
        return (this.accFlags & 0x4000) != 0;
    }

    public boolean isSynthetic() {
        return (this.accFlags & 0x1000) != 0;
    }

    public boolean isBridge() {
        return (this.accFlags & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.accFlags & 0x80) != 0;
    }

    public boolean isSynchronized() {
        return (this.accFlags & 0x20020) != 0;
    }

    public boolean isTransient() {
        return (this.accFlags & 0x80) != 0;
    }

    public boolean isVolatile() {
        return (this.accFlags & 0x40) != 0;
    }

    public boolean isModuleInfo() {
        return (this.accFlags & 0x8000) != 0;
    }

    public boolean isData() {
        return (this.accFlags & 0x40000) != 0;
    }

    public AFType getType() {
        return this.type;
    }

    public String makeString(boolean showHidden) {
        StringBuilder code = new StringBuilder();
        if (this.isPublic()) {
            code.append("public ");
        }
        if (this.isPrivate()) {
            code.append("private ");
        }
        if (this.isProtected()) {
            code.append("protected ");
        }
        if (this.isStatic()) {
            code.append("static ");
        }
        if (this.isFinal()) {
            code.append("final ");
        }
        if (this.isAbstract()) {
            code.append("abstract ");
        }
        if (this.isNative()) {
            code.append("native ");
        }
        switch (this.type) {
            case METHOD: {
                if (this.isSynchronized()) {
                    code.append("synchronized ");
                }
                if (!showHidden || !this.isBridge()) break;
                code.append("/* bridge */ ");
                break;
            }
            case FIELD: {
                if (this.isVolatile()) {
                    code.append("volatile ");
                }
                if (!this.isTransient()) break;
                code.append("transient ");
                break;
            }
            case CLASS: {
                if ((this.accFlags & 0x800) != 0) {
                    code.append("strict ");
                }
                if (!showHidden) break;
                if (this.isData()) {
                    code.append("/* data */ ");
                }
                if (!this.isModuleInfo()) break;
                code.append("/* module-info */ ");
            }
        }
        if (this.isSynthetic() && showHidden) {
            code.append("/* synthetic */ ");
        }
        return code.toString();
    }

    public String visibilityName() {
        if (this.isPackagePrivate()) {
            return "package-private";
        }
        if (this.isPublic()) {
            return "public";
        }
        if (this.isPrivate()) {
            return "private";
        }
        if (this.isProtected()) {
            return "protected";
        }
        throw new JadxRuntimeException("Unknown visibility flags: " + this.getVisibility());
    }

    public int rawValue() {
        return this.accFlags;
    }

    public String toString() {
        return "AccessInfo: " + this.type + " 0x" + Integer.toHexString(this.accFlags) + " (" + this.makeString(true) + ")";
    }

    public static enum AFType {
        CLASS,
        FIELD,
        METHOD;

    }
}

