/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.utils;

public class CodeUtils {
    public static String getLineForPos(String code, int pos) {
        int start = CodeUtils.getLineStartForPos(code, pos);
        int end = CodeUtils.getLineEndForPos(code, pos);
        return code.substring(start, end);
    }

    public static int getLineStartForPos(String code, int pos) {
        int start = CodeUtils.getNewLinePosBefore(code, pos);
        return start == -1 ? 0 : start + 1;
    }

    public static int getLineEndForPos(String code, int pos) {
        int end = CodeUtils.getNewLinePosAfter(code, pos);
        return end == -1 ? code.length() : end;
    }

    public static int getNewLinePosAfter(String code, int startPos) {
        int prev;
        int pos = code.indexOf(10, startPos);
        if (pos != -1 && code.charAt(prev = pos - 1) == '\r') {
            return prev;
        }
        return pos;
    }

    public static int getNewLinePosBefore(String code, int startPos) {
        return code.lastIndexOf(10, startPos);
    }

    public static int getLineNumForPos(String code, int pos, String newLine) {
        int newLineLen = newLine.length();
        int line = 1;
        int prev = 0;
        int next;
        while ((next = code.indexOf(newLine, prev)) < pos) {
            prev = next + newLineLen;
            ++line;
        }
        return line;
    }
}

