/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins;

import jadx.api.plugins.JadxPluginInfo;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JadxPluginInfoBuilder {
    private String pluginId;
    private String name;
    private String description;
    private String homepage = "";
    @Nullable
    private String provides;

    public static JadxPluginInfoBuilder pluginId(String pluginId) {
        JadxPluginInfoBuilder builder = new JadxPluginInfoBuilder();
        builder.pluginId = Objects.requireNonNull(pluginId);
        return builder;
    }

    private JadxPluginInfoBuilder() {
    }

    public JadxPluginInfoBuilder name(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public JadxPluginInfoBuilder description(String description) {
        this.description = Objects.requireNonNull(description);
        return this;
    }

    public JadxPluginInfoBuilder homepage(String homepage) {
        this.homepage = homepage;
        return this;
    }

    public JadxPluginInfoBuilder provides(String provides) {
        this.provides = provides;
        return this;
    }

    public JadxPluginInfo build() {
        Objects.requireNonNull(this.pluginId, "PluginId is required");
        Objects.requireNonNull(this.name, "Name is required");
        Objects.requireNonNull(this.description, "Description is required");
        if (this.provides == null) {
            this.provides = this.pluginId;
        }
        return new JadxPluginInfo(this.pluginId, this.name, this.description, this.homepage, this.provides);
    }
}

