/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.clsp.ClspGraph;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.AnonymousClassAttr;
import jadx.core.dex.attributes.nodes.PhiListAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.BaseInvokeNode;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.nodes.utils.MethodUtils;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.AttachMethodDetails;
import jadx.core.dex.visitors.ConstInlineVisitor;
import jadx.core.dex.visitors.InitCodeVariables;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.dex.visitors.ssa.SSATransform;
import jadx.core.dex.visitors.typeinference.BoundEnum;
import jadx.core.dex.visitors.typeinference.ITypeBound;
import jadx.core.dex.visitors.typeinference.ITypeBoundDynamic;
import jadx.core.dex.visitors.typeinference.TypeBoundCheckCastAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundConst;
import jadx.core.dex.visitors.typeinference.TypeBoundFieldGetAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundInvokeAssign;
import jadx.core.dex.visitors.typeinference.TypeBoundInvokeUse;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.dex.visitors.typeinference.TypeSearch;
import jadx.core.dex.visitors.typeinference.TypeUpdate;
import jadx.core.dex.visitors.typeinference.TypeUpdateResult;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnList;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="Type Inference", desc="Calculate best types for SSA variables", runAfter={SSATransform.class, ConstInlineVisitor.class, AttachMethodDetails.class})
public final class TypeInferenceVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeInferenceVisitor.class);
    private RootNode root;
    private TypeUpdate typeUpdate;
    private List<Function<MethodNode, Boolean>> resolvers;

    @Override
    public void init(RootNode root) {
        this.root = root;
        this.typeUpdate = root.getTypeUpdate();
        this.resolvers = Arrays.asList(this::initTypeBounds, this::runTypePropagation, this::tryRestoreTypeVarCasts, this::tryInsertCasts, this::tryDeduceTypes, this::trySplitConstInsns, this::tryToFixIncompatiblePrimitives, this::tryToForceImmutableTypes, this::tryInsertAdditionalMove, this::runMultiVariableSearch, this::tryRemoveGenerics);
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        TypeInferenceVisitor.assignImmutableTypes(mth);
        try {
            for (Function<MethodNode, Boolean> resolver : this.resolvers) {
                if (!resolver.apply(mth).booleanValue() || !TypeInferenceVisitor.checkTypes(mth)) continue;
                return;
            }
        }
        catch (Exception e) {
            mth.addError("Type inference failed with exception", e);
        }
    }

    private static boolean checkTypes(MethodNode mth) {
        for (SSAVar var : mth.getSVars()) {
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown()) continue;
            return false;
        }
        return true;
    }

    private boolean initTypeBounds(MethodNode mth) {
        List<SSAVar> ssaVars = mth.getSVars();
        ssaVars.forEach(this::attachBounds);
        ssaVars.forEach(this::mergePhiBounds);
        return false;
    }

    private boolean runTypePropagation(MethodNode mth) {
        List<SSAVar> ssaVars = mth.getSVars();
        ssaVars.forEach(var -> this.setImmutableType(mth, (SSAVar)var));
        ssaVars.forEach(var -> this.setBestType(mth, (SSAVar)var));
        return true;
    }

    private boolean runMultiVariableSearch(MethodNode mth) {
        try {
            TypeSearch typeSearch = new TypeSearch(mth);
            if (!typeSearch.run()) {
                mth.addWarnComment("Multi-variable type inference failed");
            }
            for (SSAVar var : mth.getSVars()) {
                if (var.getTypeInfo().getType().isTypeKnown()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            mth.addWarnComment("Multi-variable type inference failed. Error: " + Utils.getStackTrace(e));
            return false;
        }
    }

    private void setImmutableType(MethodNode mth, SSAVar ssaVar) {
        try {
            ArgType immutableType = ssaVar.getImmutableType();
            if (immutableType != null) {
                TypeUpdateResult typeUpdateResult = this.typeUpdate.applyWithWiderIgnSame(mth, ssaVar, immutableType);
            }
        }
        catch (JadxOverflowException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to set immutable type for var: {}", (Object)ssaVar, (Object)e);
        }
    }

    private boolean setBestType(MethodNode mth, SSAVar ssaVar) {
        try {
            return this.calculateFromBounds(mth, ssaVar);
        }
        catch (JadxOverflowException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Failed to calculate best type for var: {}", (Object)ssaVar, (Object)e);
            return false;
        }
    }

    private boolean calculateFromBounds(MethodNode mth, SSAVar ssaVar) {
        TypeInfo typeInfo = ssaVar.getTypeInfo();
        Set<ITypeBound> bounds = typeInfo.getBounds();
        Optional<ArgType> bestTypeOpt = this.selectBestTypeFromBounds(bounds);
        if (!bestTypeOpt.isPresent()) {
            return false;
        }
        ArgType candidateType = bestTypeOpt.get();
        TypeUpdateResult result = this.typeUpdate.apply(mth, ssaVar, candidateType);
        if (result == TypeUpdateResult.REJECT) {
            return false;
        }
        return result == TypeUpdateResult.CHANGED;
    }

    private Optional<ArgType> selectBestTypeFromBounds(Set<ITypeBound> bounds) {
        return bounds.stream().map(ITypeBound::getType).filter(Objects::nonNull).max(this.typeUpdate.getTypeCompare().getComparator());
    }

    private void attachBounds(SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        typeInfo.getBounds().clear();
        RegisterArg assign = var.getAssign();
        this.addAssignBound(typeInfo, assign);
        for (RegisterArg regArg : var.getUseList()) {
            this.addBound(typeInfo, this.makeUseBound(regArg));
        }
    }

    private void mergePhiBounds(SSAVar ssaVar) {
        for (PhiInsn usedInPhi : ssaVar.getUsedInPhi()) {
            Set<ITypeBound> bounds = ssaVar.getTypeInfo().getBounds();
            bounds.addAll(usedInPhi.getResult().getSVar().getTypeInfo().getBounds());
            for (InsnArg arg : usedInPhi.getArguments()) {
                bounds.addAll(((RegisterArg)arg).getSVar().getTypeInfo().getBounds());
            }
        }
    }

    private void addBound(TypeInfo typeInfo, ITypeBound bound) {
        if (bound == null) {
            return;
        }
        if (bound instanceof ITypeBoundDynamic || bound.getType() != ArgType.UNKNOWN) {
            typeInfo.getBounds().add(bound);
        }
    }

    private void addAssignBound(TypeInfo typeInfo, RegisterArg assign) {
        ArgType immutableType = assign.getImmutableType();
        if (immutableType != null) {
            this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, immutableType));
            return;
        }
        InsnNode insn = assign.getParentInsn();
        if (insn == null || insn.getResult() == null) {
            this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, assign.getInitType()));
            return;
        }
        switch (insn.getType()) {
            case NEW_INSTANCE: {
                ArgType clsType = (ArgType)((IndexInsnNode)insn).getIndex();
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, clsType));
                break;
            }
            case CONSTRUCTOR: {
                ArgType ctrClsType = this.replaceAnonymousType((ConstructorInsn)insn);
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, ctrClsType));
                break;
            }
            case CONST: {
                LiteralArg constLit = (LiteralArg)insn.getArg(0);
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, constLit.getType()));
                break;
            }
            case MOVE_EXCEPTION: {
                ExcHandlerAttr excHandlerAttr = insn.get(AType.EXC_HANDLER);
                if (excHandlerAttr != null) {
                    for (ClassInfo catchType : excHandlerAttr.getHandler().getCatchTypes()) {
                        this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, catchType.getType()));
                    }
                    break;
                }
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, insn.getResult().getInitType()));
                break;
            }
            case INVOKE: {
                this.addBound(typeInfo, this.makeAssignInvokeBound((InvokeNode)insn));
                break;
            }
            case IGET: {
                this.addBound(typeInfo, this.makeAssignFieldGetBound((IndexInsnNode)insn));
                break;
            }
            case CHECK_CAST: {
                this.addBound(typeInfo, new TypeBoundCheckCastAssign(this.root, (IndexInsnNode)insn));
                break;
            }
            default: {
                ArgType type = insn.getResult().getInitType();
                this.addBound(typeInfo, new TypeBoundConst(BoundEnum.ASSIGN, type));
            }
        }
    }

    private ArgType replaceAnonymousType(ConstructorInsn ctr) {
        AnonymousClassAttr baseTypeAttr;
        ClassNode ctrCls;
        if (ctr.isNewInstance() && (ctrCls = this.root.resolveClass(ctr.getClassType())) != null && ctrCls.contains(AFlag.DONT_GENERATE) && (baseTypeAttr = ctrCls.get(AType.ANONYMOUS_CLASS)) != null) {
            return baseTypeAttr.getBaseType();
        }
        return ctr.getClassType().getType();
    }

    private ITypeBound makeAssignFieldGetBound(IndexInsnNode insn) {
        ArgType initType = insn.getResult().getInitType();
        if (initType.containsTypeVariable()) {
            return new TypeBoundFieldGetAssign(this.root, insn, initType);
        }
        return new TypeBoundConst(BoundEnum.ASSIGN, initType);
    }

    private ITypeBound makeAssignInvokeBound(InvokeNode invokeNode) {
        ArgType boundType = invokeNode.getCallMth().getReturnType();
        ArgType genericReturnType = this.root.getMethodUtils().getMethodGenericReturnType(invokeNode);
        if (genericReturnType != null) {
            if (genericReturnType.containsTypeVariable()) {
                InvokeType invokeType = invokeNode.getInvokeType();
                if (invokeNode.getArgsCount() != 0 && invokeType != InvokeType.STATIC && invokeType != InvokeType.SUPER) {
                    return new TypeBoundInvokeAssign(this.root, invokeNode, genericReturnType);
                }
            } else {
                boundType = genericReturnType;
            }
        }
        return new TypeBoundConst(BoundEnum.ASSIGN, boundType);
    }

    @Nullable
    private ITypeBound makeUseBound(RegisterArg regArg) {
        ITypeBound invokeUseBound;
        InsnNode insn = regArg.getParentInsn();
        if (insn == null) {
            return null;
        }
        if (insn instanceof BaseInvokeNode && (invokeUseBound = this.makeInvokeUseBound(regArg, (BaseInvokeNode)insn)) != null) {
            return invokeUseBound;
        }
        if (insn.getType() == InsnType.CHECK_CAST && insn.contains(AFlag.SOFT_CAST)) {
            return null;
        }
        return new TypeBoundConst(BoundEnum.USE, regArg.getInitType(), regArg);
    }

    private ITypeBound makeInvokeUseBound(RegisterArg regArg, BaseInvokeNode invoke) {
        InsnArg instanceArg = invoke.getInstanceArg();
        if (instanceArg == null) {
            return null;
        }
        MethodUtils methodUtils = this.root.getMethodUtils();
        IMethodDetails methodDetails = methodUtils.getMethodDetails(invoke);
        if (methodDetails == null) {
            return null;
        }
        if (instanceArg != regArg) {
            int argIndex = invoke.getArgIndex(regArg) - invoke.getFirstArgOffset();
            ArgType argType = methodDetails.getArgTypes().get(argIndex);
            if (!argType.containsTypeVariable()) {
                return null;
            }
            return new TypeBoundInvokeUse(this.root, invoke, regArg, argType);
        }
        if (methodDetails instanceof MethodNode) {
            MethodNode callMth = (MethodNode)methodDetails;
            ClassInfo declCls = methodUtils.getMethodOriginDeclClass(callMth);
            return new TypeBoundConst(BoundEnum.USE, declCls.getType(), regArg);
        }
        return null;
    }

    private boolean tryPossibleTypes(MethodNode mth, SSAVar var, ArgType type) {
        List<ArgType> types = this.makePossibleTypesList(type, var);
        if (types.isEmpty()) {
            return false;
        }
        for (ArgType candidateType : types) {
            TypeUpdateResult result = this.typeUpdate.apply(mth, var, candidateType);
            if (result != TypeUpdateResult.CHANGED) continue;
            return true;
        }
        return false;
    }

    private List<ArgType> makePossibleTypesList(ArgType type, @Nullable SSAVar var) {
        if (type.isArray()) {
            ArrayList<ArgType> list = new ArrayList<ArgType>();
            for (ArgType arrElemType : this.makePossibleTypesList(type.getArrayElement(), null)) {
                list.add(ArgType.array(arrElemType));
            }
            return list;
        }
        if (var != null) {
            for (ITypeBound b : var.getTypeInfo().getBounds()) {
                ArgType boundType = b.getType();
                if (!boundType.isObject() && !boundType.isArray()) continue;
                return Collections.emptyList();
            }
        }
        ArrayList list = new ArrayList();
        for (PrimitiveType possibleType : type.getPossibleTypes()) {
            if (possibleType == PrimitiveType.VOID) continue;
            list.add(ArgType.convertFromPrimitiveType(possibleType));
        }
        return list;
    }

    private boolean tryDeduceTypes(MethodNode mth) {
        boolean fixed = false;
        for (SSAVar ssaVar : mth.getSVars()) {
            if (!this.deduceType(mth, ssaVar)) continue;
            fixed = true;
        }
        return fixed;
    }

    private boolean deduceType(MethodNode mth, SSAVar var) {
        if (var.isTypeImmutable()) {
            return false;
        }
        ArgType type = var.getTypeInfo().getType();
        if (type.isTypeKnown()) {
            return false;
        }
        if (this.setBestType(mth, var)) {
            return true;
        }
        if (this.tryPossibleTypes(mth, var, type)) {
            return true;
        }
        return this.tryWiderObjects(mth, var);
    }

    private boolean tryRemoveGenerics(MethodNode mth) {
        boolean resolved = true;
        for (SSAVar var : mth.getSVars()) {
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown() || var.isTypeImmutable() || this.tryRawType(mth, var)) continue;
            resolved = false;
        }
        return resolved;
    }

    private boolean tryRawType(MethodNode mth, SSAVar var) {
        LinkedHashSet<ArgType> objTypes = new LinkedHashSet<ArgType>();
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || !boundType.isObject()) continue;
            objTypes.add(boundType);
        }
        if (objTypes.isEmpty()) {
            return false;
        }
        for (ArgType objType : objTypes) {
            if (!this.checkRawType(mth, var, objType)) continue;
            mth.addDebugComment("Type inference failed for " + var.toShortString() + ". Raw type applied. Possible types: " + Utils.listToString(objTypes));
            return true;
        }
        return false;
    }

    private boolean checkRawType(MethodNode mth, SSAVar var, ArgType objType) {
        if (objType.isObject() && objType.containsGeneric()) {
            ArgType rawType = objType.isGenericType() ? ArgType.OBJECT : ArgType.object(objType.getObject());
            TypeUpdateResult result = this.typeUpdate.applyWithWiderAllow(mth, var, rawType);
            return result == TypeUpdateResult.CHANGED;
        }
        return false;
    }

    private boolean tryRestoreTypeVarCasts(MethodNode mth) {
        int changed = 0;
        List<SSAVar> mthSVars = mth.getSVars();
        for (SSAVar var : mthSVars) {
            changed += this.restoreTypeVarCasts(var);
        }
        if (changed == 0) {
            return false;
        }
        this.initTypeBounds(mth);
        return this.runTypePropagation(mth);
    }

    private int restoreTypeVarCasts(SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        Set<ITypeBound> bounds = typeInfo.getBounds();
        if (!ListUtils.anyMatch(bounds, t -> t.getType().isGenericType())) {
            return 0;
        }
        List<ITypeBound> casts = ListUtils.filter(bounds, TypeBoundCheckCastAssign.class::isInstance);
        if (casts.isEmpty()) {
            return 0;
        }
        ArgType bestType = this.selectBestTypeFromBounds(bounds).orElse(ArgType.UNKNOWN);
        if (!bestType.isGenericType()) {
            return 0;
        }
        List<ArgType> extendTypes = bestType.getExtendTypes();
        if (extendTypes.size() != 1) {
            return 0;
        }
        int fixed = 0;
        ArgType extendType = extendTypes.get(0);
        for (ITypeBound bound : casts) {
            TypeBoundCheckCastAssign cast = (TypeBoundCheckCastAssign)bound;
            ArgType castType = cast.getType();
            TypeCompareEnum result = this.typeUpdate.getTypeCompare().compareTypes(extendType, castType);
            if (!result.isEqual() && result != TypeCompareEnum.NARROW_BY_GENERIC) continue;
            cast.getInsn().updateIndex(bestType);
            ++fixed;
        }
        return fixed;
    }

    private boolean tryInsertCasts(MethodNode mth) {
        int added = 0;
        List<SSAVar> mthSVars = mth.getSVars();
        int varsCount = mthSVars.size();
        for (int i = 0; i < varsCount; ++i) {
            SSAVar var = mthSVars.get(i);
            ArgType type = var.getTypeInfo().getType();
            if (type.isTypeKnown() || var.isTypeImmutable()) continue;
            added += this.tryInsertVarCast(mth, var);
        }
        if (added != 0) {
            InitCodeVariables.rerun(mth);
            this.initTypeBounds(mth);
            return this.runTypePropagation(mth);
        }
        return false;
    }

    private int tryInsertVarCast(MethodNode mth, SSAVar var) {
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || boundType.equals(var.getTypeInfo().getType()) || !boundType.containsTypeVariable() || this.root.getTypeUtils().containsUnknownTypeVar(mth, boundType)) continue;
            if (this.insertAssignCast(mth, var, boundType)) {
                return 1;
            }
            return this.insertUseCasts(mth, var);
        }
        return 0;
    }

    private int insertUseCasts(MethodNode mth, SSAVar var) {
        List<RegisterArg> useList = var.getUseList();
        if (useList.isEmpty()) {
            return 0;
        }
        int useCasts = 0;
        for (RegisterArg useReg : new ArrayList<RegisterArg>(useList)) {
            if (!this.insertSoftUseCast(mth, useReg)) continue;
            ++useCasts;
        }
        return useCasts;
    }

    private boolean insertAssignCast(MethodNode mth, SSAVar var, ArgType castType) {
        RegisterArg assignArg = var.getAssign();
        InsnNode assignInsn = assignArg.getParentInsn();
        if (assignInsn == null || assignInsn.getType() == InsnType.PHI) {
            return false;
        }
        BlockNode assignBlock = BlockUtils.getBlockByInsn(mth, assignInsn);
        if (assignBlock == null) {
            return false;
        }
        RegisterArg newAssignArg = assignArg.duplicateWithNewSSAVar(mth);
        assignInsn.setResult(newAssignArg);
        IndexInsnNode castInsn = this.makeSoftCastInsn(assignArg, newAssignArg, castType);
        return BlockUtils.insertAfterInsn(assignBlock, assignInsn, castInsn);
    }

    private boolean insertSoftUseCast(MethodNode mth, RegisterArg useArg) {
        InsnNode useInsn = useArg.getParentInsn();
        if (useInsn == null || useInsn.getType() == InsnType.PHI) {
            return false;
        }
        if (useInsn.getType() == InsnType.IF && useInsn.getArg(1).isZeroLiteral()) {
            return false;
        }
        BlockNode useBlock = BlockUtils.getBlockByInsn(mth, useInsn);
        if (useBlock == null) {
            return false;
        }
        RegisterArg newUseArg = useArg.duplicateWithNewSSAVar(mth);
        useInsn.replaceArg(useArg, newUseArg);
        IndexInsnNode castInsn = this.makeSoftCastInsn(newUseArg, useArg, useArg.getInitType());
        return BlockUtils.insertBeforeInsn(useBlock, useInsn, castInsn);
    }

    @NotNull
    private IndexInsnNode makeSoftCastInsn(RegisterArg result, RegisterArg arg, ArgType castType) {
        IndexInsnNode castInsn = new IndexInsnNode(InsnType.CHECK_CAST, castType, 1);
        castInsn.setResult(result.duplicate());
        castInsn.addArg(arg.duplicate());
        castInsn.add(AFlag.SOFT_CAST);
        castInsn.add(AFlag.SYNTHETIC);
        return castInsn;
    }

    private boolean trySplitConstInsns(MethodNode mth) {
        boolean constSplitted = false;
        for (SSAVar var : new ArrayList<SSAVar>(mth.getSVars())) {
            if (!this.checkAndSplitConstInsn(mth, var)) continue;
            constSplitted = true;
        }
        if (!constSplitted) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.initTypeBounds(mth);
        return this.runTypePropagation(mth);
    }

    private boolean checkAndSplitConstInsn(MethodNode mth, SSAVar var) {
        ArgType type = var.getTypeInfo().getType();
        if (type.isTypeKnown() || var.isTypeImmutable()) {
            return false;
        }
        if (var.getUsedInPhi().size() < 2) {
            return false;
        }
        InsnNode assignInsn = var.getAssign().getAssignInsn();
        InsnNode constInsn = InsnUtils.checkInsnType(assignInsn, InsnType.CONST);
        if (constInsn == null) {
            return false;
        }
        BlockNode blockNode = BlockUtils.getBlockByInsn(mth, constInsn);
        if (blockNode == null) {
            return false;
        }
        boolean first = true;
        for (PhiInsn phiInsn : var.getUsedInPhi()) {
            if (first) {
                first = false;
                continue;
            }
            InsnNode copyInsn = constInsn.copyWithNewSsaVar(mth);
            copyInsn.add(AFlag.SYNTHETIC);
            BlockUtils.insertAfterInsn(blockNode, constInsn, copyInsn);
            RegisterArg phiArg = phiInsn.getArgBySsaVar(var);
            phiInsn.replaceArg(phiArg, copyInsn.getResult().duplicate());
        }
        return true;
    }

    private boolean tryInsertAdditionalMove(MethodNode mth) {
        int insnsAdded = 0;
        for (BlockNode block : mth.getBasicBlocks()) {
            PhiListAttr phiListAttr = block.get(AType.PHI_LIST);
            if (phiListAttr == null) continue;
            for (PhiInsn phiInsn : phiListAttr.getList()) {
                insnsAdded += this.tryInsertAdditionalInsn(mth, phiInsn);
            }
        }
        if (insnsAdded == 0) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.initTypeBounds(mth);
        if (this.runTypePropagation(mth) && TypeInferenceVisitor.checkTypes(mth)) {
            return true;
        }
        return this.tryDeduceTypes(mth);
    }

    private int tryInsertAdditionalInsn(MethodNode mth, PhiInsn phiInsn) {
        ArgType phiType = this.getCommonTypeForPhiArgs(phiInsn);
        if (phiType != null && phiType.isTypeKnown()) {
            return 0;
        }
        if (this.insertMovesForPhi(mth, phiInsn, false) == 0) {
            return 0;
        }
        return this.insertMovesForPhi(mth, phiInsn, true);
    }

    @Nullable
    private ArgType getCommonTypeForPhiArgs(PhiInsn phiInsn) {
        ArgType phiArgType = null;
        for (InsnArg arg : phiInsn.getArguments()) {
            ArgType type = arg.getType();
            if (phiArgType == null) {
                phiArgType = type;
                continue;
            }
            if (phiArgType.equals(type)) continue;
            return null;
        }
        return phiArgType;
    }

    private int insertMovesForPhi(MethodNode mth, PhiInsn phiInsn, boolean apply) {
        int argsCount = phiInsn.getArgsCount();
        int count = 0;
        for (int argIndex = 0; argIndex < argsCount; ++argIndex) {
            InsnType assignType;
            RegisterArg reg = phiInsn.getArg(argIndex);
            BlockNode startBlock = phiInsn.getBlockByArgIndex(argIndex);
            BlockNode blockNode = this.checkBlockForInsnInsert(startBlock);
            if (blockNode == null) {
                mth.addDebugComment("Failed to insert an additional move for type inference into block " + startBlock);
                return 0;
            }
            boolean add = true;
            SSAVar var = reg.getSVar();
            InsnNode assignInsn = var.getAssign().getAssignInsn();
            if (assignInsn != null && ((assignType = assignInsn.getType()) == InsnType.CONST || assignType == InsnType.MOVE && var.getUseCount() == 1)) {
                add = false;
            }
            if (!add) continue;
            ++count;
            if (!apply) continue;
            this.insertMove(mth, blockNode, phiInsn, reg);
        }
        return count;
    }

    private void insertMove(MethodNode mth, BlockNode blockNode, PhiInsn phiInsn, RegisterArg reg) {
        SSAVar var = reg.getSVar();
        int regNum = reg.getRegNum();
        RegisterArg resultArg = reg.duplicate(regNum, null);
        SSAVar newSsaVar = mth.makeNewSVar(resultArg);
        RegisterArg arg = reg.duplicate(regNum, var);
        InsnNode moveInsn = new InsnNode(InsnType.MOVE, 1);
        moveInsn.setResult(resultArg);
        moveInsn.addArg(arg);
        moveInsn.add(AFlag.SYNTHETIC);
        blockNode.getInstructions().add(moveInsn);
        phiInsn.replaceArg(reg, reg.duplicate(regNum, newSsaVar));
    }

    @Nullable
    private BlockNode checkBlockForInsnInsert(BlockNode blockNode) {
        if (blockNode.isSynthetic()) {
            return null;
        }
        InsnNode lastInsn = BlockUtils.getLastInsn(blockNode);
        if (lastInsn != null && BlockSplitter.isSeparate(lastInsn.getType())) {
            List<BlockNode> preds = blockNode.getPredecessors();
            if (preds.size() == 1) {
                return this.checkBlockForInsnInsert(preds.get(0));
            }
            return null;
        }
        return blockNode;
    }

    private boolean tryWiderObjects(MethodNode mth, SSAVar var) {
        LinkedHashSet<ArgType> objTypes = new LinkedHashSet<ArgType>();
        for (ITypeBound bound : var.getTypeInfo().getBounds()) {
            ArgType boundType = bound.getType();
            if (!boundType.isTypeKnown() || !boundType.isObject()) continue;
            objTypes.add(boundType);
        }
        if (objTypes.isEmpty()) {
            return false;
        }
        ClspGraph clsp = mth.root().getClsp();
        for (ArgType objType : objTypes) {
            for (String ancestor : clsp.getSuperTypes(objType.getObject())) {
                ArgType ancestorType = ArgType.object(ancestor);
                TypeUpdateResult result = this.typeUpdate.applyWithWiderAllow(mth, var, ancestorType);
                if (result != TypeUpdateResult.CHANGED) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryToFixIncompatiblePrimitives(MethodNode mth) {
        boolean fixed = false;
        List<SSAVar> ssaVars = mth.getSVars();
        int ssaVarsCount = ssaVars.size();
        for (int i = 0; i < ssaVarsCount; ++i) {
            if (!this.processIncompatiblePrimitives(mth, ssaVars.get(i))) continue;
            fixed = true;
        }
        if (!fixed) {
            return false;
        }
        InitCodeVariables.rerun(mth);
        this.initTypeBounds(mth);
        return this.runTypePropagation(mth);
    }

    private boolean processIncompatiblePrimitives(MethodNode mth, SSAVar var) {
        TypeInfo typeInfo = var.getTypeInfo();
        if (typeInfo.getType().isTypeKnown()) {
            return false;
        }
        boolean assigned = false;
        for (ITypeBound bound : typeInfo.getBounds()) {
            ArgType boundType = bound.getType();
            switch (bound.getBound()) {
                case ASSIGN: {
                    if (!boundType.contains(PrimitiveType.BOOLEAN)) {
                        return false;
                    }
                    assigned = true;
                    break;
                }
                case USE: {
                    if (boundType.canBeAnyNumber()) break;
                    return false;
                }
            }
        }
        if (!assigned) {
            return false;
        }
        boolean fixed = false;
        for (RegisterArg arg : new ArrayList<RegisterArg>(var.getUseList())) {
            if (!this.fixBooleanUsage(mth, arg)) continue;
            fixed = true;
        }
        return fixed;
    }

    private boolean fixBooleanUsage(MethodNode mth, RegisterArg boundArg) {
        InsnArg secondArg;
        ArithNode arithInsn;
        ArgType boundType = boundArg.getInitType();
        if (boundType == ArgType.BOOLEAN || boundType.isTypeKnown() && !boundType.isPrimitive()) {
            return false;
        }
        InsnNode insn = boundArg.getParentInsn();
        if (insn == null || insn.getType() == InsnType.IF) {
            return false;
        }
        BlockNode blockNode = BlockUtils.getBlockByInsn(mth, insn);
        if (blockNode == null) {
            return false;
        }
        List<InsnNode> insnList = blockNode.getInstructions();
        int insnIndex = InsnList.getIndex(insnList, insn);
        if (insnIndex == -1) {
            return false;
        }
        InsnType insnType = insn.getType();
        if (insnType == InsnType.CAST) {
            ArgType type = (ArgType)((IndexInsnNode)insn).getIndex();
            TernaryInsn convertInsn = this.prepareBooleanConvertInsn(insn.getResult(), boundArg, type);
            BlockUtils.replaceInsn(mth, blockNode, insnIndex, (InsnNode)convertInsn);
            return true;
        }
        if (insnType == InsnType.ARITH && (arithInsn = (ArithNode)insn).getOp() == ArithOp.XOR && arithInsn.getArgsCount() == 2 && (secondArg = arithInsn.getArg(1)).isLiteral() && ((LiteralArg)secondArg).getLiteral() == 1L) {
            InsnNode convertInsn = this.notBooleanToInt(arithInsn, boundArg);
            BlockUtils.replaceInsn(mth, blockNode, insnIndex, convertInsn);
            return true;
        }
        RegisterArg resultArg = boundArg.duplicateWithNewSSAVar(mth);
        TernaryInsn convertInsn = this.prepareBooleanConvertInsn(resultArg, boundArg, boundType);
        insnList.add(insnIndex, convertInsn);
        insn.replaceArg(boundArg, convertInsn.getResult().duplicate());
        return true;
    }

    private InsnNode notBooleanToInt(ArithNode insn, RegisterArg boundArg) {
        InsnNode notInsn = new InsnNode(InsnType.NOT, 1);
        notInsn.addArg(boundArg.duplicate());
        notInsn.add(AFlag.SYNTHETIC);
        InsnArg notArg = InsnArg.wrapArg(notInsn);
        notArg.setType(ArgType.BOOLEAN);
        TernaryInsn convertInsn = ModVisitor.makeBooleanConvertInsn(insn.getResult(), notArg, ArgType.INT);
        convertInsn.add(AFlag.SYNTHETIC);
        return convertInsn;
    }

    private TernaryInsn prepareBooleanConvertInsn(RegisterArg resultArg, RegisterArg boundArg, ArgType useType) {
        RegisterArg useArg = boundArg.getSVar().getAssign().duplicate();
        TernaryInsn convertInsn = ModVisitor.makeBooleanConvertInsn(resultArg, useArg, useType);
        convertInsn.add(AFlag.SYNTHETIC);
        return convertInsn;
    }

    private boolean tryToForceImmutableTypes(MethodNode mth) {
        boolean fixed = false;
        for (SSAVar ssaVar : mth.getSVars()) {
            ArgType type = ssaVar.getTypeInfo().getType();
            if (type.isTypeKnown() || !ssaVar.isTypeImmutable() || !this.forceImmutableType(ssaVar)) continue;
            fixed = true;
        }
        if (!fixed) {
            return false;
        }
        return this.runTypePropagation(mth);
    }

    private boolean forceImmutableType(SSAVar ssaVar) {
        for (RegisterArg useArg : ssaVar.getUseList()) {
            InsnType insnType;
            InsnNode parentInsn = useArg.getParentInsn();
            if (parentInsn == null || (insnType = parentInsn.getType()) != InsnType.AGET && insnType != InsnType.APUT) continue;
            ssaVar.setType(ssaVar.getImmutableType());
            return true;
        }
        return false;
    }

    private static void assignImmutableTypes(MethodNode mth) {
        for (SSAVar ssaVar : mth.getSVars()) {
            ArgType immutableType = TypeInferenceVisitor.getSsaImmutableType(ssaVar);
            if (immutableType == null) continue;
            ssaVar.markAsImmutable(immutableType);
        }
    }

    @Nullable
    private static ArgType getSsaImmutableType(SSAVar ssaVar) {
        if (ssaVar.getAssign().contains(AFlag.IMMUTABLE_TYPE)) {
            return ssaVar.getAssign().getInitType();
        }
        for (RegisterArg reg : ssaVar.getUseList()) {
            if (!reg.contains(AFlag.IMMUTABLE_TYPE)) continue;
            return reg.getInitType();
        }
        return null;
    }

    private static /* synthetic */ void lambda$initTypeBounds$0(SSAVar ssaVar) {
        LOG.debug("Type bounds for {}: {}", (Object)ssaVar.toShortString(), ssaVar.getTypeInfo().getBounds());
    }
}

