/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import jadx.api.plugins.input.insns.custom.ISwitchPayload;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;

public class SwitchData
extends InsnNode {
    private final int size;
    private final int[] keys;
    private final int[] targets;

    public SwitchData(ISwitchPayload payload) {
        super(InsnType.SWITCH_DATA, 0);
        this.size = payload.getSize();
        this.keys = payload.getKeys();
        this.targets = payload.getTargets();
    }

    public void fixTargets(int switchOffset) {
        int size = this.size;
        int[] targets = this.targets;
        int i = 0;
        while (i < size) {
            int n = i++;
            targets[n] = targets[n] + switchOffset;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getTargets() {
        return this.targets;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("switch-data {");
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.keys[i]).append("->").append(InsnUtils.formatOffset(this.targets[i])).append(", ");
        }
        sb.append('}');
        return sb.toString();
    }
}

