/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.deobf.Deobfuscator;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class TldHelper {
    private static final Set<String> TLD_SET = TldHelper.loadTldFile();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> loadTldFile() {
        HashSet<String> tldNames = new HashSet<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Deobfuscator.class.getResourceAsStream("tld_3.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                tldNames.add(line);
            }
            HashSet<String> hashSet = tldNames;
            return hashSet;
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to load top level domain list tld_3.txt", e);
        }
    }

    public static boolean contains(String name) {
        return TLD_SET.contains(name);
    }
}

