/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.args.ResourceNameSource;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.BetterName;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.IResParser;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResTableParser
extends CommonBinaryParser
implements IResParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResTableParser.class);
    private static final Pattern VALID_RES_KEY_PATTERN = Pattern.compile("[\\w\\d_]+");
    private final boolean useRawResName;
    private final RootNode root;
    private final ResourceStorage resStorage = new ResourceStorage();
    private String[] strings;

    public ResTableParser(RootNode root) {
        this(root, false);
    }

    public ResTableParser(RootNode root, boolean useRawResNames) {
        this.root = root;
        this.useRawResName = useRawResNames;
    }

    @Override
    public void decode(InputStream inputStream) throws IOException {
        this.is = new ParserStream(inputStream);
        this.decodeTableChunk();
        this.resStorage.finish();
    }

    public ResContainer decodeFiles(InputStream inputStream) throws IOException {
        this.decode(inputStream);
        ValuesParser vp = new ValuesParser(this.strings, this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp);
        ICodeInfo content = XmlGenUtils.makeXmlDump(this.root.makeCodeWriter(), this.resStorage);
        List<ResContainer> xmlFiles = resGen.makeResourcesXml();
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    void decodeTableChunk() throws IOException {
        this.is.checkInt16(2, "Not a table chunk");
        this.is.checkInt16(12, "Unexpected table header size");
        this.is.readInt32();
        int pkgCount = this.is.readInt32();
        this.strings = this.parseStringPool();
        for (int i = 0; i < pkgCount; ++i) {
            this.parsePackage();
        }
    }

    private PackageChunk parsePackage() throws IOException {
        long start = this.is.getPos();
        this.is.checkInt16(512, "Not a table chunk");
        int headerSize = this.is.readInt16();
        if (headerSize != 284 && headerSize != 288) {
            this.die("Unexpected package header size");
        }
        long size = this.is.readUInt32();
        long endPos = start + size;
        int id = this.is.readInt32();
        String name = this.is.readString16Fixed(128);
        long typeStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        long keyStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        if (headerSize == 288) {
            this.is.readInt32();
        }
        String[] typeStrings = null;
        if (typeStringsOffset != 0L) {
            this.is.skipToPos(typeStringsOffset, "Expected typeStrings string pool");
            typeStrings = this.parseStringPool();
        }
        String[] keyStrings = null;
        if (keyStringsOffset != 0L) {
            this.is.skipToPos(keyStringsOffset, "Expected keyStrings string pool");
            keyStrings = this.parseStringPool();
            this.deobfKeyStrings(keyStrings);
        }
        PackageChunk pkg = new PackageChunk(id, name, typeStrings, keyStrings);
        this.resStorage.setAppPackage(name);
        block8: while (this.is.getPos() < endPos) {
            long chunkStart = this.is.getPos();
            int type = this.is.readInt16();
            LOG.trace("res package chunk start at {} type {}", (Object)chunkStart, (Object)type);
            switch (type) {
                case 0: {
                    LOG.info("Null chunk type encountered at offset {}", (Object)chunkStart);
                    continue block8;
                }
                case 513: {
                    this.parseTypeChunk(chunkStart, pkg);
                    continue block8;
                }
                case 514: {
                    this.parseTypeSpecChunk(chunkStart);
                    continue block8;
                }
                case 515: {
                    this.parseLibraryTypeChunk(chunkStart);
                    continue block8;
                }
                case 516: {
                    throw new IOException(String.format("Encountered unsupported chunk type TYPE_OVERLAY at offset 0x%x ", chunkStart));
                }
                case 518: {
                    throw new IOException(String.format("Encountered unsupported chunk type TYPE_STAGED_ALIAS at offset 0x%x ", chunkStart));
                }
            }
            LOG.warn("Unknown chunk type {} encountered at offset {}", (Object)type, (Object)chunkStart);
        }
        return pkg;
    }

    private void deobfKeyStrings(String[] keyStrings) {
        int keysCount = keyStrings.length;
        if (this.root.getArgs().isRenamePrintable()) {
            for (int i = 0; i < keysCount; ++i) {
                String keyString = keyStrings[i];
                if (NameMapper.isAllCharsPrintable(keyString)) continue;
                keyStrings[i] = this.makeNewKeyName(i);
            }
        }
        if (this.root.getArgs().isRenameValid()) {
            HashSet<String> keySet = new HashSet<String>(keysCount);
            for (int i = 0; i < keysCount; ++i) {
                String keyString = keyStrings[i];
                boolean isNew = keySet.add(keyString);
                if (isNew) continue;
                keyStrings[i] = this.makeNewKeyName(i);
            }
        }
    }

    private String makeNewKeyName(int idx) {
        return String.format("jadx_deobf_0x%08x", idx);
    }

    private void parseTypeSpecChunk(long chunkStart) throws IOException {
        this.is.checkInt16(16, "Unexpected type spec header size");
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        int id = this.is.readInt8();
        this.is.skip(3L);
        int entryCount = this.is.readInt32();
        for (int i = 0; i < entryCount; ++i) {
            int n = this.is.readInt32();
        }
        if (this.is.getPos() != expectedEndPos) {
            throw new IOException(String.format("Error reading type spec chunk at offset 0x%x", chunkStart));
        }
    }

    private void parseLibraryTypeChunk(long chunkStart) throws IOException {
        LOG.trace("parsing library type chunk starting at offset {}", (Object)chunkStart);
        this.is.checkInt16(12, "Unexpected header size");
        int chunkSize = this.is.readInt32();
        long expectedEndPos = chunkStart + (long)chunkSize;
        int count = this.is.readInt32();
        for (int i = 0; i < count; ++i) {
            int packageId = this.is.readInt32();
            String packageName = this.is.readString16Fixed(128);
            LOG.info("Found resource shared library {}, pkgId: {}", (Object)packageName, (Object)packageId);
            if (this.is.getPos() <= expectedEndPos) continue;
            throw new IOException("reading after chunk end");
        }
        if (this.is.getPos() != expectedEndPos) {
            throw new IOException(String.format("Error reading library chunk at offset 0x%x", chunkStart));
        }
    }

    private void parseTypeChunk(long start, PackageChunk pkg) throws IOException {
        int i;
        this.is.readInt16();
        long chunkSize = this.is.readUInt32();
        long chunkEnd = start + chunkSize;
        int id = this.is.readInt8();
        this.is.checkInt8(0, "type chunk, res0");
        this.is.checkInt16(0, "type chunk, res1");
        int entryCount = this.is.readInt32();
        long entriesStart = start + (long)this.is.readInt32();
        EntryConfig config = this.parseConfig();
        if (config.isInvalid) {
            String typeName = pkg.getTypeStrings()[id - 1];
            LOG.warn("Invalid config flags detected: {}{}", (Object)typeName, (Object)config.getQualifiers());
        }
        int[] entryIndexes = new int[entryCount];
        for (i = 0; i < entryCount; ++i) {
            entryIndexes[i] = this.is.readInt32();
        }
        this.is.checkPos(entriesStart, "Expected entry start");
        for (i = 0; i < entryCount; ++i) {
            if (entryIndexes[i] == -1) continue;
            if (this.is.getPos() >= chunkEnd) {
                LOG.warn("End of chunk reached - ignoring remaining {} entries", (Object)(entryCount - i));
                break;
            }
            this.parseEntry(pkg, id, i, config.getQualifiers());
        }
        if (chunkEnd > this.is.getPos()) {
            long skipSize = chunkEnd - this.is.getPos();
            LOG.debug("Unknown data at the end of type chunk encountered, skipping {} bytes and continuing at offset {}", (Object)skipSize, (Object)chunkEnd);
            this.is.skip(skipSize);
        }
    }

    private void parseEntry(PackageChunk pkg, int typeId, int entryId, String config) throws IOException {
        int size = this.is.readInt16();
        int flags = this.is.readInt16();
        int key = this.is.readInt32();
        if (key == -1) {
            return;
        }
        int resRef = pkg.getId() << 24 | typeId << 16 | entryId;
        String typeName = pkg.getTypeStrings()[typeId - 1];
        String origKeyName = pkg.getKeyStrings()[key];
        ResourceEntry newResEntry = new ResourceEntry(resRef, pkg.getName(), typeName, this.getResName(typeName, resRef, origKeyName), config);
        ResourceEntry prevResEntry = this.resStorage.searchEntryWithSameName(newResEntry);
        if (prevResEntry != null) {
            newResEntry = newResEntry.copyWithId();
            ResourceEntry replaceForPrevEntry = prevResEntry.copyWithId();
            this.resStorage.replace(prevResEntry, replaceForPrevEntry);
            this.resStorage.addRename(replaceForPrevEntry);
        }
        if (!Objects.equals(origKeyName, newResEntry.getKeyName())) {
            this.resStorage.addRename(newResEntry);
        }
        if ((flags & 1) != 0 || size == 16) {
            int parentRef = this.is.readInt32();
            int count = this.is.readInt32();
            newResEntry.setParentRef(parentRef);
            ArrayList<RawNamedValue> values = new ArrayList<RawNamedValue>(count);
            for (int i = 0; i < count; ++i) {
                values.add(this.parseValueMap());
            }
            newResEntry.setNamedValues(values);
        } else {
            newResEntry.setSimpleValue(this.parseValue());
        }
        this.resStorage.add(newResEntry);
    }

    private String getResName(String typeName, int resRef, String origKeyName) {
        if (this.useRawResName) {
            return origKeyName;
        }
        String renamedKey = this.resStorage.getRename(resRef);
        if (renamedKey != null) {
            return renamedKey;
        }
        if (typeName.equals("style")) {
            return origKeyName;
        }
        FieldNode constField = this.root.getConstValues().getGlobalConstFields().get(resRef);
        String resAlias = this.getResAlias(resRef, origKeyName, constField);
        this.resStorage.addRename(resRef, resAlias);
        if (constField != null) {
            constField.rename(resAlias);
            constField.add(AFlag.DONT_RENAME);
        }
        return resAlias;
    }

    private String getResAlias(int resRef, String origKeyName, @Nullable FieldNode constField) {
        String name = constField == null || constField.getTopParentClass().isSynthetic() ? origKeyName : ResTableParser.getBetterName(this.root.getArgs().getResourceNameSource(), origKeyName, constField.getName());
        Matcher matcher = VALID_RES_KEY_PATTERN.matcher(name);
        if (matcher.matches()) {
            return name;
        }
        String cleanedResName = this.cleanName(matcher);
        String newResName = String.format("res_0x%08x", resRef);
        if (cleanedResName.isEmpty()) {
            return newResName;
        }
        return newResName + "_" + cleanedResName.toLowerCase();
    }

    public static String getBetterName(ResourceNameSource nameSource, String resName, String codeName) {
        switch (nameSource) {
            case AUTO: {
                return BetterName.compareAndGet(resName, codeName);
            }
            case RESOURCES: {
                return resName;
            }
            case CODE: {
                return codeName;
            }
        }
        throw new JadxRuntimeException("Unexpected ResourceNameSource value: " + (Object)((Object)nameSource));
    }

    private String cleanName(Matcher matcher) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (matcher.find()) {
            if (!first) {
                sb.append("_");
            }
            sb.append(matcher.group());
            first = false;
        }
        return sb.toString();
    }

    private RawNamedValue parseValueMap() throws IOException {
        int nameRef = this.is.readInt32();
        return new RawNamedValue(nameRef, this.parseValue());
    }

    private RawValue parseValue() throws IOException {
        this.is.checkInt16(8, "value size");
        this.is.checkInt8(0, "value res0 not 0");
        int dataType = this.is.readInt8();
        int data = this.is.readInt32();
        return new RawValue(dataType, data);
    }

    private EntryConfig parseConfig() throws IOException {
        long start = this.is.getPos();
        int size = this.is.readInt32();
        if (size < 28) {
            throw new IOException("Config size < 28");
        }
        short mcc = (short)this.is.readInt16();
        short mnc = (short)this.is.readInt16();
        char[] language = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), 'a');
        char[] country = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), '0');
        byte orientation = (byte)this.is.readInt8();
        byte touchscreen = (byte)this.is.readInt8();
        int density = this.is.readInt16();
        byte keyboard = (byte)this.is.readInt8();
        byte navigation = (byte)this.is.readInt8();
        byte inputFlags = (byte)this.is.readInt8();
        this.is.readInt8();
        short screenWidth = (short)this.is.readInt16();
        short screenHeight = (short)this.is.readInt16();
        short sdkVersion = (short)this.is.readInt16();
        this.is.readInt16();
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = (byte)this.is.readInt8();
            uiMode = (byte)this.is.readInt8();
            smallestScreenWidthDp = (short)this.is.readInt16();
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = (short)this.is.readInt16();
            screenHeightDp = (short)this.is.readInt16();
        }
        char[] localeScript = null;
        char[] localeVariant = null;
        if (size >= 48) {
            localeScript = this.readScriptOrVariantChar(4).toCharArray();
            localeVariant = this.readScriptOrVariantChar(8).toCharArray();
        }
        byte screenLayout2 = 0;
        byte colorMode = 0;
        if (size >= 52) {
            screenLayout2 = (byte)this.is.readInt8();
            colorMode = (byte)this.is.readInt8();
            this.is.readInt16();
        }
        this.is.skipToPos(start + (long)size, "Config skip trailing bytes");
        return new EntryConfig(mcc, mnc, language, country, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, false, size);
    }

    private char[] unpackLocaleOrRegion(byte in0, byte in1, char base) {
        if ((in0 >> 7 & 1) == 1) {
            int first = in1 & 0x1F;
            int second = ((in1 & 0xE0) >> 5) + ((in0 & 3) << 3);
            int third = (in0 & 0x7C) >> 2;
            return new char[]{(char)(first + base), (char)(second + base), (char)(third + base)};
        }
        return new char[]{(char)in0, (char)in1};
    }

    private String readScriptOrVariantChar(int length) throws IOException {
        short ch;
        long start = this.is.getPos();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < length && (ch = (short)this.is.readInt8()) != 0; ++i) {
            sb.append((char)ch);
        }
        this.is.skipToPos(start + (long)length, "readScriptOrVariantChar");
        return sb.toString();
    }

    @Override
    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    @Override
    public String[] getStrings() {
        return this.strings;
    }

    private static final class PackageChunk {
        private final int id;
        private final String name;
        private final String[] typeStrings;
        private final String[] keyStrings;

        private PackageChunk(int id, String name, String[] typeStrings, String[] keyStrings) {
            this.id = id;
            this.name = name;
            this.typeStrings = typeStrings;
            this.keyStrings = keyStrings;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTypeStrings() {
            return this.typeStrings;
        }

        public String[] getKeyStrings() {
            return this.keyStrings;
        }
    }
}

