/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.EmptyBitSet;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DominatorTree {
    public static void compute(MethodNode mth) {
        List<BlockNode> sorted = DominatorTree.sortBlocks(mth);
        BlockNode[] doms = DominatorTree.build(sorted);
        DominatorTree.apply(sorted, doms);
        mth.setBasicBlocks(sorted);
    }

    private static List<BlockNode> sortBlocks(MethodNode mth) {
        int blocksCount = mth.getBasicBlocks().size();
        BitSet reachSet = new BitSet(blocksCount);
        ArrayList<BlockNode> sorted = new ArrayList<BlockNode>(blocksCount);
        BlockUtils.dfsVisit(mth, b -> {
            sorted.add((BlockNode)b);
            reachSet.set(b.getId());
        });
        if (reachSet.cardinality() != blocksCount) {
            throw new JadxRuntimeException("Found unreachable blocks");
        }
        for (int i = 0; i < blocksCount; ++i) {
            ((BlockNode)sorted.get(i)).setId(i);
        }
        return sorted;
    }

    @NotNull
    private static BlockNode[] build(List<BlockNode> sorted) {
        int blocksCount = sorted.size();
        BlockNode[] doms = new BlockNode[blocksCount];
        doms[0] = sorted.get(0);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int blockId = 1; blockId < blocksCount; ++blockId) {
                BlockNode b = sorted.get(blockId);
                List<BlockNode> preds = b.getPredecessors();
                int pickedPred = -1;
                BlockNode newIDom = null;
                for (BlockNode pred : preds) {
                    int id = pred.getId();
                    if (doms[id] == null) continue;
                    newIDom = pred;
                    pickedPred = id;
                    break;
                }
                if (newIDom == null) {
                    throw new JadxRuntimeException("No predecessors for block: " + b);
                }
                for (BlockNode predBlock : preds) {
                    int predId = predBlock.getId();
                    if (predId == pickedPred || doms[predId] == null) continue;
                    newIDom = DominatorTree.intersect(sorted, doms, predBlock, newIDom);
                }
                if (doms[blockId] == newIDom) continue;
                doms[blockId] = newIDom;
                changed = true;
            }
        }
        return doms;
    }

    private static BlockNode intersect(List<BlockNode> sorted, BlockNode[] doms, BlockNode b1, BlockNode b2) {
        int f1 = b1.getId();
        int f2 = b2.getId();
        while (f1 != f2) {
            while (f1 > f2) {
                f1 = doms[f1].getId();
            }
            while (f2 > f1) {
                f2 = doms[f2].getId();
            }
        }
        return sorted.get(f1);
    }

    private static void apply(List<BlockNode> sorted, BlockNode[] doms) {
        BlockNode enterBlock = sorted.get(0);
        enterBlock.setDoms(EmptyBitSet.EMPTY);
        enterBlock.setIDom(null);
        int blocksCount = sorted.size();
        for (int i = 1; i < blocksCount; ++i) {
            BlockNode block = sorted.get(i);
            BlockNode idom = doms[i];
            block.setIDom(idom);
            idom.addDominatesOn(block);
            BitSet domBS = DominatorTree.collectDoms(doms, idom);
            domBS.clear(i);
            block.setDoms(domBS);
        }
    }

    private static BitSet collectDoms(BlockNode[] doms, BlockNode idom) {
        int id;
        BitSet domBS = new BitSet(doms.length);
        BlockNode nextIDom = idom;
        while (!domBS.get(id = nextIDom.getId())) {
            domBS.set(id);
            BitSet curDoms = nextIDom.getDoms();
            if (curDoms != null) {
                domBS.or(curDoms);
                break;
            }
            nextIDom = doms[id];
        }
        return domBS;
    }

    public static void computeDominanceFrontier(MethodNode mth) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        for (BlockNode block : blocks) {
            block.setDomFrontier(null);
        }
        int blocksCount = blocks.size();
        for (BlockNode block : blocks) {
            List<BlockNode> preds = block.getPredecessors();
            if (preds.size() < 2) continue;
            BlockNode idom = block.getIDom();
            Iterator<BlockNode> iterator = preds.iterator();
            while (iterator.hasNext()) {
                BlockNode pred;
                for (BlockNode runner = pred = iterator.next(); runner != idom; runner = runner.getIDom()) {
                    DominatorTree.addToDF(runner, block, blocksCount);
                }
            }
        }
        for (BlockNode block : blocks) {
            BitSet df = block.getDomFrontier();
            if (df != null && !df.isEmpty()) continue;
            block.setDomFrontier(EmptyBitSet.EMPTY);
        }
    }

    private static void addToDF(BlockNode block, BlockNode dfBlock, int blocksCount) {
        BitSet df = block.getDomFrontier();
        if (df == null) {
            df = new BitSet(blocksCount);
            block.setDomFrontier(df);
        }
        df.set(dfBlock.getId());
    }
}

