/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.impl.SimpleCodeWriter;
import jadx.core.utils.StringUtils;
import jadx.core.xmlgen.ManifestAttributes;
import jadx.core.xmlgen.ParserConstants;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.XmlGenUtils;
import jadx.core.xmlgen.entry.ProtoValue;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResXmlGen {
    private static final Set<String> SKIP_RES_TYPES = new HashSet<String>(Arrays.asList("anim", "animator", "font", "id", "interpolator", "layout", "menu", "mipmap", "navigation", "raw", "transition", "xml"));
    private final ResourceStorage resStorage;
    private final ValuesParser vp;

    public ResXmlGen(ResourceStorage resStorage, ValuesParser vp) {
        this.resStorage = resStorage;
        this.vp = vp;
    }

    public List<ResContainer> makeResourcesXml() {
        HashMap<String, ICodeWriter> contMap = new HashMap<String, ICodeWriter>();
        for (ResourceEntry ri : this.resStorage.getResources()) {
            if (SKIP_RES_TYPES.contains(ri.getTypeName())) continue;
            String fn = this.getFileName(ri);
            ICodeWriter cw = (ICodeWriter)contMap.get(fn);
            if (cw == null) {
                cw = new SimpleCodeWriter();
                cw.add("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                cw.startLine("<resources>");
                cw.incIndent();
                contMap.put(fn, cw);
            }
            this.addValue(cw, ri);
        }
        ArrayList<ResContainer> files = new ArrayList<ResContainer>(contMap.size());
        for (Map.Entry entry : contMap.entrySet()) {
            String fileName = (String)entry.getKey();
            ICodeWriter content = (ICodeWriter)entry.getValue();
            content.decIndent();
            content.startLine("</resources>");
            ICodeInfo codeInfo = content.finish();
            files.add(ResContainer.textResource(fileName, codeInfo));
        }
        Collections.sort(files);
        return files;
    }

    private void addValue(ICodeWriter cw, ResourceEntry ri) {
        if (ri.getProtoValue() != null) {
            ProtoValue protoValue = ri.getProtoValue();
            if (protoValue.getValue() != null && protoValue.getNamedValues() == null) {
                this.addSimpleValue(cw, ri.getTypeName(), ri.getTypeName(), "name", ri.getKeyName(), protoValue.getValue());
            } else {
                cw.startLine();
                cw.add('<').add(ri.getTypeName()).add(' ');
                String itemTag = "item";
                cw.add("name=\"").add(ri.getKeyName()).add('\"');
                if (ri.getTypeName().equals("attr") && protoValue.getValue() != null) {
                    cw.add(" format=\"").add(protoValue.getValue()).add('\"');
                }
                if (protoValue.getParent() != null) {
                    cw.add(" parent=\"").add(protoValue.getParent()).add('\"');
                }
                cw.add(">");
                cw.incIndent();
                for (ProtoValue value : protoValue.getNamedValues()) {
                    this.addProtoItem(cw, itemTag, ri.getTypeName(), value);
                }
                cw.decIndent();
                cw.startLine().add("</").add(ri.getTypeName()).add('>');
            }
        } else if (ri.getSimpleValue() != null) {
            String valueStr = this.vp.decodeValue(ri.getSimpleValue());
            this.addSimpleValue(cw, ri.getTypeName(), ri.getTypeName(), "name", ri.getKeyName(), valueStr);
        } else {
            cw.startLine();
            cw.add('<').add(ri.getTypeName()).add(' ');
            String itemTag = "item";
            if (ri.getTypeName().equals("attr") && !ri.getNamedValues().isEmpty()) {
                cw.add("name=\"").add(ri.getKeyName());
                int type = ri.getNamedValues().get(0).getRawValue().getData();
                if ((type & 0x10000) != 0) {
                    itemTag = "enum";
                } else if ((type & 0x20000) != 0) {
                    itemTag = "flag";
                }
                String formatValue = XmlGenUtils.getAttrTypeAsString(type);
                if (formatValue != null) {
                    cw.add("\" format=\"").add(formatValue);
                }
                cw.add("\"");
            } else {
                cw.add("name=\"").add(ri.getKeyName()).add('\"');
            }
            if (ri.getParentRef() != 0) {
                String parent = this.vp.decodeValue(1, ri.getParentRef());
                cw.add(" parent=\"").add(parent).add('\"');
            }
            cw.add(">");
            cw.incIndent();
            for (RawNamedValue value : ri.getNamedValues()) {
                this.addItem(cw, itemTag, ri.getTypeName(), value);
            }
            cw.decIndent();
            cw.startLine().add("</").add(ri.getTypeName()).add('>');
        }
    }

    private void addProtoItem(ICodeWriter cw, String itemTag, String typeName, ProtoValue protoValue) {
        String name = protoValue.getName();
        String value = protoValue.getValue();
        switch (typeName) {
            case "attr": {
                if (name == null) break;
                this.addSimpleValue(cw, typeName, itemTag, name, value, "");
                break;
            }
            case "style": {
                if (name == null) break;
                this.addSimpleValue(cw, typeName, itemTag, name, "", value);
                break;
            }
            case "plurals": {
                this.addSimpleValue(cw, typeName, itemTag, "quantity", name, value);
                break;
            }
            default: {
                this.addSimpleValue(cw, typeName, itemTag, null, null, value);
            }
        }
    }

    private void addItem(ICodeWriter cw, String itemTag, String typeName, RawNamedValue value) {
        String nameStr = this.vp.decodeNameRef(value.getNameRef());
        String valueStr = this.vp.decodeValue(value.getRawValue());
        if (!typeName.equals("attr")) {
            if (valueStr == null || valueStr.equals("0")) {
                valueStr = "@null";
            }
            if (nameStr != null) {
                try {
                    int intVal = Integer.parseInt(valueStr);
                    String newVal = ManifestAttributes.getInstance().decode(nameStr.replace("android:attr.", ""), intVal);
                    if (newVal != null) {
                        valueStr = newVal;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        switch (typeName) {
            case "attr": {
                if (nameStr == null) break;
                this.addSimpleValue(cw, typeName, itemTag, nameStr, valueStr, "");
                break;
            }
            case "style": {
                if (nameStr == null) break;
                this.addSimpleValue(cw, typeName, itemTag, nameStr, "", valueStr);
                break;
            }
            case "plurals": {
                String quantity = ParserConstants.PLURALS_MAP.get(value.getNameRef());
                this.addSimpleValue(cw, typeName, itemTag, "quantity", quantity, valueStr);
                break;
            }
            default: {
                this.addSimpleValue(cw, typeName, itemTag, null, null, valueStr);
            }
        }
    }

    private void addSimpleValue(ICodeWriter cw, String typeName, String itemTag, String attrName, String attrValue, String valueStr) {
        if (valueStr == null) {
            return;
        }
        if (valueStr.startsWith("res/")) {
            return;
        }
        cw.startLine();
        cw.add('<').add(itemTag);
        if (attrName != null && attrValue != null) {
            if (typeName.equals("attr")) {
                cw.add(' ').add("name=\"").add(attrName.replace("id.", "")).add("\" value=\"").add(attrValue).add('\"');
            } else if (typeName.equals("style")) {
                cw.add(' ').add("name=\"").add(attrName.replace("attr.", "")).add('\"');
            } else {
                cw.add(' ').add(attrName).add("=\"").add(attrValue).add('\"');
            }
        }
        if (valueStr.equals("")) {
            cw.add(" />");
        } else {
            cw.add('>');
            if (itemTag.equals("string")) {
                cw.add(StringUtils.escapeResStrValue(valueStr));
            } else {
                cw.add(StringUtils.escapeResValue(valueStr));
            }
            cw.add("</").add(itemTag).add('>');
        }
    }

    private String getFileName(ResourceEntry ri) {
        StringBuilder sb = new StringBuilder();
        String qualifiers = ri.getConfig();
        sb.append("res/values");
        if (!qualifiers.isEmpty()) {
            sb.append(qualifiers);
        }
        sb.append('/');
        sb.append(ri.getTypeName());
        if (!ri.getTypeName().endsWith("s")) {
            sb.append('s');
        }
        sb.append(".xml");
        return sb.toString();
    }
}

