/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.metadata.annotations.VarNode;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class JavaVariable
implements JavaNode {
    private final JavaMethod mth;
    private final VarNode varNode;

    public JavaVariable(JavaMethod mth, VarNode varNode) {
        this.mth = mth;
        this.varNode = varNode;
    }

    public JavaMethod getMth() {
        return this.mth;
    }

    public int getReg() {
        return this.varNode.getReg();
    }

    public int getSsa() {
        return this.varNode.getSsa();
    }

    @Override
    public String getName() {
        return this.varNode.getName();
    }

    @ApiStatus.Internal
    public VarNode getVarNode() {
        return this.varNode;
    }

    @Override
    public String getFullName() {
        return this.varNode.getType() + " " + this.varNode.getName() + " (r" + this.varNode.getReg() + "v" + this.varNode.getSsa() + ")";
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.mth.getDeclaringClass();
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.mth.getTopParentClass();
    }

    @Override
    public int getDefPos() {
        return this.varNode.getDefPosition();
    }

    @Override
    public List<JavaNode> getUseIn() {
        return Collections.singletonList(this.mth);
    }

    public int hashCode() {
        return this.varNode.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVariable)) {
            return false;
        }
        return this.varNode.equals(((JavaVariable)o).varNode);
    }
}

