/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeCache;
import jadx.api.ICodeInfo;
import jadx.api.JadxDecompiler;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.AnonymousClassAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaClass
implements JavaNode {
    private final JadxDecompiler decompiler;
    private final ClassNode cls;
    private final JavaClass parent;
    private List<JavaClass> innerClasses = Collections.emptyList();
    private List<JavaClass> inlinedClasses = Collections.emptyList();
    private List<JavaField> fields = Collections.emptyList();
    private List<JavaMethod> methods = Collections.emptyList();
    private boolean listsLoaded;

    JavaClass(ClassNode classNode, JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.cls = classNode;
        this.parent = null;
    }

    JavaClass(ClassNode classNode, JavaClass parent) {
        this.decompiler = null;
        this.cls = classNode;
        this.parent = parent;
    }

    public String getCode() {
        return this.getCodeInfo().getCodeStr();
    }

    @NotNull
    public ICodeInfo getCodeInfo() {
        this.load();
        return this.cls.decompile();
    }

    public void decompile() {
        this.load();
    }

    public synchronized ICodeInfo reload() {
        this.listsLoaded = false;
        return this.cls.reloadCode();
    }

    public void unload() {
        this.listsLoaded = false;
        this.cls.unloadCode();
    }

    public boolean isNoCode() {
        return this.cls.contains(AFlag.DONT_GENERATE);
    }

    public boolean isInner() {
        return this.cls.isInner();
    }

    public synchronized String getSmali() {
        return this.cls.getDisassembledCode();
    }

    @ApiStatus.Internal
    public ClassNode getClassNode() {
        return this.cls;
    }

    @Nullable
    private synchronized void load() {
        int n;
        int fieldsCount;
        int inlinedClsCount;
        int inClsCount;
        if (this.listsLoaded) {
            return;
        }
        this.listsLoaded = true;
        JadxDecompiler rootDecompiler = this.getRootDecompiler();
        ICodeCache codeCache = rootDecompiler.getArgs().getCodeCache();
        if (!codeCache.contains(this.cls.getRawName())) {
            this.cls.decompile();
        }
        if ((inClsCount = this.cls.getInnerClasses().size()) != 0) {
            ArrayList<JavaClass> list = new ArrayList<JavaClass>(inClsCount);
            for (ClassNode classNode : this.cls.getInnerClasses()) {
                if (classNode.contains(AFlag.DONT_GENERATE)) continue;
                JavaClass javaClass = rootDecompiler.convertClassNode(classNode);
                javaClass.load();
                list.add(javaClass);
            }
            this.innerClasses = Collections.unmodifiableList(list);
        }
        if ((inlinedClsCount = this.cls.getInlinedClasses().size()) != 0) {
            ArrayList<JavaClass> list = new ArrayList<JavaClass>(inlinedClsCount);
            for (ClassNode classNode : this.cls.getInlinedClasses()) {
                JavaClass javaClass = rootDecompiler.convertClassNode(classNode);
                javaClass.load();
                list.add(javaClass);
            }
            this.inlinedClasses = Collections.unmodifiableList(list);
        }
        if ((fieldsCount = this.cls.getFields().size()) != 0) {
            ArrayList<JavaField> arrayList = new ArrayList<JavaField>(fieldsCount);
            for (FieldNode f : this.cls.getFields()) {
                JavaField javaField = new JavaField(this, f);
                arrayList.add(javaField);
            }
            this.fields = Collections.unmodifiableList(arrayList);
        }
        if ((n = this.cls.getMethods().size()) != 0) {
            ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>(n);
            for (MethodNode m : this.cls.getMethods()) {
                if (m.contains(AFlag.DONT_GENERATE)) continue;
                JavaMethod javaMethod = new JavaMethod(this, m);
                arrayList.add(javaMethod);
            }
            arrayList.sort(Comparator.comparing(JavaMethod::getName));
            this.methods = Collections.unmodifiableList(arrayList);
        }
    }

    protected JadxDecompiler getRootDecompiler() {
        if (this.parent != null) {
            return this.parent.getRootDecompiler();
        }
        return this.decompiler;
    }

    public ICodeAnnotation getAnnotationAt(int pos) {
        return this.getCodeInfo().getCodeMetadata().getAt(pos);
    }

    public Map<Integer, JavaNode> getUsageMap() {
        Map<Integer, ICodeAnnotation> map = this.getCodeInfo().getCodeMetadata().getAsMap();
        if (map.isEmpty() || this.decompiler == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, JavaNode> resultMap = new HashMap<Integer, JavaNode>(map.size());
        for (Map.Entry<Integer, ICodeAnnotation> entry : map.entrySet()) {
            JavaNode node;
            int codePosition = entry.getKey();
            ICodeAnnotation obj = entry.getValue();
            if (!(obj instanceof ICodeNodeRef) || (node = this.getRootDecompiler().getJavaNodeByRef((ICodeNodeRef)obj)) == null) continue;
            resultMap.put(codePosition, node);
        }
        return resultMap;
    }

    public List<Integer> getUsePlacesFor(ICodeInfo codeInfo, JavaNode javaNode) {
        Map<Integer, ICodeAnnotation> map = codeInfo.getCodeMetadata().getAsMap();
        if (map.isEmpty() || this.decompiler == null) {
            return Collections.emptyList();
        }
        JadxDecompiler rootDec = this.getRootDecompiler();
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map.Entry<Integer, ICodeAnnotation> entry : map.entrySet()) {
            JavaNode annNode;
            ICodeAnnotation ann = entry.getValue();
            if (ann.getAnnType() == ICodeAnnotation.AnnType.DECLARATION || !javaNode.equals(annNode = rootDec.getJavaNodeByCodeAnnotation(codeInfo, ann))) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    @Override
    public List<JavaNode> getUseIn() {
        return this.getRootDecompiler().convertNodes(this.cls.getUseIn());
    }

    public Integer getSourceLine(int decompiledLine) {
        return this.getCodeInfo().getCodeMetadata().getLineMapping().get(decompiledLine);
    }

    @Override
    public String getName() {
        return this.cls.getShortName();
    }

    @Override
    public String getFullName() {
        return this.cls.getFullName();
    }

    public String getRawName() {
        return this.cls.getRawName();
    }

    public String getPackage() {
        return this.cls.getPackage();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    @Override
    public JavaClass getTopParentClass() {
        if (this.cls.contains(AType.ANONYMOUS_CLASS)) {
            return this.getParentForAnonymousClass();
        }
        return this.parent == null ? this : this.parent.getTopParentClass();
    }

    private JavaClass getParentForAnonymousClass() {
        AnonymousClassAttr attr = this.cls.get(AType.ANONYMOUS_CLASS);
        ClassNode topParentClass = attr.getOuterCls().getTopParentClass();
        return this.getRootDecompiler().convertClassNode(topParentClass);
    }

    public AccessInfo getAccessInfo() {
        return this.cls.getAccessFlags();
    }

    public List<JavaClass> getInnerClasses() {
        this.load();
        return this.innerClasses;
    }

    public List<JavaClass> getInlinedClasses() {
        this.load();
        return this.inlinedClasses;
    }

    public List<JavaField> getFields() {
        this.load();
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        this.load();
        return this.methods;
    }

    @Nullable
    public JavaMethod searchMethodByShortId(String shortId) {
        MethodNode methodNode = this.cls.searchMethodByShortId(shortId);
        if (methodNode == null) {
            return null;
        }
        return new JavaMethod(this, methodNode);
    }

    @Override
    public void removeAlias() {
        this.cls.getClassInfo().removeAlias();
    }

    @Override
    public int getDefPos() {
        return this.cls.getDefPosition();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof JavaClass && this.cls.equals(((JavaClass)o).cls);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public String toString() {
        return this.getFullName();
    }
}

