/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.IDecompileScheduler;
import jadx.api.JadxArgs;
import jadx.api.JadxArgsValidator;
import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.api.JavaVariable;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.metadata.annotations.NodeDeclareRef;
import jadx.api.metadata.annotations.VarNode;
import jadx.api.metadata.annotations.VarRef;
import jadx.api.plugins.JadxPlugin;
import jadx.api.plugins.JadxPluginManager;
import jadx.api.plugins.input.JadxInputPlugin;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.options.JadxPluginOptions;
import jadx.core.Jadx;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.InlinedAttr;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.SaveCode;
import jadx.core.export.ExportGradleProject;
import jadx.core.utils.DecompilerScheduler;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.BinaryXMLParser;
import jadx.core.xmlgen.ProtoXMLParser;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResourcesSaver;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JadxDecompiler
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(JadxDecompiler.class);
    private final JadxArgs args;
    private final JadxPluginManager pluginManager = new JadxPluginManager();
    private final List<ILoadResult> loadedInputs = new ArrayList<ILoadResult>();
    private RootNode root;
    private List<JavaClass> classes;
    private List<ResourceFile> resources;
    private BinaryXMLParser binaryXmlParser;
    private ProtoXMLParser protoXmlParser;
    private final Map<ClassNode, JavaClass> classesMap = new ConcurrentHashMap<ClassNode, JavaClass>();
    private final Map<MethodNode, JavaMethod> methodsMap = new ConcurrentHashMap<MethodNode, JavaMethod>();
    private final Map<FieldNode, JavaField> fieldsMap = new ConcurrentHashMap<FieldNode, JavaField>();
    private final IDecompileScheduler decompileScheduler = new DecompilerScheduler(this);
    private final List<ILoadResult> customLoads = new ArrayList<ILoadResult>();

    public JadxDecompiler() {
        this(new JadxArgs());
    }

    public JadxDecompiler(JadxArgs args) {
        this.args = args;
    }

    public void load() {
        this.reset();
        JadxArgsValidator.validate(this);
        LOG.info("loading ...");
        this.loadPlugins(this.args);
        this.loadInputFiles();
        this.root = new RootNode(this.args);
        this.root.loadClasses(this.loadedInputs);
        this.root.initClassPath();
        this.root.loadResources(this.getResources());
        this.root.runPreDecompileStage();
        this.root.initPasses();
    }

    private void loadInputFiles() {
        this.loadedInputs.clear();
        List<Path> inputPaths = Utils.collectionMap(this.args.getInputFiles(), File::toPath);
        List<Path> inputFiles = FileUtils.expandDirs(inputPaths);
        long start = System.currentTimeMillis();
        for (JadxInputPlugin inputPlugin : this.pluginManager.getInputPlugins()) {
            ILoadResult loadResult = inputPlugin.loadFiles(inputFiles);
            if (loadResult == null || loadResult.isEmpty()) continue;
            this.loadedInputs.add(loadResult);
        }
        this.loadedInputs.addAll(this.customLoads);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded using {} inputs plugin in {} ms", (Object)this.loadedInputs.size(), (Object)(System.currentTimeMillis() - start));
        }
    }

    public void addCustomLoad(ILoadResult customLoad) {
        this.customLoads.add(customLoad);
    }

    public List<ILoadResult> getCustomLoads() {
        return this.customLoads;
    }

    private void reset() {
        this.root = null;
        this.classes = null;
        this.resources = null;
        this.binaryXmlParser = null;
        this.protoXmlParser = null;
        this.classesMap.clear();
        this.methodsMap.clear();
        this.fieldsMap.clear();
        this.closeInputs();
    }

    private void closeInputs() {
        this.loadedInputs.forEach(load -> {
            try {
                load.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close input", (Throwable)e);
            }
        });
        this.loadedInputs.clear();
    }

    @Override
    public void close() {
        this.reset();
    }

    private void loadPlugins(JadxArgs args) {
        Map<String, String> pluginOptions;
        this.pluginManager.providesSuggestion("java-input", args.isUseDxInput() ? "java-convert" : "java-input");
        this.pluginManager.load();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved plugins: {}", Utils.collectionMap(this.pluginManager.getResolvedPlugins(), p -> p.getPluginInfo().getPluginId()));
        }
        if (!(pluginOptions = args.getPluginOptions()).isEmpty()) {
            LOG.debug("Applying plugin options: {}", pluginOptions);
            for (JadxPluginOptions plugin : this.pluginManager.getPluginsWithOptions()) {
                try {
                    plugin.setOptions(pluginOptions);
                }
                catch (Exception e) {
                    String pluginId = plugin.getPluginInfo().getPluginId();
                    throw new JadxRuntimeException("Failed to apply options for plugin: " + pluginId, e);
                }
            }
        }
    }

    public void registerPlugin(JadxPlugin plugin) {
        this.pluginManager.register(plugin);
    }

    public static String getVersion() {
        return Jadx.getVersion();
    }

    public void save() {
        this.save(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    public void save(int intervalInMillis, ProgressListener listener) {
        ThreadPoolExecutor ex = (ThreadPoolExecutor)this.getSaveExecutor();
        ex.shutdown();
        try {
            long total = ex.getTaskCount();
            while (ex.isTerminating()) {
                long done = ex.getCompletedTaskCount();
                listener.progress(done, total);
                Thread.sleep(intervalInMillis);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Save interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void saveSources() {
        this.save(true, false);
    }

    public void saveResources() {
        this.save(false, true);
    }

    private void save(boolean saveSources, boolean saveResources) {
        ExecutorService ex = this.getSaveExecutor(saveSources, saveResources);
        ex.shutdown();
        try {
            ex.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOG.error("Save interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService getSaveExecutor() {
        return this.getSaveExecutor(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    public List<Runnable> getSaveTasks() {
        return this.getSaveTasks(!this.args.isSkipSources(), !this.args.isSkipResources());
    }

    private ExecutorService getSaveExecutor(boolean saveSources, boolean saveResources) {
        int threadsCount = this.args.getThreadsCount();
        LOG.debug("processing threads count: {}", (Object)threadsCount);
        LOG.info("processing ...");
        ExecutorService executor = Executors.newFixedThreadPool(threadsCount);
        List<Runnable> tasks = this.getSaveTasks(saveSources, saveResources);
        tasks.forEach(executor::execute);
        return executor;
    }

    private List<Runnable> getSaveTasks(boolean saveSources, boolean saveResources) {
        File resOutDir;
        File sourcesOutDir;
        if (this.root == null) {
            throw new JadxRuntimeException("No loaded files");
        }
        if (this.args.isExportAsGradleProject()) {
            ResourceFile androidManifest = this.resources.stream().filter(resourceFile -> resourceFile.getType() == ResourceType.MANIFEST).findFirst().orElseThrow(IllegalStateException::new);
            ResContainer strings = this.resources.stream().filter(resourceFile -> resourceFile.getType() == ResourceType.ARSC).findFirst().orElseThrow(IllegalStateException::new).loadContent().getSubFiles().stream().filter(resContainer -> resContainer.getFileName().contains("strings.xml")).findFirst().orElseThrow(IllegalStateException::new);
            ExportGradleProject export = new ExportGradleProject(this.root, this.args.getOutDir(), androidManifest, strings);
            export.init();
            sourcesOutDir = export.getSrcOutDir();
            resOutDir = export.getResOutDir();
        } else {
            sourcesOutDir = this.args.getOutDirSrc();
            resOutDir = this.args.getOutDirRes();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        if (saveResources) {
            this.appendResourcesSaveTasks(tasks, resOutDir);
        }
        if (saveSources) {
            this.appendSourcesSave(tasks, sourcesOutDir);
        }
        return tasks;
    }

    private void appendResourcesSaveTasks(List<Runnable> tasks, File outDir) {
        if (this.args.isSkipFilesSave()) {
            return;
        }
        Set inputFileNames = this.args.getInputFiles().stream().map(File::getAbsolutePath).collect(Collectors.toSet());
        for (ResourceFile resourceFile : this.getResources()) {
            if (resourceFile.getType() != ResourceType.ARSC && inputFileNames.contains(resourceFile.getOriginalName())) continue;
            tasks.add(new ResourcesSaver(outDir, resourceFile));
        }
    }

    private void appendSourcesSave(List<Runnable> tasks, File outDir) {
        List<List<JavaClass>> batches;
        Predicate<String> classFilter = this.args.getClassFilter();
        List<JavaClass> classes = this.getClasses();
        ArrayList<JavaClass> processQueue = new ArrayList<JavaClass>(classes.size());
        for (JavaClass cls : classes) {
            ClassNode clsNode = cls.getClassNode();
            if (clsNode.contains(AFlag.DONT_GENERATE)) continue;
            if (classFilter != null && !classFilter.test(clsNode.getClassInfo().getFullName())) {
                if (this.args.isIncludeDependencies()) continue;
                clsNode.add(AFlag.DONT_GENERATE);
                continue;
            }
            processQueue.add(cls);
        }
        try {
            batches = this.decompileScheduler.buildBatches(processQueue);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Decompilation batches build failed", e);
        }
        for (List<JavaClass> decompileBatch : batches) {
            tasks.add(() -> {
                for (JavaClass cls : decompileBatch) {
                    try {
                        ICodeInfo code = cls.getCodeInfo();
                        SaveCode.save(outDir, cls.getClassNode(), code);
                    }
                    catch (Exception e) {
                        LOG.error("Error saving class: {}", (Object)cls, (Object)e);
                    }
                }
            });
        }
    }

    public List<JavaClass> getClasses() {
        if (this.root == null) {
            return Collections.emptyList();
        }
        if (this.classes == null) {
            List<ClassNode> classNodeList = this.root.getClasses();
            ArrayList<JavaClass> clsList = new ArrayList<JavaClass>(classNodeList.size());
            for (ClassNode classNode : classNodeList) {
                if (classNode.contains(AFlag.DONT_GENERATE) || classNode.getClassInfo().isInner()) continue;
                clsList.add(this.convertClassNode(classNode));
            }
            this.classes = Collections.unmodifiableList(clsList);
        }
        return this.classes;
    }

    public List<JavaClass> getClassesWithInners() {
        return Utils.collectionMap(this.root.getClasses(), this::convertClassNode);
    }

    public List<ResourceFile> getResources() {
        if (this.resources == null) {
            if (this.root == null) {
                return Collections.emptyList();
            }
            this.resources = new ResourcesLoader(this).load();
        }
        return this.resources;
    }

    public List<JavaPackage> getPackages() {
        List<JavaClass> classList = this.getClasses();
        if (classList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, List> map = new HashMap<String, List>();
        for (JavaClass javaClass : classList) {
            String string = javaClass.getPackage();
            List clsList = map.computeIfAbsent(string, k -> new ArrayList());
            clsList.add(javaClass);
        }
        ArrayList<JavaPackage> packages = new ArrayList<JavaPackage>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            packages.add(new JavaPackage((String)entry.getKey(), (List)entry.getValue()));
        }
        Collections.sort(packages);
        for (JavaPackage javaPackage : packages) {
            javaPackage.getClasses().sort(Comparator.comparing(JavaClass::getName, String.CASE_INSENSITIVE_ORDER));
        }
        return Collections.unmodifiableList(packages);
    }

    public int getErrorsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getErrorCount();
    }

    public int getWarnsCount() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getErrorsCounter().getWarnsCount();
    }

    public void printErrorsReport() {
        if (this.root == null) {
            return;
        }
        this.root.getClsp().printMissingClasses();
        this.root.getErrorsCounter().printReport();
    }

    @ApiStatus.Internal
    public RootNode getRoot() {
        return this.root;
    }

    synchronized BinaryXMLParser getBinaryXmlParser() {
        if (this.binaryXmlParser == null) {
            this.binaryXmlParser = new BinaryXMLParser(this.root);
        }
        return this.binaryXmlParser;
    }

    synchronized ProtoXMLParser getProtoXmlParser() {
        if (this.protoXmlParser == null) {
            this.protoXmlParser = new ProtoXMLParser(this.root);
        }
        return this.protoXmlParser;
    }

    private void loadJavaClass(JavaClass javaClass) {
        javaClass.getMethods().forEach(mth -> this.methodsMap.put(mth.getMethodNode(), (JavaMethod)mth));
        javaClass.getFields().forEach(fld -> this.fieldsMap.put(fld.getFieldNode(), (JavaField)fld));
        for (JavaClass innerCls : javaClass.getInnerClasses()) {
            this.classesMap.put(innerCls.getClassNode(), innerCls);
            this.loadJavaClass(innerCls);
        }
        for (JavaClass inlinedCls : javaClass.getInlinedClasses()) {
            this.classesMap.put(inlinedCls.getClassNode(), inlinedCls);
            this.loadJavaClass(inlinedCls);
        }
    }

    JavaClass convertClassNode(ClassNode cls) {
        return this.classesMap.compute(cls, (node, prevJavaCls) -> {
            if (prevJavaCls != null && prevJavaCls.getClassNode() == cls) {
                return prevJavaCls;
            }
            if (cls.isInner()) {
                return new JavaClass(cls, this.convertClassNode(cls.getParentClass()));
            }
            return new JavaClass(cls, this);
        });
    }

    @Nullable(value="For not generated classes")
    @ApiStatus.Internal
    public @Nullable(value="For not generated classes") JavaClass getJavaClassByNode(ClassNode cls) {
        JavaClass javaClass = this.classesMap.get(cls);
        if (javaClass != null && javaClass.getClassNode() == cls) {
            return javaClass;
        }
        ClassNode parentClass = cls.getTopParentClass();
        if (parentClass.contains(AFlag.DONT_GENERATE)) {
            return null;
        }
        JavaClass parentJavaClass = this.classesMap.get(parentClass);
        if (parentJavaClass == null) {
            this.getClasses();
            parentJavaClass = this.classesMap.get(parentClass);
        }
        if (parentJavaClass != null) {
            this.loadJavaClass(parentJavaClass);
            javaClass = this.classesMap.get(cls);
            if (javaClass != null) {
                return javaClass;
            }
        }
        if (cls.hasNotGeneratedParent()) {
            return null;
        }
        throw new JadxRuntimeException("JavaClass not found by ClassNode: " + cls);
    }

    @ApiStatus.Internal
    @Nullable
    public JavaMethod getJavaMethodByNode(MethodNode mth) {
        JavaMethod javaMethod = this.methodsMap.get(mth);
        if (javaMethod != null && javaMethod.getMethodNode() == mth) {
            return javaMethod;
        }
        if (mth.contains(AFlag.DONT_GENERATE)) {
            return null;
        }
        ClassNode parentClass = mth.getParentClass();
        ClassNode codeCls = this.getCodeParentClass(parentClass);
        JavaClass javaClass = this.getJavaClassByNode(codeCls);
        if (javaClass == null) {
            return null;
        }
        this.loadJavaClass(javaClass);
        javaMethod = this.methodsMap.get(mth);
        if (javaMethod != null) {
            return javaMethod;
        }
        if (parentClass.hasNotGeneratedParent()) {
            return null;
        }
        throw new JadxRuntimeException("JavaMethod not found by MethodNode: " + mth);
    }

    private ClassNode getCodeParentClass(ClassNode cls) {
        InlinedAttr inlinedAttr = cls.get(AType.INLINED);
        ClassNode codeCls = inlinedAttr != null ? inlinedAttr.getInlineCls().getTopParentClass() : cls.getTopParentClass();
        if (codeCls == cls) {
            return codeCls;
        }
        return this.getCodeParentClass(codeCls);
    }

    @ApiStatus.Internal
    @Nullable
    public JavaField getJavaFieldByNode(FieldNode fld) {
        JavaField javaField = this.fieldsMap.get(fld);
        if (javaField != null && javaField.getFieldNode() == fld) {
            return javaField;
        }
        JavaClass javaClass = this.getJavaClassByNode(fld.getParentClass().getTopParentClass());
        if (javaClass == null) {
            return null;
        }
        this.loadJavaClass(javaClass);
        javaField = this.fieldsMap.get(fld);
        if (javaField != null) {
            return javaField;
        }
        if (fld.getParentClass().hasNotGeneratedParent()) {
            return null;
        }
        throw new JadxRuntimeException("JavaField not found by FieldNode: " + fld);
    }

    @Nullable
    public JavaClass searchJavaClassByOrigFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().map(this::getJavaClassByNode).orElse(null);
    }

    @Nullable
    public ClassNode searchClassNodeByOrigFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().orElse(null);
    }

    @Nullable
    public JavaClass searchJavaClassOrItsParentByOrigFullName(String fullName) {
        ClassNode node = this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getFullName().equals(fullName)).findFirst().orElse(null);
        if (node != null) {
            if (node.contains(AFlag.DONT_GENERATE)) {
                return this.getJavaClassByNode(node.getTopParentClass());
            }
            return this.getJavaClassByNode(node);
        }
        return null;
    }

    @Nullable
    public JavaClass searchJavaClassByAliasFullName(String fullName) {
        return this.getRoot().getClasses().stream().filter(cls -> cls.getClassInfo().getAliasFullName().equals(fullName)).findFirst().map(this::getJavaClassByNode).orElse(null);
    }

    @Nullable
    public JavaNode getJavaNodeByRef(ICodeNodeRef ann) {
        return this.getJavaNodeByCodeAnnotation(null, ann);
    }

    @Nullable
    public JavaNode getJavaNodeByCodeAnnotation(@Nullable ICodeInfo codeInfo, @Nullable ICodeAnnotation ann) {
        if (ann == null) {
            return null;
        }
        switch (ann.getAnnType()) {
            case CLASS: {
                return this.convertClassNode((ClassNode)ann);
            }
            case METHOD: {
                return this.getJavaMethodByNode((MethodNode)ann);
            }
            case FIELD: {
                return this.getJavaFieldByNode((FieldNode)ann);
            }
            case DECLARATION: {
                return this.getJavaNodeByCodeAnnotation(codeInfo, ((NodeDeclareRef)ann).getNode());
            }
            case VAR: {
                return this.resolveVarNode((VarNode)ann);
            }
            case VAR_REF: {
                return this.resolveVarRef(codeInfo, (VarRef)ann);
            }
            case OFFSET: {
                return null;
            }
        }
        throw new JadxRuntimeException("Unknown annotation type: " + (Object)((Object)ann.getAnnType()) + ", class: " + ann.getClass());
    }

    @Nullable
    private JavaVariable resolveVarNode(VarNode varNode) {
        MethodNode mthNode = varNode.getMth();
        JavaMethod mth = this.getJavaMethodByNode(mthNode);
        if (mth == null) {
            return null;
        }
        return new JavaVariable(mth, varNode);
    }

    @Nullable
    private JavaVariable resolveVarRef(ICodeInfo codeInfo, VarRef varRef) {
        if (codeInfo == null) {
            throw new JadxRuntimeException("Missing code info for resolve VarRef: " + varRef);
        }
        ICodeAnnotation varNodeAnn = codeInfo.getCodeMetadata().getAt(varRef.getRefPos());
        if (varNodeAnn == null) {
            return null;
        }
        return (JavaVariable)this.getJavaNodeByCodeAnnotation(codeInfo, varNodeAnn);
    }

    List<JavaNode> convertNodes(Collection<? extends ICodeNodeRef> nodesList) {
        return nodesList.stream().map(this::getJavaNodeByRef).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public JavaNode getJavaNodeAtPosition(ICodeInfo codeInfo, int pos) {
        ICodeAnnotation ann = codeInfo.getCodeMetadata().getAt(pos);
        return this.getJavaNodeByCodeAnnotation(codeInfo, ann);
    }

    @Nullable
    public JavaNode getClosestJavaNode(ICodeInfo codeInfo, int pos) {
        ICodeAnnotation ann = codeInfo.getCodeMetadata().getClosestUp(pos);
        return this.getJavaNodeByCodeAnnotation(codeInfo, ann);
    }

    @Nullable
    public JavaNode getEnclosingNode(ICodeInfo codeInfo, int pos) {
        ICodeNodeRef obj = codeInfo.getCodeMetadata().getNodeAt(pos);
        if (obj == null) {
            return null;
        }
        return this.getJavaNodeByRef(obj);
    }

    public void reloadCodeData() {
        this.root.notifyCodeDataListeners();
    }

    public JadxArgs getArgs() {
        return this.args;
    }

    public JadxPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public IDecompileScheduler getDecompileScheduler() {
        return this.decompileScheduler;
    }

    public String toString() {
        return "jadx decompiler " + JadxDecompiler.getVersion();
    }

    public static interface ProgressListener {
        public void progress(long var1, long var3);
    }
}

