/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.api.ICodeInfo;
import jadx.api.JadxArgs;
import jadx.core.Jadx;
import jadx.core.codegen.CodeGen;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.LoadStage;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessClass {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessClass.class);
    private final List<IDexTreeVisitor> passes;

    public ProcessClass(JadxArgs args) {
        this.passes = Jadx.getPassesList(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ICodeInfo process(ClassNode cls, boolean codegen) {
        if (!codegen && cls.getState() == ProcessState.PROCESS_COMPLETE) {
            return null;
        }
        ClassInfo classInfo = cls.getClassInfo();
        synchronized (classInfo) {
            try {
                if (cls.contains(AFlag.CLASS_DEEP_RELOAD)) {
                    cls.remove(AFlag.CLASS_DEEP_RELOAD);
                    cls.deepUnload();
                    cls.add(AFlag.CLASS_UNLOADED);
                }
                if (cls.contains(AFlag.CLASS_UNLOADED)) {
                    cls.root().runPreDecompileStageForClass(cls);
                    cls.remove(AFlag.CLASS_UNLOADED);
                }
                if (cls.getState() == ProcessState.GENERATED_AND_UNLOADED) {
                    cls.setState(ProcessState.NOT_LOADED);
                }
                if (codegen) {
                    cls.setLoadStage(LoadStage.CODEGEN_STAGE);
                    if (cls.contains(AFlag.RELOAD_AT_CODEGEN_STAGE)) {
                        cls.remove(AFlag.RELOAD_AT_CODEGEN_STAGE);
                        cls.unload();
                    }
                } else {
                    cls.setLoadStage(LoadStage.PROCESS_STAGE);
                }
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                }
                if (cls.getState() == ProcessState.LOADED) {
                    cls.setState(ProcessState.PROCESS_STARTED);
                    for (IDexTreeVisitor visitor : this.passes) {
                        DepthTraversal.visit(visitor, cls);
                    }
                    cls.setState(ProcessState.PROCESS_COMPLETE);
                }
                if (codegen) {
                    ICodeInfo code = CodeGen.generate(cls);
                    if (!cls.contains(AFlag.DONT_UNLOAD_CLASS)) {
                        cls.unload();
                        cls.setState(ProcessState.GENERATED_AND_UNLOADED);
                    }
                    return code;
                }
                return null;
            }
            catch (Throwable e) {
                if (codegen) {
                    throw e;
                }
                cls.addError("Class process error: " + e.getClass().getSimpleName(), e);
                return null;
            }
        }
    }

    @NotNull
    public ICodeInfo generateCode(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            return this.generateCode(topParentClass);
        }
        try {
            ICodeInfo code;
            for (ClassNode depCls : cls.getDependencies()) {
                this.process(depCls, false);
            }
            if (!cls.getCodegenDeps().isEmpty()) {
                this.process(cls, false);
                for (ClassNode codegenDep : cls.getCodegenDeps()) {
                    this.process(codegenDep, false);
                }
            }
            if ((code = this.process(cls, true)) == null) {
                throw new JadxRuntimeException("Codegen failed");
            }
            return code;
        }
        catch (Throwable e) {
            throw new JadxRuntimeException("Failed to generate code for class: " + cls.getFullName(), e);
        }
    }

    public void initPasses(RootNode root) {
        for (IDexTreeVisitor pass : this.passes) {
            try {
                pass.init(root);
            }
            catch (Exception e) {
                LOG.error("Visitor init failed: {}", (Object)pass.getClass().getSimpleName(), (Object)e);
            }
        }
    }

    public List<IDexTreeVisitor> getPasses() {
        return this.passes;
    }
}

