/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.data.annotations.VarDeclareRef;
import jadx.api.data.annotations.VarRef;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;

public class JavaVariable
implements JavaNode {
    private final JavaMethod mth;
    private final VarRef varRef;

    public JavaVariable(JavaMethod mth, VarRef varRef) {
        this.mth = mth;
        this.varRef = varRef;
    }

    public JavaMethod getMth() {
        return this.mth;
    }

    public int getReg() {
        return this.varRef.getReg();
    }

    public int getSsa() {
        return this.varRef.getSsa();
    }

    @Override
    public String getName() {
        return this.varRef.getName();
    }

    @ApiStatus.Internal
    public VarRef getVarRef() {
        return this.varRef;
    }

    @Override
    public String getFullName() {
        return this.varRef.getType() + " " + this.varRef.getName() + " (r" + this.varRef.getReg() + "v" + this.varRef.getSsa() + ")";
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.mth.getDeclaringClass();
    }

    @Override
    public JavaClass getTopParentClass() {
        return this.mth.getTopParentClass();
    }

    @Override
    public int getDecompiledLine() {
        if (this.varRef instanceof VarDeclareRef) {
            return ((VarDeclareRef)this.varRef).getDecompiledLine();
        }
        return 0;
    }

    @Override
    public int getDefPos() {
        if (this.varRef instanceof VarDeclareRef) {
            return ((VarDeclareRef)this.varRef).getDefPosition();
        }
        return 0;
    }

    @Override
    public List<JavaNode> getUseIn() {
        return Collections.singletonList(this.mth);
    }

    public int hashCode() {
        return this.varRef.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaVariable)) {
            return false;
        }
        return this.varRef.equals(((JavaVariable)o).varRef);
    }
}

