/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.impl;

import jadx.api.CodePosition;
import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxArgs;
import jadx.api.impl.AnnotatedCodeInfo;
import jadx.api.impl.SimpleCodeWriter;
import jadx.core.dex.attributes.ILineAttributeNode;
import jadx.core.utils.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class AnnotatedCodeWriter
extends SimpleCodeWriter
implements ICodeWriter {
    private int line = 1;
    private int offset;
    private Map<CodePosition, Object> annotations = Collections.emptyMap();
    private Map<Integer, Integer> lineMap = Collections.emptyMap();

    public AnnotatedCodeWriter() {
    }

    public AnnotatedCodeWriter(JadxArgs args) {
        super(args);
    }

    @Override
    public boolean isMetadataSupported() {
        return true;
    }

    @Override
    public AnnotatedCodeWriter addMultiLine(String str) {
        if (str.contains(NL)) {
            this.buf.append(str.replace(NL, NL + this.indentStr));
            this.line += StringUtils.countMatches(str, NL);
            this.offset = 0;
        } else {
            this.buf.append(str);
        }
        return this;
    }

    @Override
    public AnnotatedCodeWriter add(String str) {
        this.buf.append(str);
        this.offset += str.length();
        return this;
    }

    @Override
    public AnnotatedCodeWriter add(char c) {
        this.buf.append(c);
        ++this.offset;
        return this;
    }

    @Override
    public ICodeWriter add(ICodeWriter cw) {
        if (!(cw instanceof AnnotatedCodeWriter)) {
            this.buf.append(cw.getCodeStr());
            return this;
        }
        AnnotatedCodeWriter code = (AnnotatedCodeWriter)cw;
        --this.line;
        int startLine = this.line;
        int startPos = this.getLength();
        for (Map.Entry<CodePosition, Object> entry : code.annotations.entrySet()) {
            CodePosition codePos = entry.getKey();
            int newLine = startLine + codePos.getLine();
            int newPos = startPos + codePos.getPos();
            this.attachAnnotation(entry.getValue(), new CodePosition(newLine, codePos.getOffset(), newPos));
        }
        for (Map.Entry<Object, Object> entry : code.lineMap.entrySet()) {
            this.attachSourceLine(this.line + (Integer)entry.getKey(), (Integer)entry.getValue());
        }
        this.line += code.line;
        this.offset = code.offset;
        this.buf.append((CharSequence)code.buf);
        return this;
    }

    @Override
    protected void addLine() {
        this.buf.append(NL);
        ++this.line;
        this.offset = 0;
    }

    @Override
    protected AnnotatedCodeWriter addLineIndent() {
        this.buf.append(this.indentStr);
        this.offset += this.indentStr.length();
        return this;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public void attachDefinition(ILineAttributeNode obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(obj);
        this.attachAnnotation(new DefinitionWrapper(obj), new CodePosition(this.line, this.offset, this.getLength()));
    }

    @Override
    public void attachAnnotation(Object obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(obj, new CodePosition(this.line, this.offset + 1, this.getLength()));
    }

    @Override
    public void attachLineAnnotation(Object obj) {
        if (obj == null) {
            return;
        }
        this.attachAnnotation(obj, new CodePosition(this.line, 0, this.getLength() - this.offset));
    }

    private void attachAnnotation(Object obj, CodePosition pos) {
        if (this.annotations.isEmpty()) {
            this.annotations = new HashMap<CodePosition, Object>();
        }
        this.annotations.put(pos, obj);
    }

    @Override
    public void attachSourceLine(int sourceLine) {
        if (sourceLine == 0) {
            return;
        }
        this.attachSourceLine(this.line, sourceLine);
    }

    private void attachSourceLine(int decompiledLine, int sourceLine) {
        if (this.lineMap.isEmpty()) {
            this.lineMap = new TreeMap<Integer, Integer>();
        }
        this.lineMap.put(decompiledLine, sourceLine);
    }

    @Override
    public ICodeInfo finish() {
        this.removeFirstEmptyLine();
        this.processDefinitionAnnotations();
        String code = this.buf.toString();
        this.buf = null;
        return new AnnotatedCodeInfo(code, this.lineMap, this.annotations);
    }

    @Override
    public Map<CodePosition, Object> getRawAnnotations() {
        return this.annotations;
    }

    private void processDefinitionAnnotations() {
        if (!this.annotations.isEmpty()) {
            this.annotations.entrySet().removeIf(entry -> {
                Object v = entry.getValue();
                if (v instanceof DefinitionWrapper) {
                    ILineAttributeNode l = ((DefinitionWrapper)v).getNode();
                    CodePosition codePos = (CodePosition)entry.getKey();
                    l.setDecompiledLine(codePos.getLine());
                    l.setDefPosition(codePos.getPos());
                    return true;
                }
                return false;
            });
        }
    }

    private static final class DefinitionWrapper {
        private final ILineAttributeNode node;

        private DefinitionWrapper(ILineAttributeNode node) {
            this.node = node;
        }

        public ILineAttributeNode getNode() {
            return this.node;
        }
    }
}

