/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.data.annotations;

import jadx.api.ICodeWriter;
import jadx.api.data.annotations.ICodeRawOffset;
import jadx.core.dex.nodes.InsnNode;
import org.jetbrains.annotations.Nullable;

public class InsnCodeOffset
implements ICodeRawOffset {
    private final int offset;

    public static void attach(ICodeWriter code, InsnNode insn) {
        InsnCodeOffset ann;
        if (insn == null) {
            return;
        }
        if (code.isMetadataSupported() && (ann = InsnCodeOffset.from(insn)) != null) {
            code.attachLineAnnotation(ann);
        }
    }

    public static void attach(ICodeWriter code, int offset) {
        if (offset >= 0 && code.isMetadataSupported()) {
            code.attachLineAnnotation(new InsnCodeOffset(offset));
        }
    }

    @Nullable
    public static InsnCodeOffset from(InsnNode insn) {
        int offset = insn.getOffset();
        if (offset < 0) {
            return null;
        }
        return new InsnCodeOffset(offset);
    }

    public InsnCodeOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return "offset=" + this.offset;
    }
}

