/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocks;

import jadx.api.plugins.utils.Utils;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.TmpEdgeAttr;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.CatchAttr;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.TryCatchBlockAttr;
import jadx.core.dex.visitors.blocks.BlockProcessor;
import jadx.core.dex.visitors.blocks.BlockSplitter;
import jadx.core.dex.visitors.typeinference.TypeCompare;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.ListUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BlockExceptionHandler.class);

    public static boolean process(MethodNode mth) {
        if (mth.isNoExceptionHandlers()) {
            return false;
        }
        BlockProcessor.updateCleanSuccessors(mth);
        BlockProcessor.computeDominanceFrontier(mth);
        BlockExceptionHandler.processCatchAttr(mth);
        BlockExceptionHandler.initExcHandlers(mth);
        List<TryCatchBlockAttr> tryBlocks = BlockExceptionHandler.prepareTryBlocks(mth);
        BlockExceptionHandler.connectExcHandlers(mth, tryBlocks);
        mth.addAttr(AType.TRY_BLOCKS_LIST, tryBlocks);
        mth.getBasicBlocks().forEach(BlockNode::updateCleanSuccessors);
        for (ExceptionHandler eh : mth.getExceptionHandlers()) {
            BlockExceptionHandler.removeMonitorExitFromExcHandler(mth, eh);
        }
        BlockProcessor.removeMarkedBlocks(mth);
        return true;
    }

    private static void connectExcHandlers(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        if (tryBlocks.isEmpty()) {
            return;
        }
        int limit = tryBlocks.size() * 3;
        int count = 0;
        ArrayDeque<TryCatchBlockAttr> queue = new ArrayDeque<TryCatchBlockAttr>(tryBlocks);
        while (!queue.isEmpty()) {
            TryCatchBlockAttr tryBlock = (TryCatchBlockAttr)queue.removeFirst();
            boolean complete = BlockExceptionHandler.wrapBlocksWithTryCatch(mth, tryBlock);
            if (!complete) {
                queue.addLast(tryBlock);
            }
            if (count++ <= limit) continue;
            throw new JadxRuntimeException("Try blocks wrapping queue limit reached! Please report as an issue!");
        }
    }

    private static void processCatchAttr(MethodNode mth) {
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                if (!insn.contains(AType.EXC_CATCH) || insn.canThrowException()) continue;
                insn.remove(AType.EXC_CATCH);
            }
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            CatchAttr commonCatchAttr = BlockExceptionHandler.getCommonCatchAttr(block);
            if (commonCatchAttr == null) continue;
            block.addAttr(commonCatchAttr);
            for (InsnNode insn : block.getInstructions()) {
                if (insn.contains(AFlag.TRY_ENTER)) {
                    block.add(AFlag.TRY_ENTER);
                }
                if (!insn.contains(AFlag.TRY_LEAVE)) continue;
                block.add(AFlag.TRY_LEAVE);
            }
        }
    }

    @Nullable
    private static CatchAttr getCommonCatchAttr(BlockNode block) {
        CatchAttr commonCatchAttr = null;
        for (InsnNode insn : block.getInstructions()) {
            CatchAttr catchAttr = insn.get(AType.EXC_CATCH);
            if (catchAttr == null) continue;
            if (commonCatchAttr == null) {
                commonCatchAttr = catchAttr;
                continue;
            }
            if (commonCatchAttr == catchAttr) continue;
            return null;
        }
        return commonCatchAttr;
    }

    private static void initExcHandlers(MethodNode mth) {
        List<BlockNode> blocks = mth.getBasicBlocks();
        int blocksCount = blocks.size();
        for (int i = 0; i < blocksCount; ++i) {
            ExcHandlerAttr excHandlerAttr;
            BlockNode block = blocks.get(i);
            InsnNode firstInsn = BlockUtils.getFirstInsn(block);
            if (firstInsn == null || (excHandlerAttr = firstInsn.get(AType.EXC_HANDLER)) == null) continue;
            firstInsn.remove(AType.EXC_HANDLER);
            TmpEdgeAttr tmpEdgeAttr = block.get(AType.TMP_EDGE);
            if (tmpEdgeAttr != null) {
                BlockSplitter.removeConnection(tmpEdgeAttr.getBlock(), block);
                block.remove(AType.TMP_EDGE);
            }
            ExceptionHandler excHandler = excHandlerAttr.getHandler();
            if (block.getPredecessors().isEmpty()) {
                excHandler.setHandlerBlock(block);
                block.addAttr(excHandlerAttr);
                excHandler.addBlock(block);
                BlockUtils.collectBlocksDominatedByWithExcHandlers(mth, block, block).forEach(excHandler::addBlock);
            } else {
                BlockNode emptyHandlerBlock = BlockSplitter.startNewBlock(mth, block.getStartOffset());
                emptyHandlerBlock.add(AFlag.SYNTHETIC);
                emptyHandlerBlock.addAttr(excHandlerAttr);
                BlockSplitter.connect(emptyHandlerBlock, block);
                excHandler.setHandlerBlock(emptyHandlerBlock);
                excHandler.addBlock(emptyHandlerBlock);
            }
            BlockExceptionHandler.fixMoveExceptionInsn(block, excHandlerAttr);
        }
    }

    private static List<TryCatchBlockAttr> prepareTryBlocks(MethodNode mth) {
        HashMap<ExceptionHandler, List> blocksByHandler = new HashMap<ExceptionHandler, List>();
        for (BlockNode block : mth.getBasicBlocks()) {
            CatchAttr catchAttr = block.get(AType.EXC_CATCH);
            if (catchAttr == null) continue;
            for (ExceptionHandler eh2 : catchAttr.getHandlers()) {
                blocksByHandler.computeIfAbsent(eh2, c -> new ArrayList()).add(block);
            }
        }
        if (blocksByHandler.isEmpty()) {
            mth.getExceptionHandlers().forEach(eh -> BlockExceptionHandler.removeExcHandler(mth, eh));
        } else {
            blocksByHandler.forEach((eh, blocks) -> {
                if (blocks.isEmpty()) {
                    BlockExceptionHandler.removeExcHandler(mth, eh);
                }
            });
        }
        BlockSplitter.detachMarkedBlocks(mth);
        mth.clearExceptionHandlers();
        if (mth.isNoExceptionHandlers()) {
            return Collections.emptyList();
        }
        blocksByHandler.forEach((eh, blocks) -> blocks.removeAll(eh.getBlocks()));
        ArrayList<TryCatchBlockAttr> tryBlocks = new ArrayList<TryCatchBlockAttr>();
        blocksByHandler.forEach((eh, blocks) -> {
            ArrayList<ExceptionHandler> handlers = new ArrayList<ExceptionHandler>(1);
            handlers.add((ExceptionHandler)eh);
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), (List<ExceptionHandler>)handlers, (List<BlockNode>)blocks));
        });
        if (tryBlocks.size() > 1) {
            boolean restart;
            while (restart = BlockExceptionHandler.combineTryCatchBlocks(tryBlocks)) {
            }
        }
        BlockExceptionHandler.checkForMultiCatch(mth, tryBlocks);
        BlockExceptionHandler.clearTryBlocks(mth, tryBlocks);
        BlockExceptionHandler.sortHandlers(mth, tryBlocks);
        return tryBlocks;
    }

    private static void clearTryBlocks(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        tryBlocks.forEach(tc -> tc.getBlocks().removeIf(b -> b.contains(AFlag.REMOVE)));
        tryBlocks.removeIf(tb -> tb.getBlocks().isEmpty() || tb.getHandlers().isEmpty());
        mth.clearExceptionHandlers();
        BlockSplitter.detachMarkedBlocks(mth);
    }

    private static boolean combineTryCatchBlocks(List<TryCatchBlockAttr> tryBlocks) {
        for (TryCatchBlockAttr outerTryBlock : tryBlocks) {
            for (TryCatchBlockAttr innerTryBlock : tryBlocks) {
                if (outerTryBlock == innerTryBlock || innerTryBlock.getOuterTryBlock() != null || !BlockExceptionHandler.checkTryCatchRelation(tryBlocks, outerTryBlock, innerTryBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkTryCatchRelation(List<TryCatchBlockAttr> tryBlocks, TryCatchBlockAttr outerTryBlock, TryCatchBlockAttr innerTryBlock) {
        boolean makeInner;
        if (outerTryBlock.getBlocks().equals(innerTryBlock.getBlocks())) {
            List handlers = Utils.concatDistinct(outerTryBlock.getHandlers(), innerTryBlock.getHandlers());
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), handlers, outerTryBlock.getBlocks()));
            tryBlocks.remove(outerTryBlock);
            tryBlocks.remove(innerTryBlock);
            return true;
        }
        Set handlerBlocks = innerTryBlock.getHandlers().stream().flatMap(eh -> eh.getBlocks().stream()).collect(Collectors.toSet());
        boolean catchInHandler = handlerBlocks.stream().anyMatch(BlockExceptionHandler.isHandlersIntersects(outerTryBlock));
        boolean catchInTry = innerTryBlock.getBlocks().stream().anyMatch(BlockExceptionHandler.isHandlersIntersects(outerTryBlock));
        boolean blocksOutsideHandler = outerTryBlock.getBlocks().stream().anyMatch(b -> !handlerBlocks.contains(b));
        boolean bl = makeInner = catchInHandler && (catchInTry || blocksOutsideHandler);
        if (makeInner && innerTryBlock.isAllHandler()) {
            outerTryBlock.setBlocks(Utils.concatDistinct(outerTryBlock.getBlocks(), innerTryBlock.getBlocks()));
            innerTryBlock.clear();
            return false;
        }
        if (makeInner) {
            List mergedBlocks = Utils.concatDistinct(outerTryBlock.getBlocks(), innerTryBlock.getBlocks());
            innerTryBlock.getHandlers().removeAll(outerTryBlock.getHandlers());
            innerTryBlock.setOuterTryBlock(outerTryBlock);
            outerTryBlock.addInnerTryBlock(innerTryBlock);
            outerTryBlock.setBlocks(mergedBlocks);
            return false;
        }
        if (innerTryBlock.getHandlers().containsAll(outerTryBlock.getHandlers())) {
            List mergedBlocks = Utils.concatDistinct(outerTryBlock.getBlocks(), innerTryBlock.getBlocks());
            List handlers = Utils.concatDistinct(outerTryBlock.getHandlers(), innerTryBlock.getHandlers());
            tryBlocks.add(new TryCatchBlockAttr(tryBlocks.size(), handlers, mergedBlocks));
            tryBlocks.remove(outerTryBlock);
            tryBlocks.remove(innerTryBlock);
            return true;
        }
        return false;
    }

    @NotNull
    private static Predicate<BlockNode> isHandlersIntersects(TryCatchBlockAttr outerTryBlock) {
        return block -> {
            CatchAttr catchAttr = block.get(AType.EXC_CATCH);
            return catchAttr != null && Objects.equals(catchAttr.getHandlers(), outerTryBlock.getHandlers());
        };
    }

    private static void removeExcHandler(MethodNode mth, ExceptionHandler excHandler) {
        excHandler.markForRemove();
        BlockSplitter.removeConnection(mth.getEnterBlock(), excHandler.getHandlerBlock());
    }

    private static boolean wrapBlocksWithTryCatch(MethodNode mth, TryCatchBlockAttr tryCatchBlock) {
        BlockNode bottomSplitterBlock;
        List<BlockNode> blocks = tryCatchBlock.getBlocks();
        BlockNode top = BlockExceptionHandler.searchTopBlock(mth, blocks);
        if (top.getPredecessors().isEmpty() && top != mth.getEnterBlock()) {
            return false;
        }
        BlockNode bottom = BlockExceptionHandler.searchBottomBlock(mth, blocks);
        BlockNode topSplitterBlock = BlockExceptionHandler.getTopSplitterBlock(mth, top);
        topSplitterBlock.add(AFlag.EXC_TOP_SPLITTER);
        topSplitterBlock.add(AFlag.SYNTHETIC);
        int totalHandlerBlocks = tryCatchBlock.getHandlers().stream().mapToInt(eh -> eh.getBlocks().size()).sum();
        if (bottom == null || totalHandlerBlocks == 0) {
            bottomSplitterBlock = null;
        } else {
            BlockNode existBottomSplitter = BlockUtils.getBlockWithFlag(bottom.getSuccessors(), AFlag.EXC_BOTTOM_SPLITTER);
            bottomSplitterBlock = existBottomSplitter != null ? existBottomSplitter : BlockSplitter.startNewBlock(mth, -1);
            bottomSplitterBlock.add(AFlag.EXC_BOTTOM_SPLITTER);
            bottomSplitterBlock.add(AFlag.SYNTHETIC);
            BlockSplitter.connect(bottom, bottomSplitterBlock);
        }
        BlockExceptionHandler.connectSplittersAndHandlers(tryCatchBlock, topSplitterBlock, bottomSplitterBlock);
        for (BlockNode block : blocks) {
            TryCatchBlockAttr currentTCBAttr = block.get(AType.TRY_BLOCK);
            if (currentTCBAttr != null && !currentTCBAttr.getInnerTryBlocks().contains(tryCatchBlock)) continue;
            block.addAttr(tryCatchBlock);
        }
        tryCatchBlock.setTopSplitter(topSplitterBlock);
        topSplitterBlock.updateCleanSuccessors();
        if (bottomSplitterBlock != null) {
            bottomSplitterBlock.updateCleanSuccessors();
        }
        return true;
    }

    private static BlockNode getTopSplitterBlock(MethodNode mth, BlockNode top) {
        BlockNode otherTopSplitter;
        if (top == mth.getEnterBlock()) {
            BlockNode fixedTop = mth.getEnterBlock().getSuccessors().get(0);
            return BlockSplitter.blockSplitTop(mth, fixedTop);
        }
        BlockNode existPredTopSplitter = BlockUtils.getBlockWithFlag(top.getPredecessors(), AFlag.EXC_TOP_SPLITTER);
        if (existPredTopSplitter != null) {
            return existPredTopSplitter;
        }
        if (top.getCleanSuccessors().size() == 1 && top.getInstructions().isEmpty() && (otherTopSplitter = BlockUtils.getBlockWithFlag(top.getCleanSuccessors(), AFlag.EXC_TOP_SPLITTER)) != null && otherTopSplitter.getPredecessors().size() == 1) {
            return otherTopSplitter;
        }
        return BlockSplitter.blockSplitTop(mth, top);
    }

    private static BlockNode searchTopBlock(MethodNode mth, List<BlockNode> blocks) {
        BlockNode top = BlockUtils.getTopBlock(blocks);
        if (top != null) {
            return top;
        }
        BlockNode topDom = BlockUtils.getCommonDominator(mth, blocks);
        if (topDom != null) {
            return topDom;
        }
        throw new JadxRuntimeException("Failed to find top block for try-catch from: " + blocks);
    }

    @Nullable
    private static BlockNode searchBottomBlock(MethodNode mth, List<BlockNode> blocks) {
        BlockNode bottom = BlockUtils.getBottomBlock(blocks);
        if (bottom != null) {
            return bottom;
        }
        BlockNode pathCross = BlockUtils.getPathCross(mth, blocks);
        if (pathCross == null) {
            return null;
        }
        ArrayList<BlockNode> preds = new ArrayList<BlockNode>(pathCross.getPredecessors());
        preds.removeAll(blocks);
        List outsidePredecessors = preds.stream().filter(p -> !BlockUtils.atLeastOnePathExists(blocks, p)).collect(Collectors.toList());
        if (outsidePredecessors.isEmpty()) {
            return pathCross;
        }
        BlockNode splitCross = BlockSplitter.blockSplitTop(mth, pathCross);
        splitCross.add(AFlag.SYNTHETIC);
        for (BlockNode outsidePredecessor : outsidePredecessors) {
            BlockSplitter.replaceConnection(outsidePredecessor, splitCross, pathCross);
        }
        return splitCross;
    }

    private static void connectSplittersAndHandlers(TryCatchBlockAttr tryCatchBlock, BlockNode topSplitterBlock, @Nullable BlockNode bottomSplitterBlock) {
        for (ExceptionHandler handler : tryCatchBlock.getHandlers()) {
            BlockNode handlerBlock = handler.getHandlerBlock();
            BlockSplitter.connect(topSplitterBlock, handlerBlock);
            if (bottomSplitterBlock == null) continue;
            BlockSplitter.connect(bottomSplitterBlock, handlerBlock);
        }
        TryCatchBlockAttr outerTryBlock = tryCatchBlock.getOuterTryBlock();
        if (outerTryBlock != null) {
            BlockExceptionHandler.connectSplittersAndHandlers(outerTryBlock, topSplitterBlock, bottomSplitterBlock);
        }
    }

    private static void fixMoveExceptionInsn(BlockNode block, ExcHandlerAttr excHandlerAttr) {
        ExceptionHandler excHandler = excHandlerAttr.getHandler();
        ArgType argType = excHandler.getArgType();
        InsnNode me = BlockUtils.getLastInsn(block);
        if (me != null && me.getType() == InsnType.MOVE_EXCEPTION) {
            RegisterArg resArg = InsnArg.reg(me.getResult().getRegNum(), argType);
            resArg.copyAttributesFrom(me);
            me.setResult(resArg);
            me.add(AFlag.DONT_INLINE);
            resArg.add(AFlag.CUSTOM_DECLARE);
            excHandler.setArg(resArg);
            me.addAttr(excHandlerAttr);
            return;
        }
        excHandler.setArg(new NamedArg("unused", argType));
    }

    private static void removeMonitorExitFromExcHandler(MethodNode mth, ExceptionHandler excHandler) {
        for (BlockNode excBlock : excHandler.getBlocks()) {
            InsnRemover remover = new InsnRemover(mth, excBlock);
            for (InsnNode insn : excBlock.getInstructions()) {
                if (insn.getType() == InsnType.MONITOR_ENTER) break;
                if (insn.getType() != InsnType.MONITOR_EXIT) continue;
                remover.addAndUnbind(insn);
            }
            remover.perform();
        }
    }

    private static void checkForMultiCatch(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        boolean merged = false;
        for (TryCatchBlockAttr tryBlock : tryBlocks) {
            if (!BlockExceptionHandler.mergeMultiCatch(mth, tryBlock)) continue;
            merged = true;
        }
        if (merged) {
            BlockSplitter.detachMarkedBlocks(mth);
            mth.clearExceptionHandlers();
        }
    }

    private static boolean mergeMultiCatch(MethodNode mth, TryCatchBlockAttr tryCatch) {
        if (tryCatch.getHandlers().size() < 2) {
            return false;
        }
        for (ExceptionHandler handler2 : tryCatch.getHandlers()) {
            if (handler2.getBlocks().size() != 1) {
                return false;
            }
            BlockNode block = handler2.getHandlerBlock();
            if (block.getInstructions().size() == 1 && BlockUtils.checkLastInsnType(block, InsnType.MOVE_EXCEPTION)) continue;
            return false;
        }
        List<BlockNode> handlerBlocks = ListUtils.map(tryCatch.getHandlers(), ExceptionHandler::getHandlerBlock);
        List successorBlocks = handlerBlocks.stream().flatMap(h -> h.getSuccessors().stream()).distinct().collect(Collectors.toList());
        if (successorBlocks.size() != 1) {
            return false;
        }
        BlockNode successorBlock = (BlockNode)successorBlocks.get(0);
        if (!ListUtils.unorderedEquals(successorBlock.getPredecessors(), handlerBlocks)) {
            return false;
        }
        List regs = tryCatch.getHandlers().stream().map(h -> Objects.requireNonNull(BlockUtils.getLastInsn(h.getHandlerBlock())).getResult()).distinct().collect(Collectors.toList());
        if (regs.size() != 1) {
            return false;
        }
        ExceptionHandler resultHandler = tryCatch.getHandlers().get(0);
        tryCatch.getHandlers().removeIf(handler -> {
            if (handler == resultHandler) {
                return false;
            }
            resultHandler.addCatchTypes(handler.getCatchTypes());
            handler.markForRemove();
            return true;
        });
        return true;
    }

    private static void sortHandlers(MethodNode mth, List<TryCatchBlockAttr> tryBlocks) {
        TypeCompare typeCompare = mth.root().getTypeCompare();
        Comparator<ArgType> comparator = typeCompare.getReversedComparator();
        for (TryCatchBlockAttr tryBlock : tryBlocks) {
            for (ExceptionHandler handler : tryBlock.getHandlers()) {
                handler.getCatchTypes().sort((first, second) -> BlockExceptionHandler.compareByTypeAndName(comparator, first, second));
            }
            tryBlock.getHandlers().sort((first, second) -> {
                if (first.equals(second)) {
                    throw new JadxRuntimeException("Same handlers in try block: " + tryBlock);
                }
                if (first.isCatchAll()) {
                    return 1;
                }
                if (second.isCatchAll()) {
                    return -1;
                }
                return BlockExceptionHandler.compareByTypeAndName(comparator, ListUtils.first(first.getCatchTypes()), ListUtils.first(second.getCatchTypes()));
            });
        }
    }

    private static int compareByTypeAndName(Comparator<ArgType> comparator, ClassInfo first, ClassInfo second) {
        int r = comparator.compare(first.getType(), second.getType());
        if (r == -2) {
            return first.compareTo(second);
        }
        return r;
    }

    private static /* synthetic */ void lambda$prepareTryBlocks$6(TryCatchBlockAttr tryBlock) {
        LOG.debug(" {}", (Object)tryBlock);
    }

    private static /* synthetic */ void lambda$prepareTryBlocks$1(ExceptionHandler eh, List blocks) {
        LOG.debug(" {}, throw blocks: {}, handler blocks: {}", new Object[]{eh, blocks, eh.getBlocks()});
    }
}

