/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.annotations.AnnotationVisibility;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.types.AnnotationsAttr;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ConstClassNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.FillArrayInsn;
import jadx.core.dex.instructions.FilledNewArrayNode;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.NewArrayNode;
import jadx.core.dex.instructions.SwitchInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.NamedArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.instructions.mods.TernaryInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.IMethodDetails;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.conditions.IfCondition;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.regions.variables.ProcessVariables;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JadxVisitor(name="ModVisitor", desc="Modify method instructions", runBefore={CodeShrinkVisitor.class, ProcessVariables.class})
public class ModVisitor
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(ModVisitor.class);
    private static final long DOUBLE_TO_BITS = Double.doubleToLongBits(1.0);
    private static final long FLOAT_TO_BITS = Float.floatToIntBits(1.0f);

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        this.replaceConstInAnnotations(cls);
        return true;
    }

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        InsnRemover remover = new InsnRemover(mth);
        ModVisitor.replaceStep(mth, remover);
        ModVisitor.removeStep(mth, remover);
        ModVisitor.iterativeRemoveStep(mth);
    }

    private static void replaceStep(MethodNode mth, InsnRemover remover) {
        ClassNode parentClass = mth.getParentClass();
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            List<InsnNode> insnsList = block.getInstructions();
            int size = insnsList.size();
            block12: for (int i = 0; i < size; ++i) {
                InsnNode insn = insnsList.get(i);
                switch (insn.getType()) {
                    case CONSTRUCTOR: {
                        ModVisitor.processAnonymousConstructor(mth, (ConstructorInsn)insn);
                        continue block12;
                    }
                    case CONST: 
                    case CONST_STR: 
                    case CONST_CLASS: {
                        ModVisitor.replaceConst(mth, parentClass, block, i, insn);
                        continue block12;
                    }
                    case SWITCH: {
                        ModVisitor.replaceConstKeys(parentClass, (SwitchInsn)insn);
                        continue block12;
                    }
                    case NEW_ARRAY: {
                        FillArrayInsn fillArrInsn;
                        NewArrayNode newArrInsn = (NewArrayNode)insn;
                        InsnNode nextInsn = ModVisitor.getFirstUseSkipMove(insn.getResult());
                        if (nextInsn == null || nextInsn.getType() != InsnType.FILL_ARRAY || !ModVisitor.checkArrSizes(mth, newArrInsn, fillArrInsn = (FillArrayInsn)nextInsn)) continue block12;
                        InsnNode filledArr = ModVisitor.makeFilledArrayInsn(mth, newArrInsn, fillArrInsn);
                        BlockUtils.replaceInsn(mth, block, i, filledArr);
                        remover.addAndUnbind(nextInsn);
                        continue block12;
                    }
                    case MOVE_EXCEPTION: {
                        ModVisitor.processMoveException(mth, block, insn, remover);
                        continue block12;
                    }
                    case ARITH: {
                        ModVisitor.processArith(mth, parentClass, (ArithNode)insn);
                        continue block12;
                    }
                    case CHECK_CAST: {
                        ModVisitor.removeCheckCast(mth, block, i, (IndexInsnNode)insn);
                        continue block12;
                    }
                    case CAST: {
                        ModVisitor.fixPrimitiveCast(mth, block, i, insn);
                        continue block12;
                    }
                    case IPUT: 
                    case IGET: {
                        ModVisitor.fixFieldUsage(mth, (IndexInsnNode)insn);
                        continue block12;
                    }
                }
            }
            remover.perform();
        }
    }

    private static void fixFieldUsage(MethodNode mth, IndexInsnNode insn) {
        TypeCompareEnum result;
        ArgType instanceType;
        InsnArg instanceArg = insn.getArg(insn.getType() == InsnType.IGET ? 0 : 1);
        if (instanceArg.contains(AFlag.SUPER)) {
            return;
        }
        if (instanceArg.isInsnWrap() && ((InsnWrapArg)instanceArg).getWrapInsn().getType() == InsnType.CAST) {
            return;
        }
        FieldInfo fieldInfo = (FieldInfo)insn.getIndex();
        ArgType clsType = fieldInfo.getDeclClass().getType();
        if (Objects.equals(clsType, instanceType = instanceArg.getType())) {
            return;
        }
        FieldNode fieldNode = mth.root().resolveField(fieldInfo);
        if (fieldNode == null ? (result = mth.root().getTypeCompare().compareTypes(instanceType, clsType)).isEqual() || result == TypeCompareEnum.NARROW_BY_GENERIC && !instanceType.isGenericType() : ModVisitor.isFieldVisibleInMethod(fieldNode, mth)) {
            return;
        }
        IndexInsnNode castInsn = new IndexInsnNode(InsnType.CAST, clsType, 1);
        castInsn.addArg(instanceArg.duplicate());
        castInsn.add(AFlag.SYNTHETIC);
        castInsn.add(AFlag.EXPLICIT_CAST);
        InsnArg castArg = InsnArg.wrapInsnIntoArg(castInsn);
        castArg.setType(clsType);
        insn.replaceArg(instanceArg, castArg);
        InsnRemover.unbindArgUsage(mth, instanceArg);
    }

    private static boolean isFieldVisibleInMethod(FieldNode field, MethodNode mth) {
        ClassNode fieldCls;
        boolean sameScope;
        AccessInfo accessFlags = field.getAccessFlags();
        if (accessFlags.isPublic()) {
            return true;
        }
        ClassNode useCls = mth.getParentClass();
        boolean bl = sameScope = Objects.equals(useCls, fieldCls = field.getParentClass()) && !mth.getAccessFlags().isStatic();
        if (sameScope) {
            return true;
        }
        if (accessFlags.isPrivate()) {
            return false;
        }
        if (Objects.equals(useCls.getClassInfo().getPackage(), fieldCls.getClassInfo().getPackage())) {
            return true;
        }
        if (accessFlags.isPackagePrivate()) {
            return false;
        }
        TypeCompareEnum result = mth.root().getTypeCompare().compareTypes(useCls, fieldCls);
        return result == TypeCompareEnum.NARROW;
    }

    private static void replaceConstKeys(ClassNode parentClass, SwitchInsn insn) {
        int[] keys = insn.getKeys();
        int len = keys.length;
        for (int k = 0; k < len; ++k) {
            FieldNode f = parentClass.getConstField(keys[k]);
            if (f == null) continue;
            insn.modifyKey(k, f);
        }
    }

    private static void fixPrimitiveCast(MethodNode mth, BlockNode block, int i, InsnNode insn) {
        ArgType type;
        InsnArg castArg = insn.getArg(0);
        if (castArg.getType() == ArgType.BOOLEAN && (type = insn.getResult().getType()).isPrimitive()) {
            TernaryInsn ternary = ModVisitor.makeBooleanConvertInsn(insn.getResult(), castArg, type);
            BlockUtils.replaceInsn(mth, block, i, (InsnNode)ternary);
        }
    }

    public static TernaryInsn makeBooleanConvertInsn(RegisterArg result, InsnArg castArg, ArgType type) {
        LiteralArg zero = LiteralArg.make(0L, type);
        long litVal = 1L;
        if (type == ArgType.DOUBLE) {
            litVal = DOUBLE_TO_BITS;
        } else if (type == ArgType.FLOAT) {
            litVal = FLOAT_TO_BITS;
        }
        LiteralArg one = LiteralArg.make(litVal, type);
        IfNode ifNode = new IfNode(IfOp.EQ, -1, castArg, LiteralArg.litTrue());
        IfCondition condition = IfCondition.fromIfNode(ifNode);
        return new TernaryInsn(condition, result, one, zero);
    }

    private void replaceConstInAnnotations(ClassNode cls) {
        if (cls.root().getArgs().isReplaceConsts()) {
            this.replaceConstsInAnnotationForAttrNode(cls, cls);
            cls.getFields().forEach(f -> this.replaceConstsInAnnotationForAttrNode(cls, (AttrNode)f));
            cls.getMethods().forEach(m -> this.replaceConstsInAnnotationForAttrNode(cls, (AttrNode)m));
        }
    }

    private void replaceConstsInAnnotationForAttrNode(ClassNode parentCls, AttrNode attrNode) {
        AnnotationsAttr annotationsList = (AnnotationsAttr)attrNode.get(JadxAttrType.ANNOTATION_LIST);
        if (annotationsList == null) {
            return;
        }
        for (IAnnotation annotation : annotationsList.getAll()) {
            if (annotation.getVisibility() == AnnotationVisibility.SYSTEM) continue;
            for (Map.Entry entry : annotation.getValues().entrySet()) {
                entry.setValue(this.replaceConstValue(parentCls, (EncodedValue)entry.getValue()));
            }
        }
    }

    private EncodedValue replaceConstValue(ClassNode parentCls, EncodedValue encodedValue) {
        if (encodedValue.getType() == EncodedType.ENCODED_ARRAY) {
            List listVal = (List)encodedValue.getValue();
            if (!listVal.isEmpty()) {
                listVal.replaceAll(v -> this.replaceConstValue(parentCls, (EncodedValue)v));
            }
            return new EncodedValue(EncodedType.ENCODED_ARRAY, (Object)listVal);
        }
        FieldNode constField = parentCls.getConstField(encodedValue.getValue());
        if (constField != null) {
            return new EncodedValue(EncodedType.ENCODED_FIELD, (Object)constField.getFieldInfo());
        }
        return encodedValue;
    }

    private static void replaceConst(MethodNode mth, ClassNode parentClass, BlockNode block, int i, InsnNode insn) {
        FieldNode f;
        if (insn.getType() == InsnType.CONST_STR) {
            String s = ((ConstStringNode)insn).getString();
            f = parentClass.getConstField(s);
        } else if (insn.getType() == InsnType.CONST_CLASS) {
            ArgType t = ((ConstClassNode)insn).getClsType();
            f = parentClass.getConstField(t);
        } else {
            f = parentClass.getConstFieldByLiteralArg((LiteralArg)insn.getArg(0));
        }
        if (f != null) {
            IndexInsnNode inode = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
            inode.setResult(insn.getResult());
            BlockUtils.replaceInsn(mth, block, i, (InsnNode)inode);
        }
    }

    private static void processArith(MethodNode mth, ClassNode parentClass, ArithNode arithNode) {
        FieldNode f;
        if (arithNode.getArgsCount() != 2) {
            throw new JadxRuntimeException("Invalid args count in insn: " + arithNode);
        }
        InsnArg litArg = arithNode.getArg(1);
        if (litArg.isLiteral() && (f = parentClass.getConstFieldByLiteralArg((LiteralArg)litArg)) != null) {
            IndexInsnNode fGet = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
            arithNode.replaceArg(litArg, InsnArg.wrapArg(fGet));
        }
    }

    private static boolean checkArrSizes(MethodNode mth, NewArrayNode newArrInsn, FillArrayInsn fillArrInsn) {
        int dataSize = fillArrInsn.getSize();
        InsnArg arrSizeArg = newArrInsn.getArg(0);
        Object value = InsnUtils.getConstValueByArg(mth.root(), arrSizeArg);
        if (value instanceof LiteralArg) {
            long literal = ((LiteralArg)value).getLiteral();
            return dataSize == (int)literal;
        }
        return false;
    }

    private static void removeCheckCast(MethodNode mth, BlockNode block, int i, IndexInsnNode insn) {
        InsnArg castArg = insn.getArg(0);
        ArgType castType = (ArgType)insn.getIndex();
        if (!ArgType.isCastNeeded(mth.root(), castArg.getType(), castType) || ModVisitor.isCastDuplicate(insn)) {
            RegisterArg result = insn.getResult();
            result.setType(castArg.getType());
            InsnNode move = new InsnNode(InsnType.MOVE, 1);
            move.setResult(result);
            move.addArg(castArg);
            BlockUtils.replaceInsn(mth, block, i, move);
        }
    }

    private static boolean isCastDuplicate(IndexInsnNode castInsn) {
        InsnNode assignInsn;
        SSAVar sVar;
        InsnArg arg = castInsn.getArg(0);
        if (arg.isRegister() && (sVar = ((RegisterArg)arg).getSVar()) != null && sVar.getUseCount() == 1 && !sVar.isUsedInPhi() && (assignInsn = sVar.getAssign().getParentInsn()) != null && assignInsn.getType() == InsnType.CHECK_CAST) {
            ArgType assignCastType = (ArgType)((IndexInsnNode)assignInsn).getIndex();
            return assignCastType.equals(castInsn.getIndex());
        }
        return false;
    }

    private static void removeStep(MethodNode mth, InsnRemover remover) {
        for (BlockNode block : mth.getBasicBlocks()) {
            remover.setBlock(block);
            block4: for (InsnNode insn : block.getInstructions()) {
                switch (insn.getType()) {
                    case NOP: 
                    case GOTO: 
                    case NEW_INSTANCE: {
                        remover.addAndUnbind(insn);
                        continue block4;
                    }
                }
                if (!insn.contains(AFlag.REMOVE)) continue;
                remover.addAndUnbind(insn);
            }
            remover.perform();
        }
    }

    private static void iterativeRemoveStep(MethodNode mth) {
        boolean changed;
        do {
            changed = false;
            block1: for (BlockNode block : mth.getBasicBlocks()) {
                for (InsnNode insn : block.getInstructions()) {
                    if (insn.getType() != InsnType.MOVE || !insn.isAttrStorageEmpty() || !ModVisitor.isResultArgNotUsed(insn)) continue;
                    InsnRemover.remove(mth, block, insn);
                    changed = true;
                    continue block1;
                }
            }
        } while (changed);
    }

    private static boolean isResultArgNotUsed(InsnNode insn) {
        RegisterArg result = insn.getResult();
        if (result != null) {
            SSAVar ssaVar = result.getSVar();
            return ssaVar.getUseCount() == 0;
        }
        return false;
    }

    private static void processAnonymousConstructor(MethodNode mth, ConstructorInsn co) {
        IMethodDetails callMthDetails = mth.root().getMethodUtils().getMethodDetails(co);
        if (!(callMthDetails instanceof MethodNode)) {
            return;
        }
        MethodNode callMth = (MethodNode)callMthDetails;
        if (!callMth.contains(AFlag.ANONYMOUS_CONSTRUCTOR) || callMth.contains(AFlag.NO_SKIP_ARGS)) {
            return;
        }
        SkipMethodArgsAttr attr = callMth.get(AType.SKIP_MTH_ARGS);
        if (attr != null) {
            int argsCount = Math.min(callMth.getArgRegs().size(), co.getArgsCount());
            for (int i = 0; i < argsCount; ++i) {
                if (!attr.isSkip(i)) continue;
                ModVisitor.anonymousCallArgMod(co.getArg(i));
            }
        } else {
            co.getArguments().forEach(ModVisitor::anonymousCallArgMod);
        }
    }

    private static void anonymousCallArgMod(InsnArg arg) {
        arg.add(AFlag.DONT_INLINE);
        if (arg.isRegister()) {
            ((RegisterArg)arg).getSVar().getCodeVar().setFinal(true);
        }
    }

    @Nullable
    private static InsnNode getFirstUseSkipMove(RegisterArg arg) {
        SSAVar sVar = arg.getSVar();
        int useCount = sVar.getUseCount();
        if (useCount == 0) {
            return null;
        }
        RegisterArg useArg = sVar.getUseList().get(0);
        InsnNode parentInsn = useArg.getParentInsn();
        if (parentInsn == null) {
            return null;
        }
        if (useCount == 1 && parentInsn.getType() == InsnType.MOVE) {
            return ModVisitor.getFirstUseSkipMove(parentInsn.getResult());
        }
        return parentInsn;
    }

    private static InsnNode makeFilledArrayInsn(MethodNode mth, NewArrayNode newArrayNode, FillArrayInsn insn) {
        ArgType insnArrayType = newArrayNode.getArrayType();
        ArgType insnElementType = insnArrayType.getArrayElement();
        ArgType elType = insn.getElementType();
        if (!elType.isTypeKnown() && insnElementType.isPrimitive() && elType.contains(insnElementType.getPrimitiveType())) {
            elType = insnElementType;
        }
        if (!elType.equals(insnElementType) && !insnArrayType.equals(ArgType.OBJECT)) {
            mth.addWarn("Incorrect type for fill-array insn " + InsnUtils.formatOffset(insn.getOffset()) + ", element type: " + elType + ", insn element type: " + insnElementType);
        }
        if (!elType.isTypeKnown()) {
            LOG.warn("Unknown array element type: {} in mth: {}", (Object)elType, (Object)mth);
            ArgType argType = elType = insnElementType.isTypeKnown() ? insnElementType : elType.selectFirst();
            if (elType == null) {
                throw new JadxRuntimeException("Null array element type");
            }
        }
        List<LiteralArg> list = insn.getLiteralArgs(elType);
        FilledNewArrayNode filledArr = new FilledNewArrayNode(elType, list.size());
        filledArr.setResult(newArrayNode.getResult());
        for (LiteralArg arg : list) {
            FieldNode f = mth.getParentClass().getConstFieldByLiteralArg(arg);
            if (f != null) {
                IndexInsnNode fGet = new IndexInsnNode(InsnType.SGET, f.getFieldInfo(), 0);
                filledArr.addArg(InsnArg.wrapArg(fGet));
                continue;
            }
            filledArr.addArg(arg);
        }
        return filledArr;
    }

    private static void processMoveException(MethodNode mth, BlockNode block, InsnNode insn, InsnRemover remover) {
        SSAVar sVar;
        String name;
        ExcHandlerAttr excHandlerAttr = block.get(AType.EXC_HANDLER);
        if (excHandlerAttr == null) {
            return;
        }
        ExceptionHandler excHandler = excHandlerAttr.getHandler();
        RegisterArg resArg = insn.getResult();
        ArgType type = excHandler.getArgType();
        String string = name = excHandler.isCatchAll() ? "th" : "e";
        if (resArg.getName() == null) {
            resArg.setName(name);
        }
        if ((sVar = insn.getResult().getSVar()).getUseCount() == 0) {
            excHandler.setArg(new NamedArg(name, type));
            remover.addAndUnbind(insn);
        } else if (sVar.isUsedInPhi()) {
            InsnNode moveInsn = new InsnNode(InsnType.MOVE, 1);
            moveInsn.setResult(insn.getResult());
            NamedArg namedArg = new NamedArg(name, type);
            moveInsn.addArg(namedArg);
            excHandler.setArg(namedArg);
            BlockUtils.replaceInsn(mth, block, 0, moveInsn);
        }
        block.copyAttributeFrom(insn, AType.CODE_COMMENTS);
    }
}

