/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.RegDebugInfoAttr;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.PhiInsn;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.CodeVar;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.typeinference.TypeInfo;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSAVar {
    private static final Logger LOG = LoggerFactory.getLogger(SSAVar.class);
    private final int regNum;
    private final int version;
    private RegisterArg assign;
    private final List<RegisterArg> useList = new ArrayList<RegisterArg>(2);
    private List<PhiInsn> usedInPhi = null;
    private final TypeInfo typeInfo = new TypeInfo();
    @Nullable(value="Set in InitCodeVariables pass")
    private @Nullable(value="Set in InitCodeVariables pass") CodeVar codeVar;

    public SSAVar(int regNum, int v, @NotNull RegisterArg assign) {
        this.regNum = regNum;
        this.version = v;
        this.assign = assign;
        assign.setSVar(this);
    }

    public int getRegNum() {
        return this.regNum;
    }

    public int getVersion() {
        return this.version;
    }

    @NotNull
    public RegisterArg getAssign() {
        return this.assign;
    }

    @Nullable
    public InsnNode getAssignInsn() {
        return this.assign.getParentInsn();
    }

    public void setAssign(@NotNull RegisterArg assign) {
        this.assign = assign;
    }

    public List<RegisterArg> getUseList() {
        return this.useList;
    }

    public int getUseCount() {
        return this.useList.size();
    }

    @Nullable
    public ArgType getImmutableType() {
        if (this.isTypeImmutable()) {
            return this.assign.getInitType();
        }
        return null;
    }

    public boolean isTypeImmutable() {
        return this.assign.contains(AFlag.IMMUTABLE_TYPE);
    }

    public void markAsImmutable(ArgType type) {
        this.assign.add(AFlag.IMMUTABLE_TYPE);
        ArgType initType = this.assign.getInitType();
        if (!initType.equals(type)) {
            this.assign.forceSetInitType(type);
        }
    }

    public void setType(ArgType type) {
        ArgType imType = this.getImmutableType();
        if (imType != null && !imType.equals(type)) {
            throw new JadxRuntimeException("Can't change immutable type " + imType + " to " + type + " for " + this);
        }
        this.updateType(type);
    }

    public void forceSetType(ArgType type) {
        this.updateType(type);
    }

    private void updateType(ArgType type) {
        this.typeInfo.setType(type);
        if (this.codeVar != null) {
            this.codeVar.setType(type);
        }
    }

    public void use(RegisterArg arg) {
        if (arg.getSVar() != null) {
            arg.getSVar().removeUse(arg);
        }
        arg.setSVar(this);
        this.useList.add(arg);
    }

    public void removeUse(RegisterArg arg) {
        this.useList.removeIf(registerArg -> registerArg == arg);
    }

    public void addUsedInPhi(PhiInsn phiInsn) {
        if (this.usedInPhi == null) {
            this.usedInPhi = new ArrayList<PhiInsn>(1);
        }
        this.usedInPhi.add(phiInsn);
    }

    public void removeUsedInPhi(PhiInsn phiInsn) {
        if (this.usedInPhi != null) {
            this.usedInPhi.removeIf(insn -> insn == phiInsn);
            if (this.usedInPhi.isEmpty()) {
                this.usedInPhi = null;
            }
        }
    }

    public void updateUsedInPhiList() {
        this.usedInPhi = null;
        for (RegisterArg reg : this.useList) {
            InsnNode parentInsn = reg.getParentInsn();
            if (parentInsn == null || parentInsn.getType() != InsnType.PHI) continue;
            this.addUsedInPhi((PhiInsn)parentInsn);
        }
    }

    @Nullable
    public PhiInsn getOnlyOneUseInPhi() {
        if (this.usedInPhi != null && this.usedInPhi.size() == 1) {
            return this.usedInPhi.get(0);
        }
        return null;
    }

    public List<PhiInsn> getUsedInPhi() {
        if (this.usedInPhi == null) {
            return Collections.emptyList();
        }
        return this.usedInPhi;
    }

    public List<PhiInsn> getPhiList() {
        InsnNode assignInsn = this.getAssign().getParentInsn();
        if (assignInsn != null && assignInsn.getType() == InsnType.PHI) {
            PhiInsn assignPhi = (PhiInsn)assignInsn;
            if (this.usedInPhi == null) {
                return Collections.singletonList(assignPhi);
            }
            ArrayList<PhiInsn> list = new ArrayList<PhiInsn>(1 + this.usedInPhi.size());
            list.add(assignPhi);
            list.addAll(this.usedInPhi);
            return list;
        }
        if (this.usedInPhi == null) {
            return Collections.emptyList();
        }
        return this.usedInPhi;
    }

    public boolean isUsedInPhi() {
        return this.usedInPhi != null && !this.usedInPhi.isEmpty();
    }

    public int getVariableUseCount() {
        int count = this.useList.size();
        if (this.usedInPhi == null) {
            return count;
        }
        for (PhiInsn phiInsn : this.usedInPhi) {
            count += phiInsn.getResult().getSVar().getUseCount();
        }
        return count;
    }

    public void setName(String name) {
        if (name != null) {
            if (this.codeVar == null) {
                throw new JadxRuntimeException("CodeVar not initialized for name set in SSAVar: " + this);
            }
            this.codeVar.setName(name);
        }
    }

    public String getName() {
        if (this.codeVar == null) {
            return null;
        }
        return this.codeVar.getName();
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @NotNull
    public CodeVar getCodeVar() {
        if (this.codeVar == null) {
            throw new JadxRuntimeException("Code variable not set in " + this);
        }
        return this.codeVar;
    }

    public void setCodeVar(@NotNull CodeVar codeVar) {
        this.codeVar = codeVar;
        codeVar.addSsaVar(this);
        ArgType imType = this.getImmutableType();
        if (imType != null) {
            codeVar.setType(imType);
        }
    }

    public void resetTypeAndCodeVar() {
        if (!this.isTypeImmutable()) {
            this.updateType(ArgType.UNKNOWN);
        }
        this.typeInfo.getBounds().clear();
        this.codeVar = null;
    }

    public boolean isCodeVarSet() {
        return this.codeVar != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSAVar)) {
            return false;
        }
        SSAVar ssaVar = (SSAVar)o;
        return this.regNum == ssaVar.regNum && this.version == ssaVar.version;
    }

    public int hashCode() {
        return 31 * this.regNum + this.version;
    }

    public String toShortString() {
        return "r" + this.regNum + 'v' + this.version;
    }

    public String toString() {
        return this.toShortString() + (StringUtils.notEmpty(this.getName()) ? " '" + this.getName() + "' " : "") + ' ' + this.typeInfo.getType();
    }

    public String getDetailedVarInfo(MethodNode mth) {
        HashSet<ArgType> types = new HashSet<ArgType>();
        Set names = Collections.emptySet();
        ArrayList<RegisterArg> useArgs = new ArrayList<RegisterArg>(1 + this.useList.size());
        useArgs.add(this.assign);
        useArgs.addAll(this.useList);
        if (mth.contains(AType.LOCAL_VARS_DEBUG_INFO)) {
            names = new HashSet();
            for (RegisterArg arg : useArgs) {
                RegDebugInfoAttr debugInfoAttr = arg.get(AType.REG_DEBUG_INFO);
                if (debugInfoAttr == null) continue;
                names.add(debugInfoAttr.getName());
                types.add(debugInfoAttr.getRegType());
            }
        }
        for (RegisterArg arg : useArgs) {
            ArgType type;
            ArgType initType = arg.getInitType();
            if (initType.isTypeKnown()) {
                types.add(initType);
            }
            if (!(type = arg.getType()).isTypeKnown()) continue;
            types.add(type);
        }
        StringBuilder sb = new StringBuilder();
        sb.append('r').append(this.regNum).append('v').append(this.version);
        if (!names.isEmpty()) {
            sb.append(", names: ").append(names);
        }
        if (!types.isEmpty()) {
            sb.append(", types: ").append(types);
        }
        return sb.toString();
    }
}

