/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.ICodeWriter;
import jadx.api.JadxDecompiler;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.impl.SimpleCodeInfo;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.Utils;
import jadx.core.utils.android.Res9patchStreamDecoder;
import jadx.core.utils.exceptions.JadxException;
import jadx.core.utils.files.FileUtils;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResProtoParser;
import jadx.core.xmlgen.ResTableParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private final JadxDecompiler jadxRef;

    ResourcesLoader(JadxDecompiler jadxRef) {
        this.jadxRef = jadxRef;
    }

    List<ResourceFile> load() {
        List<File> inputFiles = this.jadxRef.getArgs().getInputFiles();
        ArrayList<ResourceFile> list = new ArrayList<ResourceFile>(inputFiles.size());
        for (File file : inputFiles) {
            this.loadFile(list, file);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public static <T> T decodeStream(ResourceFile rf, ResourceDecoder<T> decoder) throws JadxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf) {
        try {
            return ResourcesLoader.decodeStream(rf, (size, is) -> ResourcesLoader.loadContent(jadxRef, rf, is));
        }
        catch (JadxException e) {
            LOG.error("Decode error", (Throwable)e);
            ICodeWriter cw = jadxRef.getRoot().makeCodeWriter();
            cw.add("Error decode ").add(rf.getType().toString().toLowerCase());
            Utils.appendStackTrace(cw, e.getCause());
            return ResContainer.textResource(rf.getDeobfName(), cw.finish());
        }
    }

    private static ResContainer loadContent(JadxDecompiler jadxRef, ResourceFile rf, InputStream inputStream) throws IOException {
        RootNode root = jadxRef.getRoot();
        switch (rf.getType()) {
            case MANIFEST: 
            case XML: {
                ICodeInfo content = root.isProto() ? jadxRef.getProtoXmlParser().parse(inputStream) : jadxRef.getBinaryXmlParser().parse(inputStream);
                return ResContainer.textResource(rf.getDeobfName(), content);
            }
            case ARSC: {
                if (root.isProto()) {
                    return new ResProtoParser(root).decodeFiles(inputStream);
                }
                return new ResTableParser(root).decodeFiles(inputStream);
            }
            case IMG: {
                return ResourcesLoader.decodeImage(rf, inputStream);
            }
        }
        return ResContainer.resourceFileLink(rf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResContainer decodeImage(ResourceFile rf, InputStream inputStream) {
        String name = rf.getOriginalName();
        if (!name.endsWith(".9.png")) return ResContainer.resourceFileLink(rf);
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Res9patchStreamDecoder decoder = new Res9patchStreamDecoder();
            decoder.decode(inputStream, os);
            ResContainer resContainer = ResContainer.decodedData(rf.getDeobfName(), os.toByteArray());
            return resContainer;
        }
        catch (Exception e) {
            LOG.error("Failed to decode 9-patch png image, path: {}", (Object)name, (Object)e);
        }
        return ResContainer.resourceFileLink(rf);
    }

    private void loadFile(List<ResourceFile> list, File file) {
        if (file == null || file.isDirectory()) {
            return;
        }
        if (FileUtils.isZipFile(file)) {
            ZipSecurity.visitZipEntries((File)file, (zipFile, entry) -> {
                this.addEntry(list, file, (ZipEntry)entry);
                return null;
            });
        } else {
            ResourceType type = ResourceType.getFileType(file.getAbsolutePath());
            list.add(ResourceFile.createResourceFile(this.jadxRef, file, type));
        }
    }

    private void addEntry(List<ResourceFile> list, File zipFile, ZipEntry entry) {
        ResourceType type;
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        ResourceFile rf = ResourceFile.createResourceFile(this.jadxRef, name, type = ResourceType.getFileType(name));
        if (rf != null) {
            rf.setZipRef(new ResourceFile.ZipRef(zipFile, name));
            list.add(rf);
        }
    }

    public static ICodeInfo loadToCodeWriter(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
        FileUtils.copyStream(is, baos);
        return new SimpleCodeInfo(baos.toString("UTF-8"));
    }

    public static interface ResourceDecoder<T> {
        public T decode(long var1, InputStream var3) throws IOException;
    }
}

