/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.usage.UsageInfoVisitor;
import jadx.core.utils.exceptions.JadxException;

@JadxVisitor(name="ProcessAnonymous", desc="Mark anonymous and lambda classes (for future inline)", runAfter={UsageInfoVisitor.class})
public class ProcessAnonymous
extends AbstractVisitor {
    private boolean inlineAnonymous;

    @Override
    public void init(RootNode root) {
        this.inlineAnonymous = root.getArgs().isInlineAnonymousClasses();
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        if (!this.inlineAnonymous) {
            return false;
        }
        ProcessAnonymous.markAnonymousClass(cls);
        return true;
    }

    private static void markAnonymousClass(ClassNode cls) {
        if (ProcessAnonymous.usedOnlyOnce(cls) || ProcessAnonymous.isAnonymous(cls) || ProcessAnonymous.isLambdaCls(cls)) {
            if (ProcessAnonymous.isStaticFieldUsedOutside(cls)) {
                return;
            }
            cls.add(AFlag.ANONYMOUS_CLASS);
            cls.add(AFlag.DONT_GENERATE);
            for (MethodNode mth : cls.getMethods()) {
                if (!mth.isConstructor()) continue;
                mth.add(AFlag.ANONYMOUS_CONSTRUCTOR);
            }
        }
    }

    private static boolean isStaticFieldUsedOutside(ClassNode cls) {
        ClassNode topCls = cls.getTopParentClass();
        for (FieldNode field : cls.getFields()) {
            if (!field.isStatic()) continue;
            for (MethodNode useMth : field.getUseIn()) {
                ClassNode useCls = useMth.getParentClass().getTopParentClass();
                if (useCls.equals(topCls)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean usedOnlyOnce(ClassNode cls) {
        if (cls.getUseIn().size() == 1 && cls.getUseInMth().size() == 1) {
            boolean synthetic;
            boolean bl = synthetic = cls.getAccessFlags().isSynthetic() || cls.getClassInfo().getShortName().contains("$");
            if (synthetic) {
                MethodNode ctr = null;
                for (MethodNode mth : cls.getMethods()) {
                    if (!mth.isConstructor()) continue;
                    if (ctr != null) {
                        ctr = null;
                        break;
                    }
                    ctr = mth;
                }
                return ctr != null && ctr.getUseIn().size() == 1;
            }
        }
        return false;
    }

    private static boolean isAnonymous(ClassNode cls) {
        return cls.getClassInfo().isInner() && Character.isDigit(cls.getClassInfo().getShortName().charAt(0)) && cls.getMethods().stream().filter(MethodNode::isConstructor).count() == 1L;
    }

    private static boolean isLambdaCls(ClassNode cls) {
        return cls.getAccessFlags().isSynthetic() && cls.getAccessFlags().isFinal() && cls.getClassInfo().getRawName().contains(".-$$Lambda$") && ProcessAnonymous.countStaticFields(cls) == 0;
    }

    private static int countStaticFields(ClassNode cls) {
        int c = 0;
        for (FieldNode field : cls.getFields()) {
            if (!field.getAccessFlags().isStatic()) continue;
            ++c;
        }
        return c;
    }
}

