/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.codegen.TypeGen;
import jadx.core.deobf.NameMapper;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.EnumClassAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.ExtractFieldInit;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.ReSugarCode;
import jadx.core.dex.visitors.shrink.CodeShrinkVisitor;
import jadx.core.utils.BlockInsnPair;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

@JadxVisitor(name="EnumVisitor", desc="Restore enum classes", runAfter={CodeShrinkVisitor.class, ModVisitor.class, ReSugarCode.class}, runBefore={ExtractFieldInit.class})
public class EnumVisitor
extends AbstractVisitor {
    private MethodInfo enumValueOfMth;

    @Override
    public void init(RootNode root) {
        this.enumValueOfMth = MethodInfo.fromDetails(root, ClassInfo.fromType(root, ArgType.ENUM), "valueOf", Arrays.asList(ArgType.CLASS, ArgType.STRING), ArgType.ENUM);
    }

    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        AccessInfo accessFlags;
        if (!this.convertToEnum(cls) && (accessFlags = cls.getAccessFlags()).isEnum()) {
            cls.setAccessFlags(accessFlags.remove(16384));
            cls.addWarnComment("Failed to restore enum class, 'enum' modifier removed");
        }
        return true;
    }

    private boolean convertToEnum(ClassNode cls) {
        Optional<FieldNode> valuesOpt;
        if (!cls.isEnum()) {
            return false;
        }
        MethodNode classInitMth = cls.getClassInitMth();
        if (classInitMth == null) {
            cls.addWarnComment("Enum class init method not found");
            return false;
        }
        if (classInitMth.getBasicBlocks().isEmpty()) {
            return false;
        }
        ArgType clsType = cls.getClassInfo().getType();
        List valuesCandidates = cls.getFields().stream().filter(f -> f.getAccessFlags().isStatic()).filter(f -> f.getType().isArray()).filter(f -> Objects.equals(f.getType().getArrayRootElement(), clsType)).collect(Collectors.toList());
        if (valuesCandidates.isEmpty()) {
            return false;
        }
        if (valuesCandidates.size() > 1) {
            valuesCandidates.removeIf(f -> !f.getAccessFlags().isSynthetic());
        }
        if (valuesCandidates.size() > 1 && (valuesOpt = valuesCandidates.stream().filter(f -> f.getName().equals("$VALUES")).findAny()).isPresent()) {
            valuesCandidates.clear();
            valuesCandidates.add(valuesOpt.get());
        }
        if (valuesCandidates.size() != 1) {
            cls.addWarnComment("Found several \"values\" enum fields: " + valuesCandidates);
            return false;
        }
        FieldNode valuesField = (FieldNode)valuesCandidates.get(0);
        ArrayList<InsnNode> toRemove = new ArrayList<InsnNode>();
        BlockInsnPair valuesInitPair = this.getValuesInitInsn(classInitMth, valuesField);
        if (valuesInitPair == null) {
            return false;
        }
        BlockNode staticBlock = valuesInitPair.getBlock();
        InsnNode valuesInitInsn = valuesInitPair.getInsn();
        List<EnumClassAttr.EnumField> enumFields = null;
        InsnArg arrArg = valuesInitInsn.getArg(0);
        if (arrArg.isInsnWrap()) {
            InsnNode wrappedInsn = ((InsnWrapArg)arrArg).getWrapInsn();
            enumFields = this.extractEnumFieldsFromInsn(cls, staticBlock, wrappedInsn, toRemove);
        }
        if (enumFields == null) {
            return false;
        }
        toRemove.add(valuesInitInsn);
        EnumClassAttr attr = new EnumClassAttr(enumFields);
        attr.setStaticMethod(classInitMth);
        cls.addAttr(attr);
        for (EnumClassAttr.EnumField enumField : attr.getFields()) {
            ConstructorInsn co = enumField.getConstrInsn();
            FieldNode fieldNode = enumField.getField();
            String name = this.getConstString(cls.root(), co.getArg(0));
            if (name != null && !fieldNode.getAlias().equals(name) && NameMapper.isValidAndPrintable(name) && cls.root().getArgs().isRenameValid()) {
                fieldNode.getFieldInfo().setAlias(name);
            }
            fieldNode.add(AFlag.DONT_GENERATE);
            this.processConstructorInsn(cls, enumField, classInitMth, staticBlock, toRemove);
        }
        valuesField.add(AFlag.DONT_GENERATE);
        InsnRemover.removeAllAndUnbind(classInitMth, staticBlock, toRemove);
        if (classInitMth.countInsns() == 0L) {
            classInitMth.add(AFlag.DONT_GENERATE);
        } else if (!toRemove.isEmpty()) {
            CodeShrinkVisitor.shrinkMethod(classInitMth);
        }
        this.removeEnumMethods(cls, clsType, valuesField);
        return true;
    }

    private void processConstructorInsn(ClassNode cls, EnumClassAttr.EnumField enumField, MethodNode classInitMth, BlockNode staticBlock, List<InsnNode> toRemove) {
        RegisterArg coResArg;
        MethodNode ctrMth;
        ClassNode enumCls;
        ConstructorInsn co = enumField.getConstrInsn();
        ClassInfo enumClsInfo = co.getClassType();
        if (!enumClsInfo.equals(cls.getClassInfo()) && (enumCls = cls.root().resolveClass(enumClsInfo)) != null) {
            EnumVisitor.processEnumCls(enumField, enumCls);
            cls.addInlinedClass(enumCls);
        }
        ArrayList<RegisterArg> regs = new ArrayList<RegisterArg>();
        co.getRegisterArgs(regs);
        if (!regs.isEmpty()) {
            cls.addWarnComment("Init of enum " + enumField.getField().getName() + " can be incorrect");
        }
        if ((ctrMth = cls.root().resolveMethod(co.getCallMth())) != null) {
            this.markArgsForSkip(ctrMth);
        }
        if ((coResArg = co.getResult()) == null || coResArg.getSVar().getUseList().size() <= 2) {
            toRemove.add(co);
        } else {
            IndexInsnNode enumGet = new IndexInsnNode(InsnType.SGET, enumField.getField().getFieldInfo(), 0);
            enumGet.setResult(coResArg.duplicate());
            BlockUtils.replaceInsn(classInitMth, staticBlock, co, (InsnNode)enumGet);
        }
    }

    @Nullable
    private List<EnumClassAttr.EnumField> extractEnumFieldsFromInsn(ClassNode cls, BlockNode staticBlock, InsnNode wrappedInsn, List<InsnNode> toRemove) {
        switch (wrappedInsn.getType()) {
            case FILLED_NEW_ARRAY: {
                return this.extractEnumFieldsFromFilledArray(cls, wrappedInsn, staticBlock, toRemove);
            }
            case INVOKE: {
                return this.extractEnumFieldsFromInvoke(cls, staticBlock, (InvokeNode)wrappedInsn, toRemove);
            }
            case NEW_ARRAY: {
                InsnArg arg = wrappedInsn.getArg(0);
                if (arg.isZeroLiteral()) {
                    return Collections.emptyList();
                }
                return null;
            }
        }
        return null;
    }

    private List<EnumClassAttr.EnumField> extractEnumFieldsFromInvoke(ClassNode cls, BlockNode staticBlock, InvokeNode invokeNode, List<InsnNode> toRemove) {
        MethodInfo callMth = invokeNode.getCallMth();
        MethodNode valuesMth = cls.root().resolveMethod(callMth);
        if (valuesMth == null || valuesMth.isVoidReturn()) {
            return null;
        }
        BlockNode returnBlock = Utils.getOne(valuesMth.getPreExitBlocks());
        InsnNode returnInsn = BlockUtils.getLastInsn(returnBlock);
        InsnNode wrappedInsn = InsnUtils.getWrappedInsn(InsnUtils.getSingleArg(returnInsn));
        if (wrappedInsn == null) {
            return null;
        }
        List<EnumClassAttr.EnumField> enumFields = this.extractEnumFieldsFromInsn(cls, staticBlock, wrappedInsn, toRemove);
        if (enumFields != null) {
            valuesMth.add(AFlag.DONT_GENERATE);
        }
        return enumFields;
    }

    private BlockInsnPair getValuesInitInsn(MethodNode classInitMth, FieldNode valuesField) {
        FieldInfo searchField = valuesField.getFieldInfo();
        for (BlockNode blockNode : classInitMth.getBasicBlocks()) {
            for (InsnNode insn : blockNode.getInstructions()) {
                IndexInsnNode indexInsnNode;
                FieldInfo f;
                if (insn.getType() != InsnType.SPUT || !(f = (FieldInfo)(indexInsnNode = (IndexInsnNode)insn).getIndex()).equals(searchField)) continue;
                return new BlockInsnPair(blockNode, indexInsnNode);
            }
        }
        return null;
    }

    private List<EnumClassAttr.EnumField> extractEnumFieldsFromFilledArray(ClassNode cls, InsnNode arrFillInsn, BlockNode staticBlock, List<InsnNode> toRemove) {
        ArrayList<EnumClassAttr.EnumField> enumFields = new ArrayList<EnumClassAttr.EnumField>();
        for (InsnArg arg : arrFillInsn.getArguments()) {
            EnumClassAttr.EnumField field = null;
            if (arg.isInsnWrap()) {
                InsnNode wrappedInsn = ((InsnWrapArg)arg).getWrapInsn();
                field = this.processEnumFieldByWrappedInsn(cls, wrappedInsn, staticBlock, toRemove);
            } else if (arg.isRegister()) {
                field = this.processEnumFieldByRegister(cls, (RegisterArg)arg, staticBlock, toRemove);
            }
            if (field == null) {
                return null;
            }
            enumFields.add(field);
        }
        toRemove.add(arrFillInsn);
        return enumFields;
    }

    private EnumClassAttr.EnumField processEnumFieldByWrappedInsn(ClassNode cls, InsnNode wrappedInsn, BlockNode staticBlock, List<InsnNode> toRemove) {
        if (wrappedInsn.getType() == InsnType.SGET) {
            return this.processEnumFieldByField(cls, wrappedInsn, staticBlock, toRemove);
        }
        ConstructorInsn constructorInsn = this.castConstructorInsn(wrappedInsn);
        if (constructorInsn != null) {
            FieldNode enumFieldNode = this.createFakeField(cls, "EF" + constructorInsn.getOffset());
            cls.addField(enumFieldNode);
            return this.createEnumFieldByConstructor(cls, enumFieldNode, constructorInsn);
        }
        return null;
    }

    @Nullable
    private EnumClassAttr.EnumField processEnumFieldByField(ClassNode cls, InsnNode sgetInsn, BlockNode staticBlock, List<InsnNode> toRemove) {
        if (sgetInsn.getType() != InsnType.SGET) {
            return null;
        }
        FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)sgetInsn).getIndex();
        FieldNode enumFieldNode = cls.searchField(fieldInfo);
        if (enumFieldNode == null) {
            return null;
        }
        InsnNode sputInsn = this.searchFieldPutInsn(cls, staticBlock, enumFieldNode);
        if (sputInsn == null) {
            return null;
        }
        ConstructorInsn co = this.getConstructorInsn(sputInsn);
        if (co == null) {
            return null;
        }
        RegisterArg sgetResult = sgetInsn.getResult();
        if (sgetResult == null || sgetResult.getSVar().getUseCount() == 1) {
            toRemove.add(sgetInsn);
        }
        toRemove.add(sputInsn);
        return this.createEnumFieldByConstructor(cls, enumFieldNode, co);
    }

    @Nullable
    private EnumClassAttr.EnumField processEnumFieldByRegister(ClassNode cls, RegisterArg arg, BlockNode staticBlock, List<InsnNode> toRemove) {
        InsnNode assignInsn = arg.getAssignInsn();
        if (assignInsn != null && assignInsn.getType() == InsnType.SGET) {
            return this.processEnumFieldByField(cls, assignInsn, staticBlock, toRemove);
        }
        SSAVar ssaVar = arg.getSVar();
        if (ssaVar.getUseCount() == 0) {
            return null;
        }
        InsnNode constrInsn = ssaVar.getAssign().getParentInsn();
        if (constrInsn == null || constrInsn.getType() != InsnType.CONSTRUCTOR) {
            return null;
        }
        FieldNode enumFieldNode = this.searchEnumField(cls, ssaVar, toRemove);
        if (enumFieldNode == null) {
            enumFieldNode = this.createFakeField(cls, "EF" + arg.getRegNum());
            cls.addField(enumFieldNode);
        }
        return this.createEnumFieldByConstructor(cls, enumFieldNode, (ConstructorInsn)constrInsn);
    }

    private FieldNode createFakeField(ClassNode cls, String name) {
        FieldInfo fldInfo = FieldInfo.from(cls.root(), cls.getClassInfo(), name, cls.getType());
        FieldNode enumFieldNode = new FieldNode(cls, fldInfo, 0);
        enumFieldNode.add(AFlag.SYNTHETIC);
        enumFieldNode.addInfoComment("Fake field, exist only in values array");
        return enumFieldNode;
    }

    @Nullable
    private FieldNode searchEnumField(ClassNode cls, SSAVar ssaVar, List<InsnNode> toRemove) {
        InsnNode sputInsn = ssaVar.getUseList().get(0).getParentInsn();
        if (sputInsn == null || sputInsn.getType() != InsnType.SPUT) {
            return null;
        }
        FieldInfo fieldInfo = (FieldInfo)((IndexInsnNode)sputInsn).getIndex();
        FieldNode enumFieldNode = cls.searchField(fieldInfo);
        if (enumFieldNode == null) {
            return null;
        }
        toRemove.add(sputInsn);
        return enumFieldNode;
    }

    private EnumClassAttr.EnumField createEnumFieldByConstructor(ClassNode cls, FieldNode enumFieldNode, ConstructorInsn co) {
        if (co.getArgsCount() < 1) {
            return null;
        }
        ClassInfo clsInfo = co.getClassType();
        ClassNode constrCls = cls.root().resolveClass(clsInfo);
        if (constrCls == null) {
            return null;
        }
        if (!clsInfo.equals(cls.getClassInfo()) && !constrCls.getAccessFlags().isEnum()) {
            return null;
        }
        MethodNode ctrMth = cls.root().resolveMethod(co.getCallMth());
        if (ctrMth == null) {
            return null;
        }
        return new EnumClassAttr.EnumField(enumFieldNode, co);
    }

    @Nullable
    private InsnNode searchFieldPutInsn(ClassNode cls, BlockNode staticBlock, FieldNode enumFieldNode) {
        for (InsnNode sputInsn : staticBlock.getInstructions()) {
            FieldInfo f;
            FieldNode fieldNode;
            if (sputInsn == null || sputInsn.getType() != InsnType.SPUT || !Objects.equals(fieldNode = cls.searchField(f = (FieldInfo)((IndexInsnNode)sputInsn).getIndex()), enumFieldNode)) continue;
            return sputInsn;
        }
        return null;
    }

    private void removeEnumMethods(ClassNode cls, ArgType clsType, FieldNode valuesField) {
        String valuesMethod = "values()" + TypeGen.signature(ArgType.array(clsType));
        FieldInfo valuesFieldInfo = valuesField.getFieldInfo();
        for (MethodNode mth : cls.getMethods()) {
            MethodInfo mi = mth.getMethodInfo();
            if (mi.isClassInit()) continue;
            String shortId = mi.getShortId();
            if (mi.isConstructor()) {
                if (this.isDefaultConstructor(mth, shortId)) {
                    mth.add(AFlag.DONT_GENERATE);
                }
                this.markArgsForSkip(mth);
                continue;
            }
            if (!shortId.equals(valuesMethod) && !this.usesValuesField(mth, valuesFieldInfo) && !this.simpleValueOfMth(mth, clsType)) continue;
            mth.add(AFlag.DONT_GENERATE);
        }
    }

    private void markArgsForSkip(MethodNode mth) {
        SkipMethodArgsAttr.skipArg(mth, 0);
        if (mth.getMethodInfo().getArgsCount() > 1) {
            SkipMethodArgsAttr.skipArg(mth, 1);
        }
    }

    private boolean isDefaultConstructor(MethodNode mth, String shortId) {
        boolean defaultId;
        boolean bl = defaultId = shortId.equals("<init>(Ljava/lang/String;I)V") || shortId.equals("<init>(Ljava/lang/String;)V");
        if (defaultId) {
            return mth.countInsns() == 0L;
        }
        return false;
    }

    private boolean simpleValueOfMth(MethodNode mth, ArgType clsType) {
        InsnNode returnInsn = InsnUtils.searchSingleReturnInsn(mth, insn -> insn.getArgsCount() == 1);
        if (returnInsn == null) {
            return false;
        }
        InsnNode wrappedInsn = InsnUtils.getWrappedInsn(InsnUtils.getSingleArg(returnInsn));
        IndexInsnNode castInsn = (IndexInsnNode)InsnUtils.checkInsnType(wrappedInsn, InsnType.CHECK_CAST);
        if (castInsn != null && Objects.equals(castInsn.getIndex(), clsType)) {
            InvokeNode invokeInsn = (InvokeNode)InsnUtils.checkInsnType(InsnUtils.getWrappedInsn(InsnUtils.getSingleArg(castInsn)), InsnType.INVOKE);
            return invokeInsn != null && invokeInsn.getCallMth().equals(this.enumValueOfMth);
        }
        return false;
    }

    private boolean usesValuesField(MethodNode mth, FieldInfo valuesFieldInfo) {
        Predicate<InsnNode> insnTest = insn -> Objects.equals(((IndexInsnNode)insn).getIndex(), valuesFieldInfo);
        return InsnUtils.searchInsn(mth, InsnType.SGET, insnTest) != null;
    }

    private static void processEnumCls(EnumClassAttr.EnumField field, ClassNode innerCls) {
        for (MethodNode innerMth : innerCls.getMethods()) {
            if (!innerMth.getAccessFlags().isConstructor()) continue;
            innerMth.add(AFlag.DONT_GENERATE);
        }
        field.setCls(innerCls);
        innerCls.add(AFlag.DONT_GENERATE);
    }

    private ConstructorInsn getConstructorInsn(InsnNode insn) {
        if (insn.getArgsCount() != 1) {
            return null;
        }
        InsnArg arg = insn.getArg(0);
        if (arg.isInsnWrap()) {
            return this.castConstructorInsn(((InsnWrapArg)arg).getWrapInsn());
        }
        if (arg.isRegister()) {
            return this.castConstructorInsn(((RegisterArg)arg).getAssignInsn());
        }
        return null;
    }

    @Nullable
    private ConstructorInsn castConstructorInsn(InsnNode coCandidate) {
        if (coCandidate != null && coCandidate.getType() == InsnType.CONSTRUCTOR) {
            return (ConstructorInsn)coCandidate;
        }
        return null;
    }

    private String getConstString(RootNode root, InsnArg arg) {
        InsnNode constInsn;
        Object constValue;
        if (arg.isInsnWrap() && (constValue = InsnUtils.getConstValueByInsn(root, constInsn = ((InsnWrapArg)arg).getWrapInsn())) instanceof String) {
            return (String)constValue;
        }
        return null;
    }
}

