/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes;

import jadx.api.plugins.input.data.IFieldData;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.core.dex.attributes.nodes.NotificationAttrNode;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ICodeNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.nodes.RootNode;
import java.util.Collections;
import java.util.List;

public class FieldNode
extends NotificationAttrNode
implements ICodeNode {
    private final ClassNode parentClass;
    private final FieldInfo fieldInfo;
    private AccessInfo accFlags;
    private ArgType type;
    private List<MethodNode> useIn = Collections.emptyList();

    public static FieldNode build(ClassNode cls, IFieldData fieldData) {
        FieldInfo fieldInfo = FieldInfo.fromRef(cls.root(), (IFieldRef)fieldData);
        FieldNode fieldNode = new FieldNode(cls, fieldInfo, fieldData.getAccessFlags());
        fieldNode.addAttrs(fieldData.getAttributes());
        return fieldNode;
    }

    public FieldNode(ClassNode cls, FieldInfo fieldInfo, int accessFlags) {
        this.parentClass = cls;
        this.fieldInfo = fieldInfo;
        this.type = fieldInfo.getType();
        this.accFlags = new AccessInfo(accessFlags, AccessInfo.AFType.FIELD);
    }

    public void updateType(ArgType type) {
        this.type = type;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Override
    public AccessInfo getAccessFlags() {
        return this.accFlags;
    }

    @Override
    public void setAccessFlags(AccessInfo accFlags) {
        this.accFlags = accFlags;
    }

    public boolean isStatic() {
        return this.accFlags.isStatic();
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public String getAlias() {
        return this.fieldInfo.getAlias();
    }

    public ArgType getType() {
        return this.type;
    }

    public ClassNode getParentClass() {
        return this.parentClass;
    }

    public List<MethodNode> getUseIn() {
        return this.useIn;
    }

    public void setUseIn(List<MethodNode> useIn) {
        this.useIn = useIn;
    }

    @Override
    public String typeName() {
        return "field";
    }

    @Override
    public String getInputFileName() {
        return this.parentClass.getInputFileName();
    }

    @Override
    public RootNode root() {
        return this.parentClass.root();
    }

    public int hashCode() {
        return this.fieldInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FieldNode other = (FieldNode)obj;
        return this.fieldInfo.equals(other.fieldInfo);
    }

    public String toString() {
        return this.fieldInfo.getDeclClass() + "." + this.fieldInfo.getName() + " :" + this.type;
    }
}

