/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.api.JadxArgs;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.files.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeobfPresets {
    private static final Logger LOG = LoggerFactory.getLogger(DeobfPresets.class);
    private static final Charset MAP_FILE_CHARSET = StandardCharsets.UTF_8;
    private final Path deobfMapFile;
    private final Map<String, String> pkgPresetMap = new HashMap<String, String>();
    private final Map<String, String> clsPresetMap = new HashMap<String, String>();
    private final Map<String, String> fldPresetMap = new HashMap<String, String>();
    private final Map<String, String> mthPresetMap = new HashMap<String, String>();

    @Nullable
    public static DeobfPresets build(RootNode root) {
        Path deobfMapPath = DeobfPresets.getPathDeobfMapPath(root);
        if (deobfMapPath == null) {
            return null;
        }
        LOG.debug("Deobfuscation map file set to: {}", (Object)deobfMapPath);
        return new DeobfPresets(deobfMapPath);
    }

    @Nullable
    private static Path getPathDeobfMapPath(RootNode root) {
        JadxArgs jadxArgs = root.getArgs();
        File deobfMapFile = jadxArgs.getDeobfuscationMapFile();
        if (deobfMapFile != null) {
            return deobfMapFile.toPath();
        }
        List<File> inputFiles = jadxArgs.getInputFiles();
        if (inputFiles.isEmpty()) {
            return null;
        }
        Path inputFilePath = inputFiles.get(0).getAbsoluteFile().toPath();
        String baseName = FileUtils.getPathBaseName(inputFilePath);
        return inputFilePath.getParent().resolve(baseName + ".jobf");
    }

    private DeobfPresets(Path deobfMapFile) {
        this.deobfMapFile = deobfMapFile;
    }

    public void load() {
        if (!Files.exists(this.deobfMapFile, new LinkOption[0])) {
            return;
        }
        LOG.info("Loading obfuscation map from: {}", (Object)this.deobfMapFile.toAbsolutePath());
        try {
            List<String> lines = Files.readAllLines(this.deobfMapFile, MAP_FILE_CHARSET);
            for (String l : lines) {
                String[] va;
                if ((l = l.trim()).isEmpty() || l.startsWith("#") || (va = DeobfPresets.splitAndTrim(l)).length != 2) continue;
                String origName = va[0];
                String alias = va[1];
                switch (l.charAt(0)) {
                    case 'p': {
                        this.pkgPresetMap.put(origName, alias);
                        break;
                    }
                    case 'c': {
                        this.clsPresetMap.put(origName, alias);
                        break;
                    }
                    case 'f': {
                        this.fldPresetMap.put(origName, alias);
                        break;
                    }
                    case 'm': {
                        this.mthPresetMap.put(origName, alias);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to load deobfuscation map file '{}'", (Object)this.deobfMapFile.toAbsolutePath(), (Object)e);
        }
    }

    private static String[] splitAndTrim(String str) {
        String[] v = str.substring(2).split("=");
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i].trim();
        }
        return v;
    }

    public void save() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> pkgEntry : this.pkgPresetMap.entrySet()) {
            list.add(String.format("p %s = %s", pkgEntry.getKey(), pkgEntry.getValue()));
        }
        for (Map.Entry<String, String> clsEntry : this.clsPresetMap.entrySet()) {
            list.add(String.format("c %s = %s", clsEntry.getKey(), clsEntry.getValue()));
        }
        for (Map.Entry<String, String> fldEntry : this.fldPresetMap.entrySet()) {
            list.add(String.format("f %s = %s", fldEntry.getKey(), fldEntry.getValue()));
        }
        for (Map.Entry<String, String> mthEntry : this.mthPresetMap.entrySet()) {
            list.add(String.format("m %s = %s", mthEntry.getKey(), mthEntry.getValue()));
        }
        Collections.sort(list);
        if (list.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deobfuscation map is empty, not saving it");
            }
            return;
        }
        Files.write(this.deobfMapFile, list, MAP_FILE_CHARSET, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deobfuscation map file saved as: {}", (Object)this.deobfMapFile);
        }
    }

    public String getForCls(ClassInfo cls) {
        if (this.clsPresetMap.isEmpty()) {
            return null;
        }
        return this.clsPresetMap.get(cls.makeRawFullName());
    }

    public String getForFld(FieldInfo fld) {
        if (this.fldPresetMap.isEmpty()) {
            return null;
        }
        return this.fldPresetMap.get(fld.getRawFullId());
    }

    public String getForMth(MethodInfo mth) {
        if (this.mthPresetMap.isEmpty()) {
            return null;
        }
        return this.mthPresetMap.get(mth.getRawFullId());
    }

    public void clear() {
        this.clsPresetMap.clear();
        this.fldPresetMap.clear();
        this.mthPresetMap.clear();
    }

    public Path getDeobfMapFile() {
        return this.deobfMapFile;
    }

    public Map<String, String> getPkgPresetMap() {
        return this.pkgPresetMap;
    }

    public Map<String, String> getClsPresetMap() {
        return this.clsPresetMap;
    }

    public Map<String, String> getFldPresetMap() {
        return this.fldPresetMap;
    }

    public Map<String, String> getMthPresetMap() {
        return this.mthPresetMap;
    }
}

