/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

public final class CodePosition {
    private final int line;
    private final int offset;
    private final int pos;

    public CodePosition(int line, int offset, int pos) {
        this.line = line;
        this.offset = offset;
        this.pos = pos;
    }

    public CodePosition(int line) {
        this(line, 0, -1);
    }

    @Deprecated
    public CodePosition(int line, int offset) {
        this(line, offset, -1);
    }

    public int getPos() {
        return this.pos;
    }

    public int getLine() {
        return this.line;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodePosition that = (CodePosition)o;
        return this.line == that.line && this.offset == that.offset;
    }

    public int hashCode() {
        return this.line + 31 * this.offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.line);
        if (this.offset != 0) {
            sb.append(':').append(this.offset);
        }
        if (this.pos > 0) {
            sb.append('@').append(this.pos);
        }
        return sb.toString();
    }
}

