/*
 * Decompiled with CFR 0.152.
 */
package jadx.commons.app;

import dev.dirs.ProjectDirectories;
import jadx.commons.app.JadxCommonEnv;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class JadxCommonFiles {
    private static final Path CONFIG_DIR;
    private static final Path CACHE_DIR;

    public static Path getConfigDir() {
        return CONFIG_DIR;
    }

    public static Path getCacheDir() {
        return CACHE_DIR;
    }

    static {
        DirsLoader loader = new DirsLoader();
        loader.init();
        CONFIG_DIR = loader.getConfigDir();
        CACHE_DIR = loader.getCacheDir();
    }

    private static final class DirsLoader {
        @Nullable
        private ProjectDirectories dirs;
        private Path configDir;
        private Path cacheDir;

        private DirsLoader() {
        }

        public void init() {
            try {
                this.configDir = this.loadEnvDir("JADX_CONFIG_DIR", pd -> pd.configDir);
                this.cacheDir = this.loadEnvDir("JADX_CACHE_DIR", pd -> pd.cacheDir);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to init common directories", e);
            }
        }

        private Path loadEnvDir(String envVar, Function<ProjectDirectories, String> dirFunc) throws IOException {
            String envDir = JadxCommonEnv.get(envVar, null);
            String dirStr = envDir != null ? envDir : dirFunc.apply(this.loadDirs());
            Path path = Path.of(dirStr, new String[0]).toAbsolutePath();
            Files.createDirectories(path, new FileAttribute[0]);
            return path;
        }

        private synchronized ProjectDirectories loadDirs() {
            if (this.dirs == null) {
                this.dirs = ProjectDirectories.from((String)"io.github", (String)"skylot", (String)"jadx");
            }
            return this.dirs;
        }

        public Path getCacheDir() {
            return this.cacheDir;
        }

        public Path getConfigDir() {
            return this.configDir;
        }
    }
}

