/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.apkm;

import jadx.core.utils.GsonUtils;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.input.apkm.ApkmManifest;
import jadx.zip.IZipEntry;
import jadx.zip.ZipContent;
import jadx.zip.ZipReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005\u00a8\u0006\r"}, d2={"Ljadx/plugins/input/apkm/ApkmUtils;", "", "<init>", "()V", "getManifest", "Ljadx/plugins/input/apkm/ApkmManifest;", "file", "Ljava/io/File;", "zipReader", "Ljadx/zip/ZipReader;", "isSupported", "", "manifest", "jadx-apkm-input"})
public final class ApkmUtils {
    @NotNull
    public static final ApkmUtils INSTANCE = new ApkmUtils();

    private ApkmUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final ApkmManifest getManifest(@NotNull File file, @NotNull ZipReader zipReader) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)zipReader, (String)"zipReader");
        if (!FileUtils.isZipFile((File)file)) {
            return null;
        }
        try {
            Closeable closeable = (Closeable)zipReader.open(file);
            Throwable throwable = null;
            try {
                ApkmManifest apkmManifest;
                IZipEntry iZipEntry;
                ZipContent zip = (ZipContent)closeable;
                boolean bl = false;
                if (zip.searchEntry("info.json") == null) {
                    ApkmManifest apkmManifest2 = null;
                    return apkmManifest2;
                }
                IZipEntry manifestEntry = iZipEntry;
                Closeable closeable2 = new InputStreamReader(manifestEntry.getInputStream());
                Throwable throwable2 = null;
                try {
                    InputStreamReader it = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    apkmManifest = (ApkmManifest)GsonUtils.buildGson().fromJson((Reader)it, ApkmManifest.class);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                ApkmManifest apkmManifest3 = apkmManifest;
                return apkmManifest3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public final boolean isSupported(@NotNull ApkmManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        return manifest.getApkmVersion() != -1;
    }
}

