/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.aab.factories;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.plugins.resources.IResContainerFactory;
import jadx.core.dex.nodes.RootNode;
import jadx.core.xmlgen.ResContainer;
import jadx.plugins.input.aab.parsers.ResXmlProtoParser;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public class ProtoXmlResContainerFactory
implements IResContainerFactory {
    private ResXmlProtoParser xmlParser;

    public void init(RootNode root) {
        this.xmlParser = new ResXmlProtoParser(root);
    }

    @Nullable
    public ResContainer create(ResourceFile resFile, InputStream inputStream) throws IOException {
        ResourceType type = resFile.getType();
        if (type != ResourceType.XML && type != ResourceType.MANIFEST) {
            return null;
        }
        ResourceFile.ZipRef ref = resFile.getZipRef();
        if (ref == null) {
            return null;
        }
        boolean isFromAab = ref.getZipFile().getPath().contains(".aab");
        if (!isFromAab) {
            return null;
        }
        ICodeInfo content = this.xmlParser.parse(inputStream);
        return ResContainer.textResource((String)resFile.getDeobfName(), (ICodeInfo)content);
    }
}

