/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools.base;

import android.graphics.Bitmap;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class Utils {
    public static Bitmap drawColorBitmap(Bitmap sampleBitmap, int color) {
        Bitmap outputBitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 256; ++y) {
                int c = -16777216;
                c |= x << 0;
                c |= x << 8;
                outputBitmap.setPixel(x, y, c |= x << 16);
            }
        }
        return outputBitmap;
    }

    public static Bitmap drawHistograms(int[] histograms, int channels) {
        Bitmap outputBitmap = Bitmap.createBitmap((int)(256 * channels), (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float[] maxes = new float[channels];
        for (int c = 0; c < channels; ++c) {
            int max = 0;
            for (int i = 0; i < 256; ++i) {
                max = Math.max(histograms[c + i * channels], max);
            }
            maxes[c] = max;
        }
        for (int y = 0; y < 256; ++y) {
            for (int x = 0; x < 256 * channels; ++x) {
                int c = x / 256;
                int i = x % 256;
                int height = (int)((float)histograms[c + i * channels] / maxes[c] * 255.0f);
                int color = y < height ? -16777216 : -1;
                outputBitmap.setPixel(x, 255 - y, color);
            }
        }
        return outputBitmap;
    }

    public static double meanSquareErrorRgb8888(int[] a, int[] b) {
        byte[] aBytes = Utils.intArrayAsByteArray(a);
        byte[] bBytes = Utils.intArrayAsByteArray(b);
        return Utils.meanSquareErrorFromBytes(aBytes, bBytes);
    }

    private static byte[] intArrayAsByteArray(int[] a) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(a.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(a);
        return byteBuffer.array();
    }

    public static double meanSquareErrorFromBytes(byte[] a, byte[] b) {
        double sum_sq = 0.0;
        for (int i = 0; i < a.length; ++i) {
            int err = b[i] & 255 - a[i] & 0xFF;
            sum_sq += (double)(err * err);
        }
        double mse = sum_sq / (double)a.length;
        return mse;
    }
}

