/*
 * Decompiled with CFR 0.152.
 */
package io.github.silvaren.easyrs.tools;

import android.graphics.Bitmap;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicResize;
import android.support.v8.renderscript.Type;
import io.github.silvaren.easyrs.tools.Nv21Image;
import io.github.silvaren.easyrs.tools.base.RSToolboxContext;

public class Resize {
    public static Bitmap resize(RenderScript rs, Bitmap inputBitmap, int targetWidth, int targetHeight) {
        RSToolboxContext bitmapRSContext = RSToolboxContext.createFromBitmap(rs, inputBitmap);
        Bitmap.Config config = inputBitmap.getConfig();
        Bitmap outputBitmap = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)config);
        Type outType = Type.createXY((RenderScript)bitmapRSContext.rs, (Element)bitmapRSContext.ain.getElement(), (int)targetWidth, (int)targetHeight);
        Allocation aout = Allocation.createTyped((RenderScript)bitmapRSContext.rs, (Type)outType);
        ScriptIntrinsicResize resizeScript = ScriptIntrinsicResize.create((RenderScript)bitmapRSContext.rs);
        resizeScript.setInput(bitmapRSContext.ain);
        resizeScript.forEach_bicubic(aout);
        aout.copyTo(outputBitmap);
        return outputBitmap;
    }

    public static byte[] resize(RenderScript rs, byte[] nv21ByteArray, int width, int height, int targetWidth, int targetHeight) {
        Bitmap srcBitmap = Nv21Image.nv21ToBitmap(rs, nv21ByteArray, width, height);
        Bitmap resizedBitmap = Resize.resize(rs, srcBitmap, targetWidth, targetHeight);
        return Nv21Image.bitmapToNV21((RenderScript)rs, (Bitmap)resizedBitmap).nv21ByteArray;
    }
}

