/*
 * Decompiled with CFR 0.152.
 */
package com.zj.shimmer;

import android.graphics.Matrix;
import android.graphics.Shader;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.draw.DrawModifier;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidPaint_androidKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.drawscope.ContentDrawScope;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.layout.IntrinsicMeasurable;
import androidx.compose.ui.layout.IntrinsicMeasureScope;
import androidx.compose.ui.layout.LayoutModifier;
import androidx.compose.ui.layout.Measurable;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.layout.MeasureScope;
import androidx.compose.ui.layout.Placeable;
import com.zj.shimmer.ShimmerConfig;
import com.zj.shimmer.ShimmerDirection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\f\u0010\u001f\u001a\u00020\u001a*\u00020 H\u0016J)\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b(\u0010)R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006*"}, d2={"Lcom/zj/shimmer/ShimmerModifier;", "Landroidx/compose/ui/draw/DrawModifier;", "Landroidx/compose/ui/layout/LayoutModifier;", "visible", "", "progress", "", "config", "Lcom/zj/shimmer/ShimmerConfig;", "(ZFLcom/zj/shimmer/ShimmerConfig;)V", "angleTan", "cleanPaint", "Landroidx/compose/ui/graphics/Paint;", "colorStops", "", "colors", "Landroidx/compose/ui/graphics/Color;", "dropOff", "intensity", "paint", "translateHeight", "translateWidth", "offset", "start", "end", "updateSize", "", "size", "Landroidx/compose/ui/geometry/Size;", "updateSize-uvyYCjk", "(J)V", "draw", "Landroidx/compose/ui/graphics/drawscope/ContentDrawScope;", "measure", "Landroidx/compose/ui/layout/MeasureResult;", "Landroidx/compose/ui/layout/MeasureScope;", "measurable", "Landroidx/compose/ui/layout/Measurable;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "measure-3p2s80s", "(Landroidx/compose/ui/layout/MeasureScope;Landroidx/compose/ui/layout/Measurable;J)Landroidx/compose/ui/layout/MeasureResult;", "shimmer_release"})
public final class ShimmerModifier
implements DrawModifier,
LayoutModifier {
    private final boolean visible;
    private final float progress;
    @NotNull
    private final ShimmerConfig config;
    @NotNull
    private final Paint cleanPaint;
    @NotNull
    private final Paint paint;
    private final float angleTan;
    private float translateHeight;
    private float translateWidth;
    private final float intensity;
    private final float dropOff;
    @NotNull
    private final List<Color> colors;
    @NotNull
    private final List<Float> colorStops;

    /*
     * WARNING - void declaration
     */
    public ShimmerModifier(boolean visible, float progress, @NotNull ShimmerConfig config) {
        void $this$paint_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.visible = visible;
        this.progress = progress;
        this.config = config;
        this.cleanPaint = AndroidPaint_androidKt.Paint();
        Paint paint = AndroidPaint_androidKt.Paint();
        boolean bl = false;
        boolean bl2 = false;
        Paint paint2 = paint;
        ShimmerModifier shimmerModifier = this;
        boolean bl3 = false;
        $this$paint_u24lambda_u2d0.setAntiAlias(true);
        $this$paint_u24lambda_u2d0.setStyle-k9PVt8s(PaintingStyle.Companion.getFill-TiuSbCo());
        $this$paint_u24lambda_u2d0.setBlendMode-s9anfk8(BlendMode.Companion.getSrcIn-0nO6VwU());
        Unit unit = Unit.INSTANCE;
        shimmerModifier.paint = paint;
        double d = Math.toRadians(this.config.getAngle());
        bl2 = false;
        this.angleTan = (float)Math.tan(d);
        this.intensity = this.config.getIntensity();
        this.dropOff = this.config.getDropOff();
        Object[] objectArray = new Color[]{Color.box-impl((long)this.config.getContentColor-0d7_KjU()), Color.box-impl((long)this.config.getHigLightColor-0d7_KjU()), Color.box-impl((long)this.config.getHigLightColor-0d7_KjU()), Color.box-impl((long)this.config.getContentColor-0d7_KjU())};
        this.colors = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Float[]{Float.valueOf(RangesKt.coerceIn((float)((1.0f - this.intensity - this.dropOff) / 2.0f), (float)0.0f, (float)1.0f)), Float.valueOf(RangesKt.coerceIn((float)((1.0f - this.intensity - 0.001f) / 2.0f), (float)0.0f, (float)1.0f)), Float.valueOf(RangesKt.coerceIn((float)((1.0f + this.intensity + 0.001f) / 2.0f), (float)0.0f, (float)1.0f)), Float.valueOf(RangesKt.coerceIn((float)((1.0f + this.intensity + this.dropOff) / 2.0f), (float)0.0f, (float)1.0f))};
        this.colorStops = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void draw(@NotNull ContentDrawScope $this$draw) {
        void $this$withSaveLayer$iv;
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        DrawScope $this$drawIntoCanvas$iv = (DrawScope)$this$draw;
        boolean $i$f$drawIntoCanvas = false;
        Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
        boolean bl = false;
        Canvas canvas = it;
        Rect rect = new Rect(0.0f, 0.0f, Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc()), Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()));
        Paint paint$iv = this.cleanPaint;
        boolean $i$f$withSaveLayer = false;
        try {
            void bounds$iv;
            $this$withSaveLayer$iv.saveLayer((Rect)bounds$iv, paint$iv);
            boolean bl2 = false;
            $this$draw.drawContent();
            if (this.visible) {
                Pair pair;
                ShimmerDirection shimmerDirection = this.config.getDirection();
                int n = WhenMappings.$EnumSwitchMapping$0[shimmerDirection.ordinal()];
                switch (n) {
                    case 1: {
                        pair = new Pair((Object)Float.valueOf(this.offset(-this.translateWidth, this.translateWidth, this.progress)), (Object)Float.valueOf(0.0f));
                        break;
                    }
                    case 2: {
                        pair = new Pair((Object)Float.valueOf(this.offset(this.translateWidth, -this.translateWidth, this.progress)), (Object)Float.valueOf(0.0f));
                        break;
                    }
                    case 3: {
                        pair = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.offset(-this.translateHeight, this.translateHeight, this.progress)));
                        break;
                    }
                    case 4: {
                        pair = new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.offset(this.translateHeight, -this.translateHeight, this.progress)));
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair pair2 = pair;
                float dx = ((Number)pair2.component1()).floatValue();
                float dy = ((Number)pair2.component2()).floatValue();
                Shader shader = this.paint.getShader();
                if (shader != null) {
                    Shader $this$transform$iv = shader;
                    boolean $i$f$transform = false;
                    Matrix matrix$iv = new Matrix();
                    $this$transform$iv.getLocalMatrix(matrix$iv);
                    Matrix $this$draw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = matrix$iv;
                    boolean bl3 = false;
                    $this$draw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.reset();
                    $this$draw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.postRotate(this.config.getAngle(), Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc()) / 2.0f, Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc()) / 2.0f);
                    $this$draw_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.postTranslate(dx, dy);
                    $this$transform$iv.setLocalMatrix(matrix$iv);
                }
                it.drawRect(new Rect(0.0f, 0.0f, Size.getWidth-impl((long)$this$draw.getSize-NH-jbRc()), Size.getHeight-impl((long)$this$draw.getSize-NH-jbRc())), this.paint);
            }
        }
        finally {
            $this$withSaveLayer$iv.restore();
        }
    }

    @NotNull
    public MeasureResult measure-3p2s80s(@NotNull MeasureScope $this$measure_u2d3p2s80s, @NotNull Measurable measurable, long constraints) {
        Intrinsics.checkNotNullParameter((Object)$this$measure_u2d3p2s80s, (String)"$receiver");
        Intrinsics.checkNotNullParameter((Object)measurable, (String)"measurable");
        Placeable placeable = measurable.measure-BRTryo0(constraints);
        long size = SizeKt.Size((float)placeable.getWidth(), (float)placeable.getHeight());
        this.updateSize-uvyYCjk(size);
        return MeasureScope.DefaultImpls.layout$default((MeasureScope)$this$measure_u2d3p2s80s, (int)placeable.getWidth(), (int)placeable.getHeight(), null, (Function1)((Function1)new Function1<Placeable.PlacementScope, Unit>(placeable){
            final /* synthetic */ Placeable $placeable;
            {
                this.$placeable = $placeable;
                super(1);
            }

            public final void invoke(@NotNull Placeable.PlacementScope $this$layout) {
                Intrinsics.checkNotNullParameter((Object)$this$layout, (String)"$this$layout");
                Placeable.PlacementScope.place$default((Placeable.PlacementScope)$this$layout, (Placeable)this.$placeable, (int)0, (int)0, (float)0.0f, (int)4, null);
            }
        }), (int)4, null);
    }

    private final void updateSize-uvyYCjk(long size) {
        long l;
        this.translateWidth = Size.getWidth-impl((long)size) + this.angleTan * Size.getHeight-impl((long)size);
        this.translateHeight = Size.getHeight-impl((long)size) + this.angleTan * Size.getWidth-impl((long)size);
        ShimmerDirection shimmerDirection = this.config.getDirection();
        int n = WhenMappings.$EnumSwitchMapping$0[shimmerDirection.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                l = OffsetKt.Offset((float)Size.getWidth-impl((long)size), (float)0.0f);
                break;
            }
            default: {
                l = OffsetKt.Offset((float)0.0f, (float)Size.getHeight-impl((long)size));
            }
        }
        long toOffset = l;
        this.paint.setShader(ShaderKt.LinearGradientShader-VjE6UOU$default((long)OffsetKt.Offset((float)0.0f, (float)0.0f), (long)toOffset, this.colors, this.colorStops, (int)0, (int)16, null));
    }

    private final float offset(float start, float end, float progress) {
        return start + (end - start) * progress;
    }

    public int maxIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$maxIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        return LayoutModifier.DefaultImpls.maxIntrinsicHeight((LayoutModifier)this, (IntrinsicMeasureScope)$this$maxIntrinsicHeight, (IntrinsicMeasurable)measurable, (int)width);
    }

    public int maxIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$maxIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        return LayoutModifier.DefaultImpls.maxIntrinsicWidth((LayoutModifier)this, (IntrinsicMeasureScope)$this$maxIntrinsicWidth, (IntrinsicMeasurable)measurable, (int)height);
    }

    public int minIntrinsicHeight(@NotNull IntrinsicMeasureScope $this$minIntrinsicHeight, @NotNull IntrinsicMeasurable measurable, int width) {
        return LayoutModifier.DefaultImpls.minIntrinsicHeight((LayoutModifier)this, (IntrinsicMeasureScope)$this$minIntrinsicHeight, (IntrinsicMeasurable)measurable, (int)width);
    }

    public int minIntrinsicWidth(@NotNull IntrinsicMeasureScope $this$minIntrinsicWidth, @NotNull IntrinsicMeasurable measurable, int height) {
        return LayoutModifier.DefaultImpls.minIntrinsicWidth((LayoutModifier)this, (IntrinsicMeasureScope)$this$minIntrinsicWidth, (IntrinsicMeasurable)measurable, (int)height);
    }

    public <R> R foldIn(R initial, @NotNull Function2<? super R, ? super Modifier.Element, ? extends R> operation) {
        return (R)DrawModifier.DefaultImpls.foldIn((DrawModifier)this, initial, operation);
    }

    public <R> R foldOut(R initial, @NotNull Function2<? super Modifier.Element, ? super R, ? extends R> operation) {
        return (R)DrawModifier.DefaultImpls.foldOut((DrawModifier)this, initial, operation);
    }

    public boolean all(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return DrawModifier.DefaultImpls.all((DrawModifier)this, predicate);
    }

    public boolean any(@NotNull Function1<? super Modifier.Element, Boolean> predicate) {
        return DrawModifier.DefaultImpls.any((DrawModifier)this, predicate);
    }

    @NotNull
    public Modifier then(@NotNull Modifier other) {
        return DrawModifier.DefaultImpls.then((DrawModifier)this, (Modifier)other);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShimmerDirection.values().length];
            nArray[ShimmerDirection.LeftToRight.ordinal()] = 1;
            nArray[ShimmerDirection.RightToLeft.ordinal()] = 2;
            nArray[ShimmerDirection.TopToBottom.ordinal()] = 3;
            nArray[ShimmerDirection.BottomToTop.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

