/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava.validator;

import io.github.sharelison.jsontojava.exception.JsonToJavaException;
import io.github.sharelison.jsontojava.validator.JsonType;
import io.github.sharelison.jsontojava.validator.JsonTypeChecker;
import io.github.sharelison.jsontojava.validator.JsonValidator;
import org.json.JSONArray;

public class InputJsonValidator
implements JsonValidator {
    private final JsonTypeChecker jsonTypeChecker;

    public InputJsonValidator() {
        this.jsonTypeChecker = new JsonType();
    }

    public InputJsonValidator(JsonTypeChecker jsonTypeChecker) {
        this.jsonTypeChecker = jsonTypeChecker;
    }

    @Override
    public boolean isValidJson(String jsonString) {
        return !this.nullOrEmpty(jsonString) && (this.validArray(jsonString) || this.jsonTypeChecker.isObject(jsonString));
    }

    private boolean validArray(String jsonString) {
        boolean valid = false;
        if (this.jsonTypeChecker.isArray(jsonString)) {
            JSONArray jsonArray = new JSONArray(jsonString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                String elementJsonString = jsonArray.get(i).toString();
                if (this.jsonTypeChecker.isObject(elementJsonString)) {
                    valid = true;
                    break;
                }
                if (!this.jsonTypeChecker.isArray(elementJsonString)) continue;
                valid = this.validArray(elementJsonString);
            }
            if (!valid) {
                throw new JsonToJavaException("JSON Array does not contain any objects, no class can be created");
            }
        }
        return valid;
    }

    private boolean nullOrEmpty(String jsonString) {
        return jsonString == null || jsonString.isEmpty();
    }
}

