/*
 * Decompiled with CFR 0.152.
 */
package io.github.sharelison.jsontojava.converter;

import io.github.sharelison.jsontojava.converter.AbstractJsonConverter;
import io.github.sharelison.jsontojava.converter.JsonClassResult;
import io.github.sharelison.jsontojava.file.FileReader;
import io.github.sharelison.jsontojava.file.JsonFileReader;
import io.github.sharelison.jsontojava.validator.InputJsonValidator;
import io.github.sharelison.jsontojava.validator.JsonType;
import io.github.sharelison.jsontojava.validator.JsonTypeChecker;
import io.github.sharelison.jsontojava.validator.JsonValidator;
import java.util.List;

public class FileJsonConverter
extends AbstractJsonConverter {
    private final FileReader fileReader;
    private final JsonValidator jsonValidator;
    private final JsonTypeChecker jsonTypeChecker;

    public FileJsonConverter(FileReader fileReader, JsonValidator jsonValidator, JsonTypeChecker jsonTypeChecker) {
        this.fileReader = fileReader;
        this.jsonValidator = jsonValidator;
        this.jsonTypeChecker = jsonTypeChecker;
    }

    public FileJsonConverter() {
        this.fileReader = new JsonFileReader();
        this.jsonValidator = new InputJsonValidator();
        this.jsonTypeChecker = new JsonType();
    }

    @Override
    public List<JsonClassResult> convertToJava(String jsonPath, String objectName, String packageName, boolean withAnnotations) {
        String jsonString = this.fileReader.readJsonFromFile(jsonPath);
        return this.convertJsonToJava(jsonString, objectName, packageName, withAnnotations);
    }

    @Override
    public List<JsonClassResult> convertToJava(String json, String objectName, String packageName) {
        return this.convertToJava(json, objectName, packageName, true);
    }

    @Override
    protected JsonValidator jsonValidator() {
        return this.jsonValidator;
    }

    @Override
    protected JsonTypeChecker jsonTypeChecker() {
        return this.jsonTypeChecker;
    }
}

