/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class PersistentMap {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentMap.class);
    private final Path path;
    private final int limit;
    private LinkedHashMap<String, String> map;
    private int memoryUsage;

    public PersistentMap(Path path, int limit) {
        this.path = path;
        this.limit = limit;
    }

    public Path getFile() {
        return this.path;
    }

    private void load() throws IOException {
        assert (this.map == null);
        assert (this.memoryUsage == 0);
        this.map = new LinkedHashMap();
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.path, new OpenOption[0])));){
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                this.map.put(key, value);
                this.memoryUsage += PersistentMap.entrySize(key, value);
            }
        }
    }

    private static int entrySize(String key, String value) {
        return PersistentMap.stringSize(key) + PersistentMap.stringSize(value);
    }

    private static int stringSize(String s) {
        return s.length() * 2 + 16;
    }

    private void ensureInited() {
        if (this.map == null) {
            try {
                this.load();
            }
            catch (IOException e) {
                if (!(e instanceof NoSuchFileException)) {
                    LOG.error("Failed to load data", (Throwable)e);
                }
                this.map = new LinkedHashMap();
            }
        }
    }

    public synchronized String get(@NonNull String key) {
        this.ensureInited();
        String value = (String)this.map.remove(key);
        if (value != null) {
            this.map.put(key, value);
        }
        return value;
    }

    public synchronized void put(@NonNull String key, @NonNull String value) {
        this.ensureInited();
        String oldValue = (String)this.map.remove(key);
        this.map.put(key, value);
        if (oldValue == null) {
            this.memoryUsage += PersistentMap.entrySize(key, value);
        } else {
            if (oldValue.equals(value)) {
                return;
            }
            this.memoryUsage += PersistentMap.stringSize(value) - PersistentMap.stringSize(oldValue);
        }
        while (this.memoryUsage > this.limit && this.map.size() > 1) {
            String firstKey = this.map.keySet().iterator().next();
            String v = (String)this.map.remove(firstKey);
            this.memoryUsage -= PersistentMap.entrySize(key, v);
        }
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(this.path, new OpenOption[0])));){
            outputStream.writeInt(this.map.size());
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                outputStream.writeUTF(entry.getKey());
                outputStream.writeUTF(entry.getValue());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to save state: " + this.path, (Throwable)e);
        }
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }
}

