/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.services;

import com.logviewer.api.LvFileAccessManager;
import com.logviewer.services.PathPattern;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvFileAccessManagerImpl
implements LvFileAccessManager {
    static Supplier<List<Path>> ROOT_PROVIDER = () -> Stream.of(File.listRoots()).map(File::toPath).collect(Collectors.toList());
    private List<PathPattern> descriptors;
    private List<Path> roots;

    public LvFileAccessManagerImpl(@Nullable List<PathPattern> descriptors) {
        this.setPaths(descriptors);
    }

    private LvFileAccessManagerImpl() {
        this(null);
    }

    public void setPaths(@Nullable List<PathPattern> descriptors) {
        if (descriptors == null) {
            this.descriptors = null;
            this.roots = ROOT_PROVIDER.get();
        } else {
            this.descriptors = new ArrayList<PathPattern>(descriptors);
            this.roots = LvFileAccessManagerImpl.computeRoots(descriptors);
        }
    }

    public void setVisibleFiles(@NonNull List<Path> files) {
        this.setPaths(files.stream().map(PathPattern::file).collect(Collectors.toList()));
    }

    public void allowAll() {
        this.setPaths(null);
    }

    private static List<Path> computeRoots(List<PathPattern> descriptors) {
        ArrayList<Path> fixedPaths = new ArrayList<Path>();
        for (PathPattern descriptor : descriptors) {
            if (descriptor.getPrefix() == null) {
                return ROOT_PROVIDER.get();
            }
            fixedPaths.add(descriptor.getPrefix());
        }
        HashSet copy = new HashSet(fixedPaths);
        for (Path path : copy) {
            fixedPaths.removeIf(p -> path != p && p.startsWith(path));
        }
        return fixedPaths;
    }

    @Override
    @Nullable
    public boolean isFileVisible(Path file) {
        if (!file.isAbsolute()) {
            return false;
        }
        if (this.descriptors == null) {
            return true;
        }
        for (PathPattern descriptor : this.descriptors) {
            if (!descriptor.matchFile(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String errorMessage(Path path) {
        return "\"" + path + "' is not accessible due to LogViewer configuration";
    }

    @Override
    public boolean isDirectoryVisible(Path dir) {
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException("Path is not absolute: " + dir);
        }
        if (this.descriptors == null) {
            return true;
        }
        for (PathPattern descriptor : this.descriptors) {
            if (!descriptor.matchDir(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public List<Path> getRoots() {
        return this.roots;
    }
}

