/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.logLibs.log4j;

import com.logviewer.utils.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.lang.NonNull;

public class Log4jPatternParser {
    private static final char ESCAPE_CHAR = '%';
    private static final int DECIMAL = 10;

    public static List<Triple<String, List<String>, FormattingInfo>> parse(@NonNull String pattern) {
        ArrayList<Triple<String, List<String>, FormattingInfo>> res = new ArrayList<Triple<String, List<String>, FormattingInfo>>();
        StringBuilder currentLiteral = new StringBuilder();
        int patternLength = pattern.length();
        ParserState state = ParserState.LITERAL_STATE;
        int i = 0;
        FormattingInfo formattingInfo = FormattingInfo.getDefault();
        while (i < patternLength) {
            char c = pattern.charAt(i++);
            block0 : switch (state) {
                case LITERAL_STATE: {
                    if (i == patternLength) {
                        currentLiteral.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (pattern.charAt(i)) {
                            case '%': {
                                currentLiteral.append(c);
                                ++i;
                                break block0;
                            }
                        }
                        if (currentLiteral.length() != 0) {
                            res.add(Log4jPatternParser.stringLiteral(currentLiteral));
                            currentLiteral.setLength(0);
                        }
                        currentLiteral.append(c);
                        state = ParserState.CONVERTER_STATE;
                        formattingInfo = FormattingInfo.getDefault();
                        break;
                    }
                    currentLiteral.append(c);
                    break;
                }
                case CONVERTER_STATE: {
                    currentLiteral.append(c);
                    switch (c) {
                        case '0': {
                            formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), true);
                            break block0;
                        }
                        case '-': {
                            formattingInfo = new FormattingInfo(true, formattingInfo.getMinLength(), formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                            break block0;
                        }
                        case '.': {
                            state = ParserState.DOT_STATE;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), c - 48, formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        state = ParserState.MIN_STATE;
                        break;
                    }
                    i = Log4jPatternParser.finalizeConverter(c, pattern, i, currentLiteral, formattingInfo, res);
                    state = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                    break;
                }
                case MIN_STATE: {
                    currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength() * 10 + c - 48, formattingInfo.getMaxLength(), formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        break;
                    }
                    if (c == '.') {
                        state = ParserState.DOT_STATE;
                        break;
                    }
                    i = Log4jPatternParser.finalizeConverter(c, pattern, i, currentLiteral, formattingInfo, res);
                    state = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                    break;
                }
                case DOT_STATE: {
                    currentLiteral.append(c);
                    switch (c) {
                        case '-': {
                            formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength(), false, formattingInfo.isZeroPad());
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), c - 48, formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        state = ParserState.MAX_STATE;
                        break;
                    }
                    state = ParserState.LITERAL_STATE;
                    break;
                }
                case MAX_STATE: {
                    currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        formattingInfo = new FormattingInfo(formattingInfo.isLeftAligned(), formattingInfo.getMinLength(), formattingInfo.getMaxLength() * 10 + c - 48, formattingInfo.isLeftTruncate(), formattingInfo.isZeroPad());
                        break;
                    }
                    i = Log4jPatternParser.finalizeConverter(c, pattern, i, currentLiteral, formattingInfo, res);
                    state = ParserState.LITERAL_STATE;
                    formattingInfo = FormattingInfo.getDefault();
                    currentLiteral.setLength(0);
                }
            }
        }
        if (currentLiteral.length() != 0) {
            res.add(Log4jPatternParser.stringLiteral(currentLiteral));
        }
        return res;
    }

    private static int extractConverter(char lastChar, String pattern, int start, StringBuilder convBuf) {
        int i;
        convBuf.setLength(0);
        if (!Character.isUnicodeIdentifierStart(lastChar)) {
            return i;
        }
        convBuf.append(lastChar);
        for (i = start; i < pattern.length() && Character.isUnicodeIdentifierPart(pattern.charAt(i)); ++i) {
            convBuf.append(pattern.charAt(i));
        }
        return i;
    }

    private static int extractOptions(String pattern, int start, List<String> options) {
        int i = start;
        while (i < pattern.length() && pattern.charAt(i) == '{') {
            int begin = ++i;
            int depth = 1;
            while (depth > 0 && i < pattern.length()) {
                char c = pattern.charAt(i);
                if (c == '{') {
                    ++depth;
                } else if (c == '}') {
                    --depth;
                }
                ++i;
            }
            if (depth > 0) {
                i = pattern.lastIndexOf(125);
                if (i == -1 || i < start) {
                    return begin;
                }
                return i + 1;
            }
            options.add(pattern.substring(begin, i - 1));
        }
        return i;
    }

    private static int finalizeConverter(char c, String pattern, int start, StringBuilder currentLiteral, FormattingInfo formattingInfo, List<Triple<String, List<String>, FormattingInfo>> res) {
        int i = start;
        StringBuilder convBuf = new StringBuilder();
        i = Log4jPatternParser.extractConverter(c, pattern, i, convBuf);
        String converterId = convBuf.toString();
        if (converterId.isEmpty()) {
            res.add(Log4jPatternParser.stringLiteral("%"));
            return i;
        }
        ArrayList<String> options = new ArrayList<String>();
        i = Log4jPatternParser.extractOptions(pattern, i, options);
        res.add(Triple.create(converterId, options, formattingInfo));
        currentLiteral.setLength(0);
        return i;
    }

    private static Triple<String, List<String>, FormattingInfo> stringLiteral(CharSequence str) {
        return Triple.create("", Collections.singletonList(str.toString()), FormattingInfo.getDefault());
    }

    public static class FormattingInfo {
        private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
        private static final char[] ZEROS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE, true);
        private final int minLength;
        private final int maxLength;
        private final boolean leftAlign;
        private final boolean leftTruncate;
        private final boolean zeroPad;

        public FormattingInfo(boolean leftAlign, int minLength, int maxLength, boolean leftTruncate) {
            this(leftAlign, minLength, maxLength, leftTruncate, false);
        }

        public FormattingInfo(boolean leftAlign, int minLength, int maxLength, boolean leftTruncate, boolean zeroPad) {
            this.leftAlign = leftAlign;
            this.minLength = minLength;
            this.maxLength = maxLength;
            this.leftTruncate = leftTruncate;
            this.zeroPad = zeroPad;
        }

        public static FormattingInfo getDefault() {
            return DEFAULT;
        }

        public boolean isLeftAligned() {
            return this.leftAlign;
        }

        public boolean isLeftTruncate() {
            return this.leftTruncate;
        }

        public boolean isZeroPad() {
            return this.zeroPad;
        }

        public int getMinLength() {
            return this.minLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void format(int fieldStart, StringBuilder buffer) {
            int rawLength = buffer.length() - fieldStart;
            if (rawLength > this.maxLength) {
                if (this.leftTruncate) {
                    buffer.delete(fieldStart, buffer.length() - this.maxLength);
                } else {
                    buffer.delete(fieldStart + this.maxLength, fieldStart + buffer.length());
                }
            } else if (rawLength < this.minLength) {
                if (this.leftAlign) {
                    int fieldEnd = buffer.length();
                    buffer.setLength(fieldStart + this.minLength);
                    for (int i = fieldEnd; i < buffer.length(); ++i) {
                        buffer.setCharAt(i, ' ');
                    }
                } else {
                    int padLength;
                    char[] paddingArray;
                    char[] cArray = paddingArray = this.zeroPad ? ZEROS : SPACES;
                    for (padLength = this.minLength - rawLength; padLength > paddingArray.length; padLength -= paddingArray.length) {
                        buffer.insert(fieldStart, paddingArray);
                    }
                    buffer.insert(fieldStart, paddingArray, 0, padLength);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append("[leftAlign=");
            sb.append(this.leftAlign);
            sb.append(", maxLength=");
            sb.append(this.maxLength);
            sb.append(", minLength=");
            sb.append(this.minLength);
            sb.append(", leftTruncate=");
            sb.append(this.leftTruncate);
            sb.append(", zeroPad=");
            sb.append(this.zeroPad);
            sb.append(']');
            return sb.toString();
        }
    }

    private static enum ParserState {
        LITERAL_STATE,
        CONVERTER_STATE,
        DOT_STATE,
        MIN_STATE,
        MAX_STATE;

    }
}

