/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.LogService;
import com.logviewer.data2.net.server.IncomeConnection;
import com.logviewer.utils.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class LogViewerBackdoorServer
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LogViewerBackdoorServer.class);
    public static final int DEFAULT_PORT = 9595;
    @Autowired
    private LogService logService;
    @Value(value="${log-viewer.backdoor_server.port:9595}")
    private int port;
    @Value(value="${log-viewer.server.interface:}")
    private String serverInterface;
    private AsynchronousServerSocketChannel socket;
    private boolean closed;
    private final Set<IncomeConnection> connections = new HashSet<IncomeConnection>();

    private synchronized void onDisconnect(IncomeConnection conn) {
        this.connections.remove(conn);
    }

    public void afterPropertiesSet() throws Exception {
        this.startup();
    }

    public synchronized void startup() throws IOException {
        assert (this.socket == null);
        InetSocketAddress socketAddress = !this.serverInterface.isEmpty() ? new InetSocketAddress(this.serverInterface, this.port) : new InetSocketAddress(this.port);
        this.socket = AsynchronousServerSocketChannel.open();
        this.socket.bind(socketAddress);
        this.socket.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(AsynchronousSocketChannel socket, Void attachment) {
                IncomeConnection connection;
                LogViewerBackdoorServer logViewerBackdoorServer = LogViewerBackdoorServer.this;
                synchronized (logViewerBackdoorServer) {
                    if (LogViewerBackdoorServer.this.closed) {
                        Utils.closeQuietly(socket);
                        return;
                    }
                    connection = new IncomeConnection(socket, LogViewerBackdoorServer.this.logService, x$0 -> LogViewerBackdoorServer.this.onDisconnect(x$0));
                    LogViewerBackdoorServer.this.connections.add(connection);
                }
                connection.init();
                LogViewerBackdoorServer.this.socket.accept(null, this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, Void attachment) {
                LogViewerBackdoorServer logViewerBackdoorServer = LogViewerBackdoorServer.this;
                synchronized (logViewerBackdoorServer) {
                    if (!LogViewerBackdoorServer.this.closed) {
                        LOG.error("Server socket failed", exc);
                        LogViewerBackdoorServer.this.destroy();
                    }
                }
            }
        });
    }

    public synchronized void destroy() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.socket.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close log server", (Throwable)e);
        }
        for (IncomeConnection connection : this.connections.toArray(new IncomeConnection[0])) {
            try {
                connection.close();
            }
            catch (Exception e) {
                LOG.error("Failed to close connection", (Throwable)e);
            }
        }
    }
}

