/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Destroyer;
import com.logviewer.utils.Pair;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SearchResult;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.SearchPattern;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;

public abstract class BrokenLog
implements LogView {
    protected final Throwable error;

    public BrokenLog(Throwable error) {
        this.error = error;
    }

    @Override
    public final boolean isConnected() {
        return false;
    }

    @Override
    public LogProcess loadRecords(RecordPredicate filter, int recordCount, Position start, boolean backward, String hash, long sizeLimit, @NonNull LogDataListener listener) {
        return new DummyLogProcess(() -> listener.onFinish(new Status(this.error), false));
    }

    @Override
    public LogProcess createRecordSearcher(@NonNull Position start, boolean backward, RecordPredicate recordPredicate, @NonNull String hash, int recordCount, @NonNull SearchPattern searchPattern, @NonNull Consumer<SearchResult> listener) {
        return new DummyLogProcess(() -> listener.accept(new SearchResult(this.error)));
    }

    @Override
    public CompletableFuture<Throwable> tryRead() {
        return CompletableFuture.completedFuture(this.error);
    }

    @Override
    public CompletableFuture<Pair<String, Integer>> loadContent(long offset, int length) {
        CompletableFuture<Pair<String, Integer>> res = new CompletableFuture<Pair<String, Integer>>();
        res.completeExceptionally(this.error);
        return res;
    }

    @Override
    public Destroyer addChangeListener(Consumer<FileAttributes> changeListener) {
        return () -> {};
    }

    private static class DummyLogProcess
    implements LogProcess {
        private final Runnable onStart;

        DummyLogProcess(Runnable onStart) {
            this.onStart = onStart;
        }

        @Override
        public void setTimeLimit(long timeLimit) {
        }

        @Override
        public void start() {
            this.onStart.run();
        }

        @Override
        public void cancel() {
        }
    }
}

