/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.net.RemoteNodeService;
import com.logviewer.data2.net.server.LogWatcherTask;
import com.logviewer.data2.net.server.api.RemoteTaskController;
import com.logviewer.utils.Destroyer;
import com.logviewer.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteLogChangeListenerService {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteLogChangeListenerService.class);
    private final RemoteNodeService remoteNodeService;
    private final Map<LogPath, Pair<Destroyer, List<ListenerDescription>>> map = new HashMap<LogPath, Pair<Destroyer, List<ListenerDescription>>>();

    public RemoteLogChangeListenerService(RemoteNodeService remoteNodeService) {
        this.remoteNodeService = remoteNodeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destroyer addListener(LogPath path, Consumer<FileAttributes> listener) {
        if (path.getNode() == null) {
            throw new IllegalArgumentException();
        }
        ListenerDescription description = new ListenerDescription(path, listener);
        Map<LogPath, Pair<Destroyer, List<ListenerDescription>>> map = this.map;
        synchronized (map) {
            Pair pair = this.map.computeIfAbsent(path, k -> {
                ArrayList descriptions = new ArrayList();
                RemoteTaskController<LogWatcherTask> controller = this.remoteNodeService.startTask(k.getNode(), new LogWatcherTask(k.getFile()), (attr, e) -> {
                    if (e == null) {
                        ArrayList cloneDescriptions;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Log change message received from LogWatcherTask [path={}]", (Object)path);
                        }
                        Map<LogPath, Pair<Destroyer, List<ListenerDescription>>> map = this.map;
                        synchronized (map) {
                            cloneDescriptions = new ArrayList(descriptions);
                        }
                        for (ListenerDescription destroyer1 : cloneDescriptions) {
                            try {
                                destroyer1.listener.accept(attr);
                            }
                            catch (Throwable ex) {
                                LOG.error("Failed to notify listener", ex);
                            }
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Exception from LogWatcherTask [path={}]", (Object)path, e);
                    }
                });
                return Pair.of(controller::cancel, descriptions);
            });
            ((List)pair.getSecond()).add(description);
        }
        return description;
    }

    private class ListenerDescription
    implements Destroyer {
        private final LogPath path;
        private final Consumer<FileAttributes> listener;

        ListenerDescription(LogPath path, Consumer<FileAttributes> listener) {
            this.path = path;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Destroyer realListenerDestroyer;
            Map map = RemoteLogChangeListenerService.this.map;
            synchronized (map) {
                Pair pair = (Pair)RemoteLogChangeListenerService.this.map.get(this.path);
                if (pair == null) {
                    return;
                }
                if (!((List)pair.getSecond()).remove(this)) {
                    return;
                }
                if (((List)pair.getSecond()).size() > 0) {
                    return;
                }
                RemoteLogChangeListenerService.this.map.remove(this.path);
                realListenerDestroyer = (Destroyer)pair.getFirst();
            }
            realListenerDestroyer.close();
        }
    }
}

