/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.web.session;

import com.logviewer.api.LvFilterPanelStateProvider;
import com.logviewer.api.LvFilterStorage;
import com.logviewer.api.LvPathResolver;
import com.logviewer.api.LvPermalinkStorage;
import com.logviewer.api.LvUiConfigurer;
import com.logviewer.data2.ExceptionBrokenLogView;
import com.logviewer.data2.FavoriteLogService;
import com.logviewer.data2.LogCrashedException;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogService;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.domain.Permalink;
import com.logviewer.filters.CompositeRecordPredicate;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.filters.SubstringPredicate;
import com.logviewer.utils.LvTimer;
import com.logviewer.utils.Utils;
import com.logviewer.utils.Wrappers;
import com.logviewer.web.dto.LogList;
import com.logviewer.web.dto.events.EventBrokenLink;
import com.logviewer.web.dto.events.EventInitByPermalink;
import com.logviewer.web.dto.events.EventNextDataLoaded;
import com.logviewer.web.dto.events.EventResponseAfterFilterChanged;
import com.logviewer.web.dto.events.EventResponseAfterFilterChangedSingle;
import com.logviewer.web.dto.events.EventScrollToEdgeResponse;
import com.logviewer.web.dto.events.EventSearchResponse;
import com.logviewer.web.dto.events.EventSetViewState;
import com.logviewer.web.dto.events.SetFilterStateEvent;
import com.logviewer.web.rmt.Remote;
import com.logviewer.web.session.LogChangeNotifier;
import com.logviewer.web.session.SessionAdapter;
import com.logviewer.web.session.SessionTask;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.LoadNextResponse;
import com.logviewer.web.session.tasks.LoadRecordTask;
import com.logviewer.web.session.tasks.SearchPattern;
import com.logviewer.web.session.tasks.SearchTask;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigResolveOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LogSession {
    private static final Logger LOG = LoggerFactory.getLogger(LogSession.class);
    public static final Exception NO_DATE_EXCEPTION = new Exception("No date field, log cannot be merged");
    private final SessionAdapter sender;
    @Autowired
    private LogService logService;
    @Autowired
    private FavoriteLogService favoriteLogService;
    @Autowired
    private LvFilterStorage filterStorage;
    @Autowired
    private LvTimer lvTimer;
    @Autowired
    private LvPermalinkStorage permalinkStorage;
    @Autowired(required=false)
    private List<LvFilterPanelStateProvider> filterSetProviders = Collections.emptyList();
    @Autowired(required=false)
    private List<LvUiConfigurer> uiConfigurers = Collections.emptyList();
    @Autowired(required=false)
    private List<LvPathResolver> pathResolvers = Collections.emptyList();
    private final List<SessionTask<?>> executions = new LinkedList();
    private RecordPredicate filter;
    private long stateVersion;
    private LogView[] logs;
    private LogChangeNotifier logChangeNotifier;
    private static volatile Config defaultConfig;
    @Value(value="${log-viewer.wait-for-data-timeout:100}")
    private int waitForDataTimeoutMS = 100;

    public LogSession(SessionAdapter sessionAdapter) {
        this.sender = sessionAdapter;
    }

    public int getWaitForDataTimeoutMS() {
        return this.waitForDataTimeoutMS;
    }

    public void setWaitForDataTimeoutMS(int waitForDataTimeoutMS) {
        this.waitForDataTimeoutMS = waitForDataTimeoutMS;
    }

    public LogView[] getLogs() {
        return this.logs;
    }

    private void initFilters(@NonNull LogList logFileList, boolean isInitByPermalink) {
        Set<LogPath> logPathsFinal = this.toPathSet(logFileList);
        Map<String, LogView> logsMap = Utils.safeGet(this.logService.openLogs(logPathsFinal));
        this.logs = logsMap.values().toArray(new LogView[0]);
        if (this.logs.length > 1) {
            for (int i = 0; i < this.logs.length; ++i) {
                if (!this.logs[i].isConnected() || this.logs[i].getFormat().hasFullDate()) continue;
                Throwable e = Utils.safeGet(this.logs[i].tryRead());
                if (e == null) {
                    e = NO_DATE_EXCEPTION;
                }
                this.logs[i] = new ExceptionBrokenLogView(this.logs[i], e);
            }
        }
        this.logChangeNotifier = new LogChangeNotifier(this.logs, this.sender, this.logService.getTimer());
        LinkedHashMap<String, String> globalSavedFilters = new LinkedHashMap<String, String>();
        for (LvFilterPanelStateProvider filterSetProvider : this.filterSetProviders) {
            globalSavedFilters.putAll(filterSetProvider.getFilterSets());
        }
        this.sender.send(new EventSetViewState(this.logs, this.createConfigProps(), this.favoriteLogService, globalSavedFilters, isInitByPermalink));
    }

    private Config createConfigProps() {
        Config res = defaultConfig;
        if (res == null) {
            defaultConfig = res = ConfigFactory.parseResourcesAnySyntax((ClassLoader)LogSession.class.getClassLoader(), (String)"log-viewer-ui");
        }
        for (LvUiConfigurer lvUiConfigurer : this.uiConfigurers) {
            Config uiConfig = lvUiConfigurer.getUiConfig();
            if (uiConfig == null) continue;
            res = uiConfig.withFallback((ConfigMergeable)res);
        }
        return res.resolve(ConfigResolveOptions.noSystem());
    }

    @Remote
    public synchronized void initPermalink(final int recordCount, @NonNull String linkHash) {
        Permalink permalink;
        if (this.stateVersion != 0L) {
            throw new IllegalStateException(String.valueOf(this.stateVersion));
        }
        try {
            permalink = this.permalinkStorage.load(linkHash);
        }
        catch (IOException e) {
            this.sender.send(new EventBrokenLink());
            return;
        }
        this.sender.send(new SetFilterStateEvent(permalink.getFilterStateUrlParam(), permalink.getFilterState()));
        this.stateVersion = 1L;
        this.initFilters(permalink.getLogList(), true);
        if (this.logs.length == 0) {
            return;
        }
        ArrayList<RecordPredicate> filters = new ArrayList<RecordPredicate>();
        if (permalink.getFilterPanelFilters() != null) {
            Collections.addAll(filters, permalink.getFilterPanelFilters());
        }
        if (permalink.isHideUnmatched() && permalink.getSearchPattern() != null) {
            filters.add(new SubstringPredicate(permalink.getSearchPattern()));
        }
        this.filter = CompositeRecordPredicate.and(filters);
        CompletableFuture<LoadNextResponse> execution = this.execute(new LoadRecordTask(this.sender, this.logs, recordCount, this.filter, permalink.getOffset(), false, permalink.getHashes()));
        execution.whenComplete(new LogExecutionHandler<LoadNextResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(LoadNextResponse res, Throwable e) {
                LogSession logSession = LogSession.this;
                synchronized (logSession) {
                    if (this.initStateVersion != LogSession.this.stateVersion) {
                        return;
                    }
                    if (res.getStatuses().values().stream().map(Status::getError).anyMatch(it -> it instanceof LogCrashedException)) {
                        LogSession.this.sender.send(new EventBrokenLink());
                        return;
                    }
                    super.accept(res, e);
                }
            }

            @Override
            protected void handle(LoadNextResponse res) {
                LogSession.this.sender.send(new EventInitByPermalink(res.getStatuses(), LogSession.this.stateVersion, res, permalink));
                LogSession.this.loadNext(permalink.getOffset(), true, recordCount, permalink.getHashes(), LogSession.this.stateVersion);
            }
        });
    }

    @Remote
    public synchronized void loadFilterStateByHash(@NonNull String hash) {
        String filterState = this.filterStorage.loadFilterStateByHash(hash);
        if (filterState != null) {
            this.sender.send(new SetFilterStateEvent(hash, filterState));
        }
    }

    @Remote
    public synchronized void init(@NonNull LogList logList) {
        if (this.stateVersion != 0L) {
            throw new IllegalStateException(String.valueOf(this.stateVersion));
        }
        this.stateVersion = 1L;
        this.initFilters(logList, false);
    }

    private boolean updateStateVersionAndFilters(long version, @Nullable RecordPredicate[] filter) {
        if (this.stateVersion >= version) {
            return false;
        }
        this.stateVersion = version;
        for (SessionTask<?> execution : this.executions) {
            execution.cancel();
        }
        this.executions.clear();
        this.filter = CompositeRecordPredicate.and(filter);
        return true;
    }

    @Remote
    public synchronized void scrollToEdge(int recordCount, final long stateVersion, @Nullable RecordPredicate[] filter, final boolean isScrollToBegin) {
        if (!this.updateStateVersionAndFilters(stateVersion, filter)) {
            return;
        }
        Position pos = null;
        if (isScrollToBegin) {
            String logId = this.logs.length == 1 ? this.logs[0].getId() : "";
            pos = new Position(logId, 0L, 0L);
        }
        CompletableFuture<LoadNextResponse> future = this.execute(new LoadRecordTask(this.sender, this.logs, recordCount, this.filter, pos, !isScrollToBegin, null));
        future.whenComplete(new LogExecutionHandler<LoadNextResponse>(){

            @Override
            protected void handle(LoadNextResponse res) {
                LogSession.this.sender.send(new EventScrollToEdgeResponse(res.getStatuses(), stateVersion, res, isScrollToBegin));
            }
        });
    }

    @Remote
    public synchronized void loadingDataAfterFilterChangedSingle(int recordCount, final long stateVersion, @Nullable RecordPredicate[] filter) {
        if (!this.updateStateVersionAndFilters(stateVersion, filter)) {
            return;
        }
        LoadRecordTask task = new LoadRecordTask(this.sender, this.logs, recordCount, this.filter, null, true, null);
        CompletableFuture<LoadNextResponse> ex = this.execute(task);
        ex.whenComplete(new LogExecutionHandler<LoadNextResponse>(){

            @Override
            protected void handle(LoadNextResponse res) {
                LogSession.this.sender.send(new EventResponseAfterFilterChangedSingle(res.getStatuses(), stateVersion, res));
            }
        });
    }

    @Remote
    public synchronized void loadingDataAfterFilterChanged(int topRecordCount, int bottomRecordCount, long stateVersion, Map<String, String> hashes, @Nullable RecordPredicate[] filter, Position start) {
        if (!this.updateStateVersionAndFilters(stateVersion, filter)) {
            return;
        }
        final LoadRecordTask topLoadTask = new LoadRecordTask(this.sender, this.logs, topRecordCount, this.filter, start, true, hashes);
        final LoadRecordTask bottomLoadTask = new LoadRecordTask(this.sender, this.logs, bottomRecordCount, this.filter, start, false, hashes);
        CompletableFuture<LoadNextResponse> topLoadFut = this.execute(topLoadTask);
        CompletableFuture<LoadNextResponse> bottomLoadFut = this.execute(bottomLoadTask);
        BiConsumer<LoadNextResponse, Throwable> errorConsumer = Wrappers.of(LOG, new BiConsumer<LoadNextResponse, Throwable>(){
            private final AtomicBoolean responseSend = new AtomicBoolean();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(LoadNextResponse loadNextResponse, Throwable throwable) {
                if (throwable == null || !this.responseSend.compareAndSet(false, true)) {
                    return;
                }
                topLoadTask.cancel();
                bottomLoadTask.cancel();
                LogSession logSession = LogSession.this;
                synchronized (logSession) {
                    LogSession.this.handleTaskError(throwable);
                }
            }
        });
        topLoadFut.whenComplete((BiConsumer)errorConsumer);
        bottomLoadFut.whenComplete((BiConsumer)errorConsumer);
        topLoadFut.thenAcceptBoth(bottomLoadFut, (top, bottom) -> {
            if (stateVersion == this.stateVersion) {
                this.sender.send(new EventResponseAfterFilterChanged(bottom.getStatuses(), stateVersion, (LoadNextResponse)top, (LoadNextResponse)bottom));
            }
        });
    }

    @Remote
    public synchronized void loadNext(final Position start, final boolean backward, int recordCount, Map<String, String> hashes, final long stateVersion) {
        if (!this.checkStateVersion(stateVersion)) {
            return;
        }
        for (SessionTask<?> task : this.executions) {
            LoadRecordTask t;
            if (!(task instanceof LoadRecordTask) || !Objects.equals((t = (LoadRecordTask)task).getStart(), start) || t.isBackward() != backward || !Objects.equals(t.getHashes(), hashes)) continue;
            return;
        }
        CompletableFuture<LoadNextResponse> execution = this.execute(new LoadRecordTask(this.sender, this.logs, recordCount, this.filter, start, backward, hashes));
        execution.whenComplete(new LogExecutionHandler<LoadNextResponse>(){

            @Override
            protected void handle(LoadNextResponse res) {
                LogSession.this.sender.send(new EventNextDataLoaded(res.getStatuses(), stateVersion, res, start, backward));
            }
        });
    }

    @Remote
    public synchronized void cancelSearch() {
        this.cancelExecutions(t -> t instanceof SearchTask);
    }

    @Remote
    public synchronized void searchNext(final Position start, final boolean backward, final int recordCount, final SearchPattern pattern, final @NonNull Map<String, String> hashes, final long stateVersion, final long requestId, final boolean loadNext) {
        if (!this.checkStateVersion(stateVersion)) {
            return;
        }
        SearchTask searchTask = new SearchTask(this.sender, this.logs, start, recordCount, backward, pattern, hashes, this.filter);
        this.execute(searchTask).whenComplete(new LogExecutionHandler<SearchTask.SearchResponse>(){

            @Override
            protected void handle(final SearchTask.SearchResponse searchRes) {
                if (searchRes.getData() == null) {
                    LogSession.this.sender.send(new EventSearchResponse(searchRes, stateVersion, requestId));
                    return;
                }
                int foundIdx = backward ? 0 : searchRes.getData().size() - 1;
                LogRecord found = searchRes.getData().get(foundIdx).getFirst();
                assert (pattern.matcher().test(found.getMessage()));
                EventSearchResponse searchResponse = new EventSearchResponse(searchRes, stateVersion, requestId, foundIdx);
                if (!loadNext) {
                    LogSession.this.sender.send(searchResponse);
                    return;
                }
                final SendEventTask sendEventTask = new SendEventTask(searchResponse);
                LogSession.this.lvTimer.schedule((TimerTask)sendEventTask, LogSession.this.waitForDataTimeoutMS);
                LoadRecordTask loadRecordTask = new LoadRecordTask(LogSession.this.sender, LogSession.this.logs, recordCount, LogSession.this.filter, new Position(found, backward), backward, hashes);
                LogSession.this.execute(loadRecordTask).whenComplete(new LogExecutionHandler<LoadNextResponse>(){

                    @Override
                    protected void handle(LoadNextResponse loadRes) {
                        sendEventTask.cancel();
                        if (sendEventTask.isSent) {
                            LogSession.this.sender.send(new EventNextDataLoaded(loadRes.getStatuses(), stateVersion, loadRes, start, backward));
                        } else {
                            LogSession.this.sender.send(new EventSearchResponse(searchRes, loadRes, stateVersion, requestId, backward));
                        }
                    }
                });
            }
        });
    }

    private boolean checkStateVersion(long stateVersion) {
        if (this.stateVersion < stateVersion) {
            throw new IllegalStateException("backend_stateVersion=" + this.stateVersion + ", but UI_stateVersion=" + stateVersion);
        }
        return this.stateVersion == stateVersion;
    }

    private void cancelExecutions(Predicate<SessionTask<?>> filter) {
        assert (Thread.holdsLock(this));
        Iterator<SessionTask<?>> itr = this.executions.iterator();
        while (itr.hasNext()) {
            SessionTask<?> task = itr.next();
            if (!filter.test(task)) continue;
            task.cancel();
            itr.remove();
        }
    }

    private <T> CompletableFuture<T> execute(SessionTask<T> task) {
        assert (Thread.holdsLock(this));
        CompletableFuture future = new CompletableFuture();
        this.executions.add(task);
        task.execute((T res, Throwable e) -> {
            LogSession logSession = this;
            synchronized (logSession) {
                this.executions.remove(task);
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    future.complete(res);
                }
            }
        });
        return future;
    }

    public synchronized void shutdown() {
        for (SessionTask<?> task : this.executions) {
            task.cancel();
        }
        this.executions.clear();
        if (this.logChangeNotifier != null) {
            this.logChangeNotifier.close();
        }
    }

    private void handleTaskError(@NonNull Throwable e) {
        assert (Thread.holdsLock(this));
        if (!(e instanceof CancellationException)) {
            LOG.error("Failed to execute session task", e);
        }
    }

    private Set<LogPath> toPathSet(@NonNull LogList logList) {
        LinkedHashSet<LogPath> res = new LinkedHashSet<LogPath>();
        if (logList.getPathsInLegacyFormat() != null) {
            for (String pathFromHttpParameter : logList.getPathsInLegacyFormat()) {
                LvPathResolver resolver;
                pathFromHttpParameter = pathFromHttpParameter.trim();
                Collection<LogPath> paths = null;
                Iterator<LvPathResolver> iterator = this.pathResolvers.iterator();
                while (iterator.hasNext() && (paths = (resolver = iterator.next()).resolvePath(pathFromHttpParameter)) == null) {
                }
                if (paths == null) {
                    paths = LogPath.parsePathFromHttpParameter(pathFromHttpParameter);
                }
                res.addAll(paths);
            }
        }
        if (logList.getFiles() != null) {
            for (String file : logList.getFiles()) {
                res.add(new LogPath(null, file));
            }
        }
        if (logList.getSsh() != null) {
            for (String sshPath : logList.getSsh()) {
                LogSession.parseSshPath(res, sshPath);
            }
        }
        if (logList.getBookmarks() != null) {
            block4: for (String bookmark : logList.getBookmarks()) {
                for (LvPathResolver resolver : this.pathResolvers) {
                    Collection<LogPath> paths = resolver.resolvePath(bookmark);
                    if (paths == null) continue;
                    res.addAll(paths);
                    continue block4;
                }
            }
        }
        return res;
    }

    private static void parseSshPath(Set<LogPath> res, String sshPath) {
        throw new UnsupportedOperationException();
    }

    public static LogSession fromContext(@NonNull SessionAdapter sender, @NonNull ApplicationContext ctx) {
        LogSession res = new LogSession(sender);
        ctx.getAutowireCapableBeanFactory().autowireBeanProperties((Object)res, 0, false);
        return res;
    }

    private class SendEventTask
    extends TimerTask {
        private final EventSearchResponse eventSearchResponse;
        private boolean isSent;
        private boolean isCanceled;

        public SendEventTask(EventSearchResponse eventSearchResponse) {
            this.eventSearchResponse = eventSearchResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogSession logSession = LogSession.this;
            synchronized (logSession) {
                try {
                    if (this.isCanceled || !LogSession.this.checkStateVersion(this.eventSearchResponse.stateVersion)) {
                        return;
                    }
                    LogSession.this.sender.send(this.eventSearchResponse);
                }
                catch (RuntimeException e) {
                    LOG.error("Failed to send message", (Throwable)e);
                }
                this.isSent = true;
            }
        }

        @Override
        public boolean cancel() {
            boolean res = super.cancel();
            this.isCanceled = true;
            return res;
        }
    }

    private abstract class LogExecutionHandler<T>
    implements BiConsumer<T, Throwable> {
        protected final long initStateVersion;

        LogExecutionHandler() {
            assert (Thread.holdsLock(LogSession.this));
            this.initStateVersion = LogSession.this.stateVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(T res, Throwable e) {
            try {
                LogSession logSession = LogSession.this;
                synchronized (logSession) {
                    if (this.initStateVersion != LogSession.this.stateVersion) {
                        return;
                    }
                    if (e != null) {
                        LogSession.this.handleTaskError(e);
                    } else {
                        this.handle(res);
                    }
                }
            }
            catch (Throwable e1) {
                LOG.error("Failed to handle request", e1);
            }
        }

        protected abstract void handle(T var1);
    }
}

