/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.services;

import com.logviewer.api.LvPermalinkStorage;
import com.logviewer.data2.config.ConfigDirHolder;
import com.logviewer.domain.Permalink;
import com.logviewer.utils.LvGsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;

public class LvPermalinkStorageImpl
implements LvPermalinkStorage {
    private final ConfigDirHolder environment;

    public LvPermalinkStorageImpl(ConfigDirHolder environment) {
        this.environment = environment;
    }

    private Path getPermalinkDir() {
        return this.environment.getConfigDir().resolve("permalinks");
    }

    @Override
    public String save(@Nullable String hash, @NonNull Permalink link) throws IOException {
        Path permalinksDir = this.getPermalinkDir();
        if (!Files.isDirectory(permalinksDir, new LinkOption[0])) {
            Files.createDirectory(permalinksDir, new FileAttribute[0]);
        }
        byte[] json = LvGsonUtils.GSON.toJson((Object)link).getBytes(StandardCharsets.UTF_8);
        if (hash == null) {
            hash = DigestUtils.md5DigestAsHex((byte[])json).substring(0, 10);
        }
        Files.write(permalinksDir.resolve(hash + ".link"), json, new OpenOption[0]);
        return hash;
    }

    @Override
    public Permalink load(String hash) throws IOException {
        Path permalinkFile = this.getPermalinkDir().resolve(hash + ".link");
        try (BufferedReader reader = Files.newBufferedReader(permalinkFile, StandardCharsets.UTF_8);){
            Permalink permalink = (Permalink)LvGsonUtils.GSON.fromJson((Reader)reader, Permalink.class);
            return permalink;
        }
    }
}

