/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats;

import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import java.nio.charset.Charset;
import org.springframework.lang.Nullable;

public class SimpleLogFormat
implements LogFormat {
    private Charset charset;

    public SimpleLogFormat() {
        this(null);
    }

    public SimpleLogFormat(@Nullable Charset charset) {
        this.charset = charset;
    }

    @Override
    public LogReader createReader() {
        return new DefaultReader();
    }

    @Override
    public LogFormat.FieldDescriptor[] getFields() {
        return LogFormat.FieldDescriptor.EMPTY_ARRAY;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public boolean hasFullDate() {
        return false;
    }

    @Override
    public void validate() throws IllegalArgumentException {
    }

    @Override
    public String getHumanReadableString() {
        return "simple format: each line is an event";
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    private class DefaultReader
    extends LogReader {
        private String s;
        private long start;
        private long end;
        private boolean hasMore;
        private final Charset charset;

        private DefaultReader() {
            this.charset = SimpleLogFormat.this.charset == null ? Charset.defaultCharset() : SimpleLogFormat.this.charset;
        }

        @Override
        public boolean parseRecord(byte[] data, int offset, int length, long start, long end) {
            this.s = new String(data, offset, length, this.charset);
            this.start = start;
            this.end = end;
            this.hasMore = (long)length < end - start;
            return true;
        }

        @Override
        public boolean canAppendTail() {
            return false;
        }

        @Override
        public void appendTail(byte[] data, int offset, int length, long realLength) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasParsedRecord() {
            return this.s != null;
        }

        @Override
        public void clear() {
            this.s = null;
        }

        @Override
        public LogRecord buildRecord() {
            if (this.s == null) {
                throw new IllegalStateException();
            }
            LogRecord res = new LogRecord(this.s, 0L, this.start, this.end, this.hasMore);
            this.s = null;
            return res;
        }
    }
}

