/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats;

import com.logviewer.data2.DefaultFieldDesciptor;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogReader;
import com.logviewer.data2.LogRecord;
import com.logviewer.formats.utils.LvLayoutClassNode;
import com.logviewer.formats.utils.LvLayoutCustomTypeNode;
import com.logviewer.formats.utils.LvLayoutDateNode;
import com.logviewer.formats.utils.LvLayoutNode;
import com.logviewer.formats.utils.LvLayoutNodeSearchable;
import com.logviewer.formats.utils.LvLayoutStretchNode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DefaultFieldSet {
    private final Charset charset;
    private final LvLayoutNode[] layout;
    private final boolean canAppendTail;
    private final LogFormat.FieldDescriptor[] fields;
    private final int[] fieldIndex;
    private final Map<String, Integer> fieldNameIndexes = new LinkedHashMap<String, Integer>();
    private final int dateNodeIndex;

    public DefaultFieldSet(@Nullable Charset charset, LvLayoutNode ... layout) {
        this(charset, DefaultFieldSet.canAppendTail(layout), layout);
    }

    public DefaultFieldSet(@Nullable Charset charset, boolean canAppendTail, LvLayoutNode ... layout) {
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.layout = (LvLayoutNode[])layout.clone();
        this.canAppendTail = canAppendTail;
        ArrayList<DefaultFieldDesciptor> fields = new ArrayList<DefaultFieldDesciptor>();
        HashMap<String, AtomicInteger> existsField = new HashMap<String, AtomicInteger>();
        int[] fieldIndex = new int[layout.length];
        int dateNodeIndex = -1;
        for (int i = 0; i < layout.length; ++i) {
            LvLayoutNode node = layout[i];
            DefaultFieldDesciptor field = null;
            if (node instanceof LvLayoutDateNode) {
                if (((LvLayoutDateNode)node).isFull() && dateNodeIndex == -1) {
                    dateNodeIndex = i;
                }
                field = new DefaultFieldDesciptor(DefaultFieldSet.generateName(existsField, "date"), "date");
            } else if (node instanceof LvLayoutClassNode) {
                field = new DefaultFieldDesciptor(DefaultFieldSet.generateName(existsField, "logger"), "class");
            } else if (node instanceof LvLayoutCustomTypeNode) {
                LvLayoutCustomTypeNode sn = (LvLayoutCustomTypeNode)node;
                field = new DefaultFieldDesciptor(DefaultFieldSet.generateName(existsField, sn.getFieldName()), sn.getFieldType());
            }
            if (field != null) {
                this.fieldNameIndexes.put(field.name(), fields.size());
                fieldIndex[i] = fields.size();
                fields.add(field);
                continue;
            }
            fieldIndex[i] = -1;
        }
        this.dateNodeIndex = dateNodeIndex;
        this.fields = fields.toArray(LogFormat.FieldDescriptor.EMPTY_ARRAY);
        this.fieldIndex = fieldIndex;
    }

    public LvLayoutNode[] getLayout() {
        return this.layout;
    }

    private static String generateName(Map<String, AtomicInteger> fields, String name) {
        int nameIndex = fields.computeIfAbsent(name, key -> new AtomicInteger()).getAndIncrement();
        if (nameIndex > 0) {
            name = name + '_' + nameIndex;
        }
        return name;
    }

    public LogFormat.FieldDescriptor[] getFields() {
        return this.fields;
    }

    @NonNull
    public Charset getEncoding() {
        return this.charset;
    }

    @NonNull
    public LogReader createReader() {
        return new LogReaderImpl();
    }

    public boolean hasFullDate() {
        return this.dateNodeIndex >= 0;
    }

    public static boolean canAppendTail(@NonNull LvLayoutNode[] nodes) {
        if (nodes.length == 0) {
            return false;
        }
        LvLayoutNode lastNode = nodes[nodes.length - 1];
        return lastNode instanceof LvLayoutStretchNode;
    }

    private static boolean spacesOnlyAfter(String s, int offset, int end) {
        while (offset < end) {
            if (s.charAt(offset) != ' ') {
                return false;
            }
            ++offset;
        }
        return true;
    }

    private class LogReaderImpl
    extends LogReader {
        private final LvLayoutNode[] layoutCopy;
        private final int[] fieldOffset;
        private final LongSupplier dateExtractor;
        private final int[] stretchFields;
        private String s;
        private long start;
        private long end;
        private boolean hasMore;

        public LogReaderImpl() {
            this.fieldOffset = new int[DefaultFieldSet.this.fields.length * 2];
            this.layoutCopy = (LvLayoutNode[])DefaultFieldSet.this.layout.clone();
            for (int i = 0; i < this.layoutCopy.length; ++i) {
                this.layoutCopy[i] = this.layoutCopy[i].clone();
            }
            this.dateExtractor = this.createDateExtractor();
            this.stretchFields = new int[this.layoutCopy.length];
        }

        @Nullable
        private LongSupplier createDateExtractor() {
            if (DefaultFieldSet.this.dateNodeIndex < 0) {
                return null;
            }
            LvLayoutDateNode dateNode = (LvLayoutDateNode)this.layoutCopy[DefaultFieldSet.this.dateNodeIndex];
            int dateOffset = DefaultFieldSet.this.fieldIndex[DefaultFieldSet.this.dateNodeIndex] * 2;
            return () -> {
                int dateStart = this.fieldOffset[dateOffset];
                if (dateStart < 0) {
                    return -1L;
                }
                return dateNode.getCurrentDate();
            };
        }

        @Override
        public boolean parseRecord(byte[] data, int offset, int length, long start, long end) {
            String s = new String(data, offset, length, DefaultFieldSet.this.charset);
            int idx = 0;
            int endStr = s.length();
            int stretchFieldSize = 0;
            int i = 0;
            block0: while (true) {
                int nextIdx;
                if (i == this.layoutCopy.length) {
                    if (idx == endStr || DefaultFieldSet.spacesOnlyAfter(s, idx, endStr)) break;
                    nextIdx = -2147483647;
                } else {
                    LvLayoutNode part = this.layoutCopy[i];
                    if (part.removeSpacesBefore()) {
                        while (idx < endStr && s.charAt(idx) == ' ') {
                            ++idx;
                        }
                    }
                    if (part instanceof LvLayoutStretchNode) {
                        LvLayoutStretchNode stretchNode = (LvLayoutStretchNode)part;
                        if (stretchNode.reset(s, idx, endStr)) {
                            if (i + 1 < this.layoutCopy.length) {
                                this.stretchFields[stretchFieldSize++] = i;
                                idx = stretchNode.getEnd();
                                assert (idx <= endStr);
                                ++i;
                                continue;
                            }
                            if (stretchNode.grow(s, endStr, endStr)) {
                                assert (stretchNode.getEnd() == endStr);
                                this.stretchFields[stretchFieldSize++] = i;
                                break;
                            }
                        }
                        nextIdx = -2147483647;
                    } else {
                        nextIdx = part.parse(s, idx, endStr);
                    }
                }
                if (nextIdx == -2147483647) {
                    while (true) {
                        if (stretchFieldSize == 0) {
                            return false;
                        }
                        i = this.stretchFields[stretchFieldSize - 1];
                        LvLayoutStretchNode stretchNode = (LvLayoutStretchNode)this.layoutCopy[i];
                        if (stretchNode.getEnd() < endStr) {
                            LvLayoutNode nextNode;
                            if (!((nextNode = this.layoutCopy[++i]) instanceof LvLayoutNodeSearchable)) {
                                if (stretchNode.grow(s, stretchNode.getEnd() + 1, endStr)) {
                                    idx = stretchNode.getEnd();
                                    continue block0;
                                }
                            } else {
                                int searchNext;
                                idx = stretchNode.getEnd() + 1;
                                while ((searchNext = ((LvLayoutNodeSearchable)((Object)nextNode)).search(s, idx, endStr)) >= 0 && stretchNode.grow(s, searchNext, endStr)) {
                                    idx = stretchNode.getEnd();
                                    if (idx == searchNext) continue block0;
                                    assert (idx > searchNext);
                                }
                            }
                        }
                        --stretchFieldSize;
                    }
                }
                int fieldIdx = DefaultFieldSet.this.fieldIndex[i];
                if (nextIdx == Integer.MIN_VALUE) {
                    if (fieldIdx >= 0) {
                        this.fieldOffset[fieldIdx * 2] = -1;
                        this.fieldOffset[fieldIdx * 2 + 1] = -1;
                    }
                } else {
                    if (fieldIdx >= 0) {
                        this.fieldOffset[fieldIdx * 2] = this.layoutCopy[i].getValueStart(s, idx, endStr);
                        this.fieldOffset[fieldIdx * 2 + 1] = nextIdx;
                    }
                    idx = nextIdx;
                }
                ++i;
            }
            this.s = s;
            this.start = start;
            this.end = end;
            this.hasMore = (long)length < end - start;
            for (i = 0; i < stretchFieldSize; ++i) {
                int nodeIdx = this.stretchFields[i];
                LvLayoutStretchNode stretchField = (LvLayoutStretchNode)this.layoutCopy[nodeIdx];
                int fieldIdx = DefaultFieldSet.this.fieldIndex[nodeIdx];
                if (fieldIdx < 0) continue;
                this.fieldOffset[fieldIdx * 2] = stretchField.getValueStart(s, stretchField.getStart(), stretchField.getEnd());
                this.fieldOffset[fieldIdx * 2 + 1] = stretchField.getEnd();
            }
            return true;
        }

        @Override
        public boolean canAppendTail() {
            return DefaultFieldSet.this.canAppendTail;
        }

        @Override
        public void appendTail(byte[] data, int offset, int length, long realLength) {
            if (length == 0) {
                return;
            }
            this.end += realLength;
            if (this.hasMore) {
                return;
            }
            int lastFieldOffset = (DefaultFieldSet.this.fields.length - 1) * 2;
            if (this.fieldOffset[lastFieldOffset] == -1) {
                throw new IllegalStateException();
            }
            if (this.fieldOffset[lastFieldOffset + 1] != this.s.length()) {
                throw new IllegalStateException();
            }
            this.s = this.s + new String(data, offset, length, DefaultFieldSet.this.charset);
            this.fieldOffset[lastFieldOffset + 1] = this.s.length();
        }

        @Override
        public boolean hasParsedRecord() {
            return this.s != null;
        }

        @Override
        public void clear() {
            this.s = null;
        }

        @Override
        public LogRecord buildRecord() {
            if (this.s == null) {
                throw new IllegalStateException();
            }
            long time = 0L;
            if (this.dateExtractor != null) {
                time = this.dateExtractor.getAsLong();
            }
            LogRecord res = new LogRecord(this.s, time, this.start, this.end, this.hasMore, (int[])this.fieldOffset.clone(), DefaultFieldSet.this.fieldNameIndexes);
            this.s = null;
            return res;
        }
    }
}

