/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.FieldTypes;
import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.RegexUtils;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class ThreadPredicate
implements RecordPredicate {
    private String[] includes;
    private String[] excludes;
    private volatile transient Predicate<String>[] includePredicate;
    private volatile transient Predicate<String>[] excludePredicate;

    public ThreadPredicate() {
    }

    public ThreadPredicate(String[] includes, String[] excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    private Predicate<String> toPredicate(@NonNull String thread) {
        int idx = thread.indexOf(42);
        if (idx < 0) {
            return t -> t.equals(thread);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < thread.length(); ++i) {
            char a = thread.charAt(i);
            if (a == '*') {
                sb.append(".*");
                continue;
            }
            RegexUtils.escapePattern(sb, a);
        }
        return Pattern.compile(sb.toString(), 2).asPredicate();
    }

    @Nullable
    private Predicate<String>[] getIncludePredicate() {
        if (this.includes == null) {
            return null;
        }
        Predicate<String>[] res = this.includePredicate;
        if (res == null) {
            res = new Predicate[this.includes.length];
            for (int i = 0; i < this.includes.length; ++i) {
                res[i] = this.toPredicate(this.includes[i]);
            }
            this.includePredicate = res;
        }
        return res;
    }

    @Nullable
    private Predicate<String>[] getExcludePredicate() {
        if (this.excludes == null) {
            return null;
        }
        Predicate<String>[] res = this.excludePredicate;
        if (res == null) {
            res = new Predicate[this.excludes.length];
            for (int i = 0; i < this.excludes.length; ++i) {
                res[i] = this.toPredicate(this.excludes[i]);
            }
            this.excludePredicate = res;
        }
        return res;
    }

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        for (LogFormat.FieldDescriptor field : ctx.getFields()) {
            String fieldValue;
            if (!FieldTypes.is(field.type(), "thread") || (fieldValue = record.getFieldText(field.name())) == null || fieldValue.isEmpty()) continue;
            Predicate<String>[] includePredicate = this.getIncludePredicate();
            if (includePredicate != null && includePredicate.length > 0 && !this.anyMatches(includePredicate, fieldValue)) {
                return false;
            }
            Predicate<String>[] excludePredicate = this.getExcludePredicate();
            if (excludePredicate == null || !this.anyMatches(excludePredicate, fieldValue)) continue;
            return false;
        }
        return true;
    }

    private boolean anyMatches(@NonNull Predicate<String>[] predicates, @NonNull String thread) {
        for (Predicate<String> predicate : predicates) {
            if (!predicate.test(thread)) continue;
            return true;
        }
        return false;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public ThreadPredicate setIncludes(String[] includes) {
        this.includes = includes;
        return this;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public ThreadPredicate setExcludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }
}

